<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="card border-0 shadow">
                <div class="card-header bg-primary text-white py-3">
                    <h2 class="h5 mb-0">
                        <i class="fas fa-book me-2"></i>
                        Gestão de Disciplinas
                    </h2>
                </div>

                <div class="card-body">
                    <div class="row g-4">
                        <!-- Coluna Esquerda: Formulário -->
                        <div class="col-md-6">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-header bg-light">
                                    <h3 class="h6 mb-0">
                                        <i class="fas fa-plus-circle me-2"></i>
                                        Adicionar Disciplina
                                    </h3>
                                </div>

                                <div class="card-body">
                                    <form wire:submit.prevent="submit" class="needs-validation" novalidate>
                                        <!-- Nome da Disciplina -->
                                        <div class="form-group mb-4">
                                            <label for="name" class="form-label fw-semibold">Nome da Disciplina <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-book-open"></i></span>
                                                <input type="text"
                                                       id="name"
                                                       wire:model="name"
                                                       class="form-control @error('name') is-invalid @enderror"
                                                       placeholder="Ex: Matemática"
                                                       required>
                                            </div>
                                            @error('name') <span class="text-danger small">{{ $message }}</span> @enderror
                                        </div>

                                        <!-- Botões -->
                                        <div class="d-grid gap-2">
                                            <button type="submit"
                                                    class="btn btn-primary btn-lg"
                                                    wire:loading.attr="disabled"
                                                    wire:offline.attr="disabled">
                                                <span wire:loading.remove wire:target="submit">
                                                    <i class="fas fa-save me-2"></i>Guardar
                                                </span>
                                                <span wire:loading wire:target="submit">
                                                    <span class="spinner-border spinner-border-sm me-2"></span>
                                                    Processando...
                                                </span>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <!-- Coluna Direita: Lista Recente -->
                        <div class="col-md-6">
                            <div class="card border-0 shadow-sm h-100">
                                <div class="card-header bg-light d-flex justify-content-between align-items-center">
                                    <h3 class="h6 mb-0">
                                        <i class="fas fa-list me-2"></i>
                                        Disciplinas Recentes
                                    </h3>
                                    <a href="{{ route('admin.list.subjects') }}" class="btn btn-sm btn-outline-primary">
                                        <i class="fas fa-eye me-1"></i>Ver Todas
                                    </a>
                                </div>

                                <div class="card-body p-0">
                                    @if($recentSubjects->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-hover mb-0">
                                                <thead class="table-light">
                                                    <tr>
                                                        <th class="text-center" style="width: 50px;">#</th>
                                                        <th>Nome da Disciplina</th>
                                                        <th class="text-center" style="width: 120px;">Data</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($recentSubjects as $index => $subject)
                                                        <tr>
                                                            <td class="text-center text-muted">{{ $index + 1 }}</td>
                                                            <td>
                                                                <div class="d-flex align-items-center">
                                                                    <div class="avatar-circle bg-info text-white me-2">
                                                                        {{ substr($subject->name, 0, 1) }}
                                                                    </div>
                                                                    <div>
                                                                        <div class="fw-semibold">{{ $subject->name }}</div>
                                                                    </div>
                                                                </div>
                                                            </td>
                                                            <td class="text-center">
                                                                <small class="text-muted">{{ $subject->created_at->format('d/m/Y') }}</small>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @else
                                        <div class="text-center py-5">
                                            <i class="fas fa-book text-muted" style="font-size: 3rem;"></i>
                                            <p class="text-muted mt-3 mb-0">Nenhuma disciplina adicionada ainda</p>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .avatar-circle {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            font-size: 14px;
        }

        .form-label.fw-semibold {
            font-weight: 600;
            color: #495057;
        }

        .input-group-text {
            background-color: #f8f9fa;
            border-right: none;
        }

        .input-group .form-control,
        .input-group .form-select {
            border-left: none;
        }

        .input-group .form-control:focus,
        .input-group .form-select:focus {
            border-color: #ced4da;
            box-shadow: none;
        }

        .input-group:focus-within .input-group-text {
            border-color: #80bdff;
        }

        .table tbody tr {
            transition: all 0.2s;
        }

        .table tbody tr:hover {
            background-color: #f8f9fa;
            transform: translateX(2px);
        }

        .card-header.bg-light {
            background-color: #f8f9fa !important;
            border-bottom: 1px solid #dee2e6;
        }
    </style>
</div>
