<div>
    <div class="container">
        <div class="row justify-content-md-center">
            <div class="col-md-12 col-lg-4">
                <div class="card login-box-container">
                    <div class="card-body">
                        <div class="authent-logo">
                            <a href="{{ route('admin.login') }}"> <img src="{{ asset('assets/images/logo.png') }}"
                                                                       alt=""
                                                                       style="width:300px"></a>
                        </div>
                        <div class="authent-text">
                            <p>Redefinir senha</p>
                            @include('inc.alert')
                        </div>
                        <form wire:submit.prevent="resetPassword">
                            <div class="mb-3">
                                <div class="form-floating">
                                    <input type="email" class="form-control @error('email') is-invalid @enderror"
                                           name="email" placeholder="E-mail"
                                           id="email" wire:model="email">
                                    <label for="email">E-mail</label>
                                    @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="form-floating">
                                    <input type="password"
                                           class="form-control @error('password') is-invalid @enderror" required
                                           name="password" id="password" wire:model="password"
                                           placeholder="XXXXXXXX">
                                    <label for="password">Senha</label>
                                    @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="form-floating">
                                    <input id="password-confirm" type="password" class="form-control"
                                           wire:model="password_confirmation"
                                           name="password_confirmation" required
                                           autocomplete="new-password" placeholder="XXXXXXXX">
                                    <label for="password-confirm" class="float-left">Confirmar senha</label>
                                </div>
                            </div>
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary m-b-xs" wire:loading.class="disabled"
                                        wire:offline.attr="disabled"><span wire:target="loginUser"
                                                                           wire:loading.class="spinner-border spinner-border-lg"></span>
                                    RESETAR A SENHA
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
