<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
              <div class="row">
                  <div class="col-xl-12">
                    <div class="profile-cover"></div>
                       <div class="profile-header">
                            <div class="profile-img">
                                @if ($user->avatar)
                                <img src="{{ asset($user->avatar) }}" alt="Avatar" class="rounded-circle" style="width: 100px; height: 100px;">
                                @else
                                    <img src="{{ \App\Http\Controllers\SystemController::generateAvatars($user->name, 400) }}" alt="Avatar">
                                @endif
                            </div>
                            <div class="profile-name">
                            <h3>{{ $user->name }}</h3>
                             </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            <form class="row g-3" wire:submit.prevent="submit">
                                <div class="col-md-6">
                                    <div class="form-floating">
                                        <input type="text"
                                               class="form-control @error('name') is-invalid @enderror"
                                               id="name" required placeholder="Insira o nome completo..."
                                               wire:model="name" disabled>
                                        <label for="name">Nome</label>
                                        @error('name')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-floating">
                                        <input type="email"
                                               class="form-control @error('email') is-invalid @enderror"
                                               id="email" required placeholder="Insira o email..."
                                               wire:model="email">
                                        <label for="email">E-mail</label>
                                        @error('email')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-floating">
                                        <input type="text"
                                               class="form-control @error('phone_number') is-invalid @enderror"
                                               id="phone_number" required placeholder="Insira o número celular..."
                                               wire:model="phone_number" disabled>
                                        <label for="phone_number">Número celular</label>
                                        @error('phone_number')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-floating">
                                        <input type="file" class="form-control @error('avatar') is-invalid @enderror" id="avatar" required wire:model="avatar">
                                        <label for="avatar">Foto</label>
                                        @error('avatar')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>



                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary btn-lg float-end"
                                            wire:loading.class="disabled"
                                            wire:offline.attr="disabled"><span wire:target="submit"
                                                                               wire:loading.class="spinner-border spinner-border-lg"></span>
                                        Guardar
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
