<?php 
$class_id = "";
$mfd_count = 0;
$get_class = "";
$classname = "";
$subjects = [];
$ne_subjects = [];

// Query to fetch all subjects from the exams table
$subjects = \App\Models\Exam::query()->select('subject_id')->distinct()->pluck('subject_id')->toArray();
// Query to fetch all NE subjects based on class ID and name
$ne_subjects = getNESubjects($class_id, $classname);
$divide = count($subjects);
// Function to get NE subjects based on class ID and name
function getNESubjects($class_id, $classname) {
    $ne_subjects = [];
    if ($class_id == 6) {
        $ne_subjects = ["Português","Matemática","Ciências naturais","Ciências sociais"];

    } elseif ($class_id == 10) {
        $ne_subjects = ["Português","Matemática","Inglês","História","Geografia","Física","Química","Biologia"];

    } elseif (($class_id == 12) && $classname == "Turma A") {
        $ne_subjects = ["Português","Matemática","Inglês","História","Geografia","Física","Filosofia"];

    } elseif (($class_id == 12) && $classname == "Turma B") {
        $ne_subjects = ["Português","Matemática","Inglês","História","Geografia","Física"];

    } elseif (($class_id == 12) && $classname == "Turma C") {
        $ne_subjects = ["Português","Matemática","Inglês","Filosofia","Física"]; 
    }
    return $ne_subjects;
}
?>

<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title"> Notas do estudante</h5>
                            <div class="row">
                                <div class="col-md-4">
                                <select wire:model="search" class="form-control">
                                @foreach($years as $value => $label)
                                <option value="{{ $value }}">{{ $label }}</option>
                                @endforeach
                                </select>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="table-responsive" wire:init="loadData">
                                        @if (count($models))
                                            <?php 

                                                foreach ($models as $model) {
                                                    $classroom = \App\Models\Classroom::query()->where("id", $model->classroom_id)->first();                                               
                                                    // Check if the classroom exists and is active
                                                    if ($classroom && $classroom->is_active) {
                                                        $class_id = $classroom->class; // Get the class ID
                                                        $classname = $classroom->name; // Get the class name  
                                                        break; // Exit the loop since we found both class ID and name
                                                    }
                                                    // If $classroom doesn't exist or is not active, continue to the next iteration
                                                    if ($class_id != 0) { // Check if class ID is already set
                                                        break; // Exit the loop if class ID is set but classroom is not active
                                                    }
                                                }                                             
                                            ?>
                                            <table class="table table-hover">
                                                <thead>
                                                    <th colspan="9"><b>Primeiro trimestre</b></th>
                                                    <th colspan="8"><b>Segundo trimestre</b></th>
                                                    <th colspan="6"><b>Terceiro trimestre</b></th>
                                                    <tr>
                                                        <th scope="col">Disciplina</th>
                                                        <th scope="col">ASC1</th>
                                                        <th scope="col">ASC2</th>
                                                        <th scope="col">MACS</th>
                                                        <th scope="col">AT</th>
                                                        <th scope="col">MT</th>
                                                        <th scope="col"></th>
                                                        <th colspan="2"><b></b></th>
                                                        <th scope="col">ASC1</th>
                                                        <th scope="col">ASC2</th>
                                                        <th scope="col">MACS</th>
                                                        <th scope="col">AT</th>
                                                        <th scope="col">MT</th>
                                                        <th scope="col"></th>
                                                        <th colspan="2"><b></b></th>
                                                        <th scope="col">ASC1</th>
                                                        <th scope="col">ASC2</th>
                                                        <th scope="col">MACS</th>
                                                        <th scope="col">AT</th>
                                                        <th scope="col">MT</th>
                                                        @if($get_class == 6 || $get_class == 10 || $get_class == 12)
                                                        <th scope="col">NE</th>
                                                        @endif
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @php( $mfd = 0 )
                                                    @php( $act3_bbNe = 0 )
                                                    @php( $mfd_count = 0 )
                                                    @php( $mfd_divide = 0 )
                                                    @php($count = 1)
                                                    @foreach ($models as $model)
                                                        <tr>
                                                            <?php
                                                            $sac1 = floatval(\App\Models\Exam::query()
                                                            ->where('trimester_id', 1)
                                                            ->where('classroom_id', $model->classroom_id)
                                                            ->where('subject_id', $model->subject_id)
                                                            ->where('student_id', $model->student_id)
                                                            ->where('year', $model->year)
                                                            ->first()->ACS1a ?? 0);
                                                            $sac2 = floatval(\App\Models\Exam::query()
                                                            ->where('trimester_id', 1)
                                                            ->where('classroom_id', $model->classroom_id)
                                                            ->where('subject_id', $model->subject_id)
                                                            ->where('student_id', $model->student_id)
                                                            ->where('year', $model->year)
                                                            ->first()->ACS2a ?? 0);
                                                            $sac3 = floatval(\App\Models\Exam::query()
                                                            ->where('trimester_id', 1)
                                                            ->where('classroom_id', $model->classroom_id)
                                                            ->where('subject_id', $model->subject_id)
                                                            ->where('student_id', $model->student_id)
                                                            ->where('year', $model->year)
                                                            ->first()->AT ?? 0);
                                                            ?>
                                                            <td>{{ $model->subject->name }}</td>
                                                            <td>{{ number_format($sac1, 2) }}</td>
                                                            <td>{{ number_format($sac2, 2) }}</td>
                                                            <td>{{ number_format(($sac1 + $sac2) * 0.5, 2) }}</td>
                                                            <td>{{ number_format($sac3, 2) }}</td>
                                                            <td>{{ number_format((($sac1 + $sac2) * 0.5 + $sac3) * 0.5, 2) }}</td>
                                                            <td></td>
                                                            <td></td>
                                                            <td></td>
                                                            <?php
                                                            $ac1 = floatval(\App\Models\Exam::query()
                                                            ->where('trimester_id', 2)
                                                            ->where('classroom_id', $model->classroom_id)
                                                            ->where('subject_id', $model->subject_id)
                                                            ->where('student_id', $model->student_id)
                                                            ->where('year', $model->year)
                                                            ->first()->ACS1a ?? 0);
                                                            $ac2 = floatval(\App\Models\Exam::query()
                                                            ->where('trimester_id', 2)
                                                            ->where('classroom_id', $model->classroom_id)
                                                            ->where('subject_id', $model->subject_id)
                                                            ->where('student_id', $model->student_id)
                                                            ->where('year', $model->year)
                                                            ->first()->ACS2a ?? 0);
                                                            $ac3 = floatval(\App\Models\Exam::query()
                                                            ->where('trimester_id', 2)
                                                            ->where('classroom_id', $model->classroom_id)
                                                            ->where('subject_id', $model->subject_id)
                                                            ->where('student_id', $model->student_id)
                                                            ->where('year', $model->year)
                                                            ->first()->AT ?? 0);
                                                            ?>
                                                            <td>{{ number_format($ac1, 2) }}</td>
                                                            <td>{{ number_format($ac2, 2) }}</td>
                                                            <td>{{ number_format(($ac1 + $ac2) * 0.5, 2) }}</td>
                                                            <td>{{ number_format($ac3, 2) }}</td>
                                                            <td>{{ number_format((($ac1 + $ac2) * 0.5 + $ac3) * 0.5, 2) }}</td>
                                                            <td></td>
                                                            <td></td>
                                                            <td></td>
                                                            <?php     
                                                            $ac4 = floatval(\App\Models\Exam::query()
                                                            ->where('trimester_id', 3)
                                                            ->where('classroom_id', $model->classroom_id)
                                                            ->where('subject_id', $model->subject_id)
                                                            ->where('student_id', $model->student_id)
                                                            ->where('year', $model->year)
                                                            ->first()->ACS1a ?? 0);

                                                            $ac5 = floatval(\App\Models\Exam::query()
                                                            ->where('trimester_id', 3)
                                                            ->where('classroom_id', $model->classroom_id)
                                                            ->where('subject_id', $model->subject_id)
                                                            ->where('student_id', $model->student_id)
                                                            ->where('year', $model->year)
                                                            ->first()->ACS2a ?? 0);

                                                            $ac6 = floatval(\App\Models\Exam::query()
                                                            ->where('trimester_id', 3)
                                                            ->where('classroom_id', $model->classroom_id)
                                                            ->where('subject_id', $model->subject_id)
                                                            ->where('student_id', $model->student_id)
                                                            ->where('year', $model->year)
                                                            ->first()->AT ?? 0);

                                                            $NE = \App\Models\Exam::query()
                                                            ->where('trimester_id', 3)
                                                            ->where('classroom_id', $model->classroom_id)
                                                            ->where('subject_id', $model->subject_id)
                                                            ->where('student_id', $model->student_id)
                                                            ->where('year', $model->year)
                                                            ->first()->NE ?? 'Disciplina sem exame';        
                                                            ?>

                                                            <td>{{ number_format($ac4, 2) }}</td>
                                                            <td>{{ number_format($ac5, 2) }}</td>
                                                            <td>{{ number_format(round(($ac4 + $ac5) * 0.5), 2) }}</td>
                                                            <td>{{ number_format($ac6, 2) }}</td>
                                                            <td>{{ number_format(round((($ac4 + $ac5) * 0.5 + $ac6) * 0.5), 2) }}</td>
                                                            <td>{{ $NE }}</td>

                                                            @php($nf1 = (((int)$sac1 + (int)$sac2) * 0.5 + $sac3) * 0.5)
                                                            @php($nf2 = (((int)$ac1 + (int)$ac2) * 0.5 + $ac3) * 0.5 )
                                                            @php($nf3 = (((int)$ac4 + (int)$ac5) * 0.5 + $ac6) * 0.5)     
                                                                               
                                                            @if($NE == 'Disciplina sem exame') 
                                                            @php ( $mfd = round(($nf1 + $nf2 + $nf3) / 3)) 
                                                            @else
                                                            @php ($mff = round(($nf1 + $nf2 + $nf3) / 3))
                                                            @php ($nf2 =  $mff * 2)  
                                                            @php ($mfd = round(($nf2 + $NE) / 3 ))
                                                            @endif
                                                            @php ($mfd_count += $mfd)
                                                            @php (print($mfd_count / $divide))
                                                            @if($mfd != 0)
                                                            @php ($mfd_divide++)
                                                            @endif 
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                            <h3 style="text-align:center;"> RESULTADO </h3>
                                            @if($get_class == 6 || $get_class == 10 || $get_class == 12)
                                            @php ($result = round($mfd_count / $divide))
                                            <h3 style="text-align:center;">
                                            @if($result <= 9)
                                            <span style="color: red;">REPROVADO</span>
                                            @else
                                            <span style="color: green;">APROVADO</span>
                                            @endif
                                            <h3 style="text-align:center;">MF: {{ $result }} </h3>
                                            </h3>
                                            @else
                                            @php ($result = round($mfd_count / $divide))
                                            <h3 style="text-align:center;">
                                            @if($result <= 9)        
                                            <span style="color: red;">NÃO TRANSITA</span>    
                                            @else
                                            <span style="color: green;">TRANSITA</span>
                                            @endif
                                            <h3 style="text-align:center;">MF: {{ $result }}</h3>
                                            </h3>
                                            @endif
                                            <div class="row float-end">
                                            {{ $models->links() }}
                                            </div>
                                            @else
                                            <br>
                                            <br>
                                            <div class="d-flex justify-content-center">
                                                <div wire:loading class="spinner-border text-primary" role="status">
                                                    <span class="sr-only">Processando...</span>
                                                </div>
                                            </div>
                                            <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>