<div class="page-content">
    <div class="container-fluid">
        <div class="row mb-4 mt-3">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="pt-3">
                        <h1 class="h3 mb-1 text-primary">
                            <i class="fas fa-cash-register me-2"></i>Cobrança de Taxas
                        </h1>
                        <p class="text-muted mb-0">
                            Selecione os estudantes para cobrança de taxas
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters Card -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <h5 class="card-title mb-4 text-primary">
                    <i class="fas fa-filter me-2"></i>Filtros de Seleção
                </h5>
                
                <div class="row g-3">
                    <!-- Ano Acadêmico -->
                    <div class="col-md-3">
                        <label for="year" class="form-label">Ano Acadêmico</label>
                        <select class="form-select" wire:model="selectedYear">
                            <?php $__currentLoopData = $availableYears; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($year); ?>"><?php echo e($year); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    
                    <!-- Classe -->
                    <div class="col-md-3">
                        <label for="class" class="form-label">Classe</label>
                        <select class="form-select" wire:model="selectedClass">
                            <option value="">Todas Classes</option>
                            <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($class->class); ?>"><?php echo e($class->class); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    
                    <!-- Turma -->
                    <?php if($selectedClass): ?>
                    <div class="col-md-3">
                        <label for="turma" class="form-label">Turma</label>
                        <select class="form-select" wire:model="selectedTurma">
                            <option value="">Todas Turmas</option>
                            <?php $__currentLoopData = $turmas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($turma->id); ?>"><?php echo e($turma->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <?php endif; ?>
                    
                    <!-- Search -->
                    <div class="col-md-3">
                        <label for="search" class="form-label">Pesquisar</label>
                        <div class="input-group">
                            <input type="text" class="form-control"
                                   wire:model.debounce.300ms="searchTerm"
                                   placeholder="Nome, email ou código">
                            <span class="input-group-text">
                                <i class="fas fa-search"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Students Card -->
        <div class="card border-0 shadow-sm">
            <div class="card-body p-0">
                <div class="d-flex justify-content-between align-items-center p-4 border-bottom">
                    <h5 class="card-title mb-0 text-primary">
                        <i class="fas fa-user-graduate me-2"></i>Lista de Estudantes
                        <span class="badge bg-primary ms-2"><?php echo e(count($students)); ?></span>
                    </h5>
                </div>

                <?php if($isLoading): ?>
                <div class="text-center py-5">
                    <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                        <span class="visually-hidden">Carregando...</span>
                    </div>
                    <p class="mt-3 mb-0">Carregando estudantes...</p>
                </div>
                <?php else: ?>
                <div class="table-responsive students-table-wrapper">
                    <table class="table table-hover align-middle mb-0 students-collection-table">
                        <thead class="bg-light">
                            <tr>
                                <th width="50px" class="ps-4">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="select-all">
                                    </div>
                                </th>
                                <th>Nome</th>
                                <th>Gênero</th>
                                <th>Email</th>
                                <th>Código</th>
                                <th>Ano</th>
                                <th class="text-end pe-4">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td class="ps-4" data-label="Selecionar">
                                    <div class="form-check">
                                        <input class="form-check-input student-checkbox"
                                               type="checkbox"
                                               wire:model="selectedStudents"
                                               value="<?php echo e($student['id']); ?>">
                                    </div>
                                </td>
                                <td data-label="Nome"><?php echo e($student['name']); ?></td>
                                <td data-label="Gênero"><?php echo e(ucfirst($student['sex'])); ?></td>
                                <td data-label="Email"><?php echo e($student['email']); ?></td>
                                <td data-label="Código"><?php echo e($student['student_id'] ?? 'N/A'); ?></td>
                                <td data-label="Ano"><?php echo e($student['year_edu'] ?? 'N/A'); ?></td>
                                <td class="pe-4" data-label="Ações">
                                    <div class="d-flex justify-content-end action-cell">
                                        <a href="<?php echo e(route('admin.fee.collect', $student['id'])); ?>"
                                           class="btn btn-sm btn-primary">
                                            <i class="fas fa-money-bill-wave me-1"></i>Cobrar
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="text-center py-4">
                                    <div class="py-5">
                                        <i class="fas fa-user-slash text-muted" style="font-size: 3rem;"></i>
                                        <h5 class="mt-3">Nenhum estudante encontrado</h5>
                                        <p class="text-muted">Ajuste os filtros para encontrar estudantes</p>
                                    </div>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>

                <?php if(count($students) > 0 && count($selectedStudents) > 0): ?>
                <div class="d-flex justify-content-between align-items-center p-4 border-top">
                    <div>
                        <span class="text-muted">
                            <?php echo e(count($selectedStudents)); ?> de <?php echo e(count($students)); ?> selecionados
                        </span>
                    </div>
                    <div class="d-flex">
                        <button class="btn btn-primary" wire:click="assignFeeGroup" wire:loading.attr="disabled">
                            <span wire:loading.remove>
                                <i class="fas fa-money-bill-wave me-1"></i>Cobrar Selecionados
                            </span>
                            <span wire:loading>
                                <span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>
                                Processando...
                            </span>
                        </button>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('livewire:load', function() {
        document.getElementById('select-all').addEventListener('change', function(e) {
            let checkboxes = document.querySelectorAll('.student-checkbox');
            checkboxes.forEach(checkbox => {
                checkbox.checked = e.target.checked;
                checkbox.dispatchEvent(new Event('change'));
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>

<style>
/* Mobile Responsive Styles for Fee Collection Students */
@media (max-width: 768px) {
    .container-fluid {
        padding-left: 10px;
        padding-right: 10px;
    }

    .row.mb-4.mt-3 {
        margin-bottom: 1rem !important;
        margin-top: 1rem !important;
    }

    .h3 {
        font-size: 1.3rem;
    }

    .card-body {
        padding: 1rem;
    }

    .row.g-3 > .col-md-3 {
        padding-bottom: 0.5rem;
    }

    .students-table-wrapper {
        overflow-x: visible !important;
    }

    .students-collection-table thead {
        display: none;
    }

    .students-collection-table tbody tr {
        display: block;
        margin-bottom: 1rem;
        border: 1px solid #dee2e6;
        border-radius: 10px;
        padding: 1rem;
        background: #fff;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
    }

    .students-collection-table tbody td {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 0.6rem 0;
        border: none;
        border-bottom: 1px solid #f1f3f4;
        text-align: left;
    }

    .students-collection-table tbody td:last-child {
        border-bottom: none;
        padding-top: 1rem;
    }

    .students-collection-table tbody td::before {
        content: attr(data-label);
        font-weight: 600;
        color: #495057;
        flex: 0 0 40%;
        font-size: 0.85rem;
    }

    .students-collection-table tbody td > *:not(.form-check):not(.action-cell) {
        flex: 1;
        text-align: right;
    }

    .students-collection-table tbody td .action-cell {
        width: 100%;
        justify-content: center !important;
    }

    .students-collection-table tbody td .action-cell .btn {
        width: 100%;
    }

    .d-flex.justify-content-between.align-items-center.p-4 {
        flex-direction: column;
        gap: 1rem;
        align-items: stretch !important;
    }

    .d-flex.justify-content-between.align-items-center.p-4 > div {
        width: 100%;
        text-align: center;
    }

    .d-flex.justify-content-between.align-items-center.p-4 .d-flex {
        justify-content: center;
    }

    .d-flex.justify-content-between.align-items-center.p-4 .btn {
        width: 100%;
    }
}

@media (max-width: 576px) {
    .h3 {
        font-size: 1.1rem;
    }

    .text-muted {
        font-size: 0.85rem;
    }

    .card-title {
        font-size: 1rem;
    }

    .form-label {
        font-size: 0.9rem;
    }

    .form-control, .form-select {
        font-size: 0.9rem;
    }

    .btn-sm {
        font-size: 0.8rem;
        padding: 0.4rem 0.8rem;
    }

    .students-collection-table tbody tr {
        padding: 0.75rem;
    }

    .students-collection-table tbody td {
        padding: 0.5rem 0;
        font-size: 0.85rem;
    }

    .students-collection-table tbody td::before {
        font-size: 0.8rem;
        flex: 0 0 35%;
    }
}

@media (max-width: 375px) {
    .container-fluid {
        padding-left: 5px;
        padding-right: 5px;
    }

    .card-body {
        padding: 0.75rem;
    }

    .h3 {
        font-size: 1rem;
    }

    .students-collection-table tbody tr {
        padding: 0.6rem;
    }

    .students-collection-table tbody td {
        flex-direction: column;
        align-items: flex-start;
    }

    .students-collection-table tbody td::before {
        margin-bottom: 0.3rem;
    }
}
</style>
<?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/livewire/admin/fee/fee-collect.blade.php ENDPATH**/ ?>