<div class="page-content">
    <div class="main-wrapper">
        <?php if($user->role == 0): ?>
            <!-- Admin Dashboard -->
            <div wire:init="loadData">

                <!-- Statistics Cards -->
                <div class="stats-grid">
                    <a href="<?php echo e(route('admin.list.students')); ?>" class="stat-card stat-students">
                        <div class="stat-icon-wrapper">
                            <div class="stat-icon">
                                <i class="fas fa-user-graduate"></i>
                            </div>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Estudantes</span>
                            <h2 class="stat-value"><?php echo e(number_format($students)); ?></h2>
                            <div class="stat-footer">
                                <span class="stat-trend positive">
                                    <i class="fas fa-arrow-up"></i> Ativos
                                </span>
                            </div>
                        </div>
                    </a>

                    <a href="<?php echo e(route('admin.list.classes')); ?>" class="stat-card stat-classes">
                        <div class="stat-icon-wrapper">
                            <div class="stat-icon">
                                <i class="fas fa-chalkboard"></i>
                            </div>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Turmas</span>
                            <h2 class="stat-value"><?php echo e(number_format($classes)); ?></h2>
                            <div class="stat-footer">
                                <span class="stat-trend">
                                    <i class="fas fa-users"></i> <?php echo e(now()->year); ?>

                                </span>
                            </div>
                        </div>
                    </a>

                    <a href="<?php echo e(route('admin.list.subjects')); ?>" class="stat-card stat-subjects">
                        <div class="stat-icon-wrapper">
                            <div class="stat-icon">
                                <i class="fas fa-book-open"></i>
                            </div>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Disciplinas</span>
                            <h2 class="stat-value"><?php echo e(number_format($subjects)); ?></h2>
                            <div class="stat-footer">
                                <span class="stat-trend">
                                    <i class="fas fa-layer-group"></i> Curriculares
                                </span>
                            </div>
                        </div>
                    </a>

                    <a href="<?php echo e(route('admin.list.admins')); ?>" class="stat-card stat-staff">
                        <div class="stat-icon-wrapper">
                            <div class="stat-icon">
                                <i class="fas fa-user-tie"></i>
                            </div>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Staff</span>
                            <h2 class="stat-value"><?php echo e(number_format($admins)); ?></h2>
                            <div class="stat-footer">
                                <span class="stat-trend">
                                    <i class="fas fa-briefcase"></i> Funcionários
                                </span>
                            </div>
                        </div>
                    </a>
                </div>

                <!-- Payment Statistics -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-3 gap-3">
                            <h5 class="mb-0"><i class="fas fa-money-bill-wave text-success me-2"></i>Estatísticas de Pagamentos</h5>

                            <!-- Period Filter -->
                            <div class="d-flex gap-2 flex-wrap align-items-center">
                                <div class="btn-group" role="group">
                                    <input type="radio" class="btn-check" wire:model="period" value="7days" id="period_7days" autocomplete="off">
                                    <label class="btn btn-sm btn-outline-primary" for="period_7days">7 Dias</label>

                                    <input type="radio" class="btn-check" wire:model="period" value="30days" id="period_30days" autocomplete="off">
                                    <label class="btn btn-sm btn-outline-primary" for="period_30days">30 Dias</label>

                                    <input type="radio" class="btn-check" wire:model="period" value="6months" id="period_6months" autocomplete="off">
                                    <label class="btn btn-sm btn-outline-primary" for="period_6months">6 Meses</label>

                                    <input type="radio" class="btn-check" wire:model="period" value="1year" id="period_1year" autocomplete="off">
                                    <label class="btn btn-sm btn-outline-primary" for="period_1year">1 Ano</label>

                                    <input type="radio" class="btn-check" wire:model="period" value="custom" id="period_custom" autocomplete="off">
                                    <label class="btn btn-sm btn-outline-primary" for="period_custom">Personalizado</label>
                                </div>

                                <?php if($period === 'custom'): ?>
                                    <div class="d-flex gap-2">
                                        <input type="date" wire:model="customDateFrom" class="form-control form-control-sm" placeholder="De">
                                        <input type="date" wire:model="customDateTo" class="form-control form-control-sm" placeholder="Até">
                                    </div>
                                <?php endif; ?>

                                <a href="<?php echo e(route('admin.fee.dashboard')); ?>" class="btn btn-sm btn-primary">
                                    <i class="fas fa-chart-line me-1"></i>Dashboard Completo
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Period Total Card - Enhanced with Breakdown -->
                    <div class="col-lg-4 col-md-6 mb-3">
                        <div class="card border-0 h-100" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);">
                            <div class="card-body text-white p-4">
                                <div class="d-flex justify-content-between align-items-start mb-3">
                                    <div>
                                        <p class="mb-1 opacity-90 fw-medium"><?php echo e($payment_stats['period_label']); ?></p>
                                        <h2 class="mb-0 fw-bold">MT <?php echo e(number_format($payment_stats['period_total'] ?? 0, 2, ',', '.')); ?></h2>

                                        <!-- Breakdown -->
                                        <div class="mt-2 pt-2 border-top border-white border-opacity-25">
                                            <div class="d-flex justify-content-between align-items-center mb-1">
                                                <small class="opacity-75">Valor Base:</small>
                                                <small class="fw-bold">MT <?php echo e(number_format($payment_stats['period_base'] ?? 0, 2, ',', '.')); ?></small>
                                            </div>
                                            <?php if(($payment_stats['period_fines'] ?? 0) > 0): ?>
                                            <div class="d-flex justify-content-between align-items-center mb-1">
                                                <small class="opacity-75">+ Multas:</small>
                                                <small class="fw-bold text-warning">MT <?php echo e(number_format($payment_stats['period_fines'], 2, ',', '.')); ?></small>
                                            </div>
                                            <?php endif; ?>
                                            <?php if(($payment_stats['period_discounts'] ?? 0) > 0): ?>
                                            <div class="d-flex justify-content-between align-items-center mb-1">
                                                <small class="opacity-75">- Descontos:</small>
                                                <small class="fw-bold text-success">MT <?php echo e(number_format($payment_stats['period_discounts'], 2, ',', '.')); ?></small>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="rounded-circle bg-white bg-opacity-20 p-3">
                                        <i class="fas fa-wallet fs-3"></i>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between align-items-center pt-3 border-top border-white border-opacity-25">
                                    <div>
                                        <small class="opacity-75 d-block">Total de Pagamentos</small>
                                        <strong class="fs-5"><?php echo e(number_format($payment_stats['period_count'] ?? 0)); ?></strong>
                                    </div>
                                    <div class="text-end">
                                        <small class="opacity-75 d-block">Período</small>
                                        <strong class="fs-6"><?php echo e($payment_stats['date_range']['start'] ?? ''); ?> - <?php echo e($payment_stats['date_range']['end'] ?? ''); ?></strong>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Average Payment Card - Enhanced -->
                    <div class="col-lg-4 col-md-6 mb-3">
                        <div class="card border-0 shadow-sm h-100 hover-lift">
                            <div class="card-body p-4">
                                <div class="d-flex justify-content-between align-items-start mb-3">
                                    <div>
                                        <p class="text-muted mb-1 fw-medium">Média por Pagamento</p>
                                        <h2 class="mb-0 fw-bold text-success">MT <?php echo e(($payment_stats['period_count'] ?? 0) > 0 ? number_format(($payment_stats['period_total'] ?? 0) / $payment_stats['period_count'], 2, ',', '.') : '0,00'); ?></h2>
                                    </div>
                                    <div class="rounded-circle bg-success bg-opacity-10 p-3">
                                        <i class="fas fa-chart-line text-success fs-3"></i>
                                    </div>
                                </div>
                                <div class="pt-3 border-top">
                                    <small class="text-muted">
                                        <i class="fas fa-info-circle me-1"></i>
                                        Calculado com base no período selecionado
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Pending References Card - Enhanced -->
                    <div class="col-lg-4 col-md-6 mb-3">
                        <div class="card border-0 shadow-sm h-100 hover-lift">
                            <div class="card-body p-4">
                                <div class="d-flex justify-content-between align-items-start mb-3">
                                    <div>
                                        <p class="text-muted mb-1 fw-medium">Referências Pendentes</p>
                                        <h2 class="mb-0 fw-bold text-warning"><?php echo e(number_format($payment_stats['pending_references'] ?? 0)); ?></h2>
                                    </div>
                                    <div class="rounded-circle bg-warning bg-opacity-10 p-3">
                                        <i class="fas fa-clock text-warning fs-3"></i>
                                    </div>
                                </div>
                                <div class="pt-3 border-top">
                                    <small class="text-muted">
                                        <i class="fas fa-hourglass-half me-1"></i>
                                        Aguardando confirmação de pagamento
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Period Payments Chart -->
                    <div class="col-12 mt-3">
                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-white border-bottom py-3">
                                <h5 class="mb-0">
                                    <i class="fas fa-chart-area text-primary me-2"></i>
                                    Pagamentos - <?php echo e($payment_stats['period_label']); ?>

                                </h5>
                            </div>
                            <div class="card-body">
                                <?php if($payment_stats['period_count'] > 0): ?>
                                    <canvas id="periodPaymentsChart" height="80"></canvas>
                                <?php else: ?>
                                    <div class="text-center py-5">
                                        <i class="fas fa-chart-line text-muted" style="font-size: 4rem; opacity: 0.3;"></i>
                                        <h5 class="mt-3 text-muted">Nenhum pagamento encontrado</h5>
                                        <p class="text-muted mb-0">Não há dados de pagamentos no período selecionado (<?php echo e($payment_stats['date_range']['start']); ?> - <?php echo e($payment_stats['date_range']['end']); ?>)</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Charts Section -->
                <div class="charts-grid" wire:ignore>
                    <!-- Overview Bar Chart -->
                    <div class="chart-card chart-main">
                        <div class="chart-header">
                            <div>
                                <h3 class="chart-title">
                                    <i class="fas fa-chart-bar"></i>
                                    Visão Geral do Sistema
                                </h3>
                                <p class="chart-subtitle">Classes, Disciplinas e Estudantes</p>
                            </div>
                            <div class="chart-legend">
                                <span class="legend-item">
                                    <span class="legend-dot" style="background: #4f46e5;"></span>
                                    Totais
                                </span>
                            </div>
                        </div>
                        <div class="chart-body">
                            <div id="chart3" class="chart-container"><?php echo $chart3->container(); ?></div>
                        </div>
                    </div>

                    <!-- Overview Pie Chart -->
                    <div class="chart-card chart-sidebar">
                        <div class="chart-header">
                            <div>
                                <h3 class="chart-title">
                                    <i class="fas fa-chart-pie"></i>
                                    Visão Geral
                                </h3>
                                <p class="chart-subtitle">Distribuição por categoria</p>
                            </div>
                        </div>
                        <div class="chart-body">
                            <div id="seo_pie_chart" class="chart-container"><?php echo $seo_pie_chart->container(); ?></div>
                        </div>
                    </div>
                </div>

                <!-- Student Distribution Chart -->
                <?php if(count($student_distribution) > 0): ?>
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="card shadow-sm border-0">
                            <div class="card-header bg-white border-bottom-0 pt-4 pb-3">
                                <h3 class="mb-0" style="color: #374151; font-weight: 600; font-size: 1.25rem;">
                                    <i class="fas fa-users" style="color: #667eea;"></i>
                                    📊 Distribuição de Estudantes
                                </h3>
                                <p class="text-muted mb-0 mt-1" style="font-size: 0.875rem;">Estudantes por classe e gênero</p>
                            </div>
                            <div class="card-body">
                                <canvas id="studentDistributionChart" height="80"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Quick Actions -->
                <div class="quick-actions-section">
                    <h3 class="section-title">
                        <i class="fas fa-bolt"></i>
                        Ações Rápidas
                    </h3>
                    <div class="quick-actions-grid">
                        <a href="<?php echo e(route('admin.add.student')); ?>" class="action-card">
                            <div class="action-icon" style="background: #e0f2fe; color: #0369a1;">
                                <i class="fas fa-user-plus"></i>
                            </div>
                            <h4>Novo Estudante</h4>
                            <p>Registar estudante</p>
                        </a>

                        <a href="<?php echo e(route('admin.add.class')); ?>" class="action-card">
                            <div class="action-icon" style="background: #dbeafe; color: #1e40af;">
                                <i class="fas fa-plus-circle"></i>
                            </div>
                            <h4>Nova Turma</h4>
                            <p>Criar turma</p>
                        </a>

                        <a href="<?php echo e(route('admin.fee.collectfee')); ?>" class="action-card">
                            <div class="action-icon" style="background: #dcfce7; color: #15803d;">
                                <i class="fas fa-money-bill-wave"></i>
                            </div>
                            <h4>Cobrar Taxa</h4>
                            <p>Processar pagamento</p>
                        </a>

                        <a href="<?php echo e(route('admin.report')); ?>" class="action-card">
                            <div class="action-icon" style="background: #fef3c7; color: #b45309;">
                                <i class="fas fa-file-alt"></i>
                            </div>
                            <h4>Relatórios</h4>
                            <p>Gerar relatórios</p>
                        </a>
                    </div>
                </div>
            </div>

        <?php elseif($user->role == 2): ?>
            <!-- Teacher Dashboard -->
            <div wire:init="loadData">
                <div class="dashboard-header">
                    <h1 class="header-title">
                        <i class="fas fa-chalkboard-teacher"></i>
                        Painel do Professor
                    </h1>
                </div>

                <div class="stats-grid" style="grid-template-columns: 1fr;">
                    <div class="stat-card stat-classes">
                        <div class="stat-icon-wrapper">
                            <div class="stat-icon">
                                <i class="fas fa-chalkboard"></i>
                            </div>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Minhas Turmas</span>
                            <h2 class="stat-value"><?php echo e($teacher_class); ?></h2>
                            <div class="stat-footer">
                                <span class="stat-trend">
                                    <i class="fas fa-calendar-alt"></i> Ano <?php echo e(now()->year); ?>

                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        <?php else: ?>
            <!-- Other Roles Dashboard -->
            <div class="dashboard-container" wire:init="loadData">
                <div class="stats-grid">
                    <div class="stat-card stat-students">
                        <div class="stat-icon-wrapper">
                            <div class="stat-icon">
                                <i class="fas fa-user-graduate"></i>
                            </div>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Estudantes</span>
                            <h2 class="stat-value"><?php echo e($students); ?></h2>
                        </div>
                    </div>

                    <div class="stat-card stat-classes">
                        <div class="stat-icon-wrapper">
                            <div class="stat-icon">
                                <i class="fas fa-chalkboard"></i>
                            </div>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Turmas</span>
                            <h2 class="stat-value"><?php echo e($classes); ?></h2>
                        </div>
                    </div>

                    <div class="stat-card stat-subjects">
                        <div class="stat-icon-wrapper">
                            <div class="stat-icon">
                                <i class="fas fa-book-open"></i>
                            </div>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Disciplinas</span>
                            <h2 class="stat-value"><?php echo e($subjects); ?></h2>
                        </div>
                    </div>

                    <div class="stat-card stat-staff">
                        <div class="stat-icon-wrapper">
                            <div class="stat-icon">
                                <i class="fas fa-user-tie"></i>
                            </div>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Staff</span>
                            <h2 class="stat-value"><?php echo e($admins); ?></h2>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <?php $__env->startSection('scripts'); ?>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.7.1/Chart.min.js" charset="utf-8"></script>
        <?php echo $chart3->script(); ?>

        <?php echo $seo_pie_chart->script(); ?>


        <script>
        // Store chart instance globally to destroy on updates
        let periodPaymentsChartInstance = null;

        function createPaymentChart() {
            <?php
                // Recalcular dados diretamente no Blade para evitar problemas de serialização do Livewire
                use Carbon\Carbon;
                use App\Models\Fee_assign;

                $bladeStart = now()->subDays(6)->startOfDay();
                $bladeEnd = now();

                if ($period === '30days') {
                    $bladeStart = now()->subDays(29)->startOfDay();
                } elseif ($period === '6months') {
                    $bladeStart = now()->subMonths(6)->startOfDay();
                } elseif ($period === '1year') {
                    $bladeStart = now()->subYear()->startOfDay();
                } elseif ($period === 'custom' && $customDateFrom && $customDateTo) {
                    $bladeStart = Carbon::parse($customDateFrom)->startOfDay();
                    $bladeEnd = Carbon::parse($customDateTo)->endOfDay();
                }

                $bladeDaysDiff = $bladeStart->diffInDays($bladeEnd);
                $bladeGroupBy = 'date';
                $bladeDateFormat = 'Y-m-d';

                // Se for mais de 180 dias, agrupar por mês
                if ($bladeDaysDiff > 180) {
                    $bladeGroupBy = 'month';
                    $bladeDateFormat = 'Y-m';
                }
                // Se for mais de 60 dias (mas menos de 180), agrupar por semana
                elseif ($bladeDaysDiff > 60) {
                    $bladeGroupBy = 'week';
                    $bladeDateFormat = 'Y-W';
                }

                $bladePayments = Fee_assign::whereBetween('created_at', [$bladeStart, $bladeEnd])
                    ->get()
                    ->groupBy(function($item) use ($bladeDateFormat) {
                        return $item->created_at->format($bladeDateFormat);
                    })
                    ->map(function($group) {
                        $base = $group->sum('amount');
                        $fines = $group->sum('fine');
                        $discounts = $group->sum('discount');
                        return [
                            'base' => (float) $base,
                            'fines' => (float) $fines,
                            'discounts' => (float) $discounts,
                            'total' => (float) ($base + $fines - $discounts),
                            'count' => $group->count()
                        ];
                    });
            ?>

            const paymentChartData = <?php echo json_encode($bladePayments, 15, 512) ?>;
            const groupBy = '<?php echo e($bladeGroupBy); ?>';

            console.log('Payment Chart Data (Blade):', paymentChartData);
            console.log('Group By:', groupBy);

            const periodPaymentsCtx = document.getElementById('periodPaymentsChart');
            if (!periodPaymentsCtx) {
                return; // Canvas doesn't exist (no data state)
            }

            // Destroy existing chart instance
            if (periodPaymentsChartInstance) {
                periodPaymentsChartInstance.destroy();
                periodPaymentsChartInstance = null;
            }

            // Prepare data with breakdown
            const dates = [];
            const baseAmounts = [];
            const fineAmounts = [];
            const discountAmounts = [];
            const totalAmounts = [];
            const counts = [];

            // Process data based on groupBy
            <?php if($bladeGroupBy === 'date'): ?>
                // Get all dates in range (PHP processing for day-by-day)
                <?php
                    $currentDate = $bladeStart->copy();
                    while ($currentDate <= $bladeEnd) {
                        $dateKey = $currentDate->format('Y-m-d');
                        $dateLabel = $currentDate->format('d/m');
                        echo "dates.push('{$dateLabel}');\n";
                        echo "const data_{$currentDate->format('Ymd')} = paymentChartData['{$dateKey}'];\n";
                        echo "baseAmounts.push(data_{$currentDate->format('Ymd')} ? parseFloat(data_{$currentDate->format('Ymd')}.base) : 0);\n";
                        echo "fineAmounts.push(data_{$currentDate->format('Ymd')} ? parseFloat(data_{$currentDate->format('Ymd')}.fines) : 0);\n";
                        echo "discountAmounts.push(data_{$currentDate->format('Ymd')} ? parseFloat(data_{$currentDate->format('Ymd')}.discounts) : 0);\n";
                        echo "totalAmounts.push(data_{$currentDate->format('Ymd')} ? parseFloat(data_{$currentDate->format('Ymd')}.total) : 0);\n";
                        echo "counts.push(data_{$currentDate->format('Ymd')} ? parseInt(data_{$currentDate->format('Ymd')}.count) : 0);\n";
                        $currentDate->addDay();
                    }
                ?>
            <?php else: ?>
                // Week or Month grouping (JavaScript processing)
                Object.keys(paymentChartData).forEach(key => {
                    let label = key;
                    if (groupBy === 'week') {
                        label = 'Sem ' + key.substr(-2);
                    } else if (groupBy === 'month') {
                        const parts = key.split('-');
                        const monthNames = ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'];
                        const monthIndex = parseInt(parts[1]) - 1;
                        label = monthNames[monthIndex] + '/' + parts[0].substr(-2);
                    }
                    dates.push(label);
                    baseAmounts.push(parseFloat(paymentChartData[key].base) || 0);
                    fineAmounts.push(parseFloat(paymentChartData[key].fines) || 0);
                    discountAmounts.push(parseFloat(paymentChartData[key].discounts) || 0);
                    totalAmounts.push(parseFloat(paymentChartData[key].total) || 0);
                    counts.push(parseInt(paymentChartData[key].count) || 0);
                });
            <?php endif; ?>

            console.log('Dates:', dates);
            console.log('Base Amounts:', baseAmounts);
            console.log('Fine Amounts:', fineAmounts);
            console.log('Discount Amounts:', discountAmounts);
            console.log('Total Amounts:', totalAmounts);
            console.log('Counts:', counts);

            periodPaymentsChartInstance = new Chart(periodPaymentsCtx, {
                    type: 'bar',
                    data: {
                        labels: dates,
                        datasets: [{
                            label: '💰 Valor Base',
                            data: baseAmounts,
                            backgroundColor: 'rgba(79, 70, 229, 0.85)',
                            borderColor: 'rgb(79, 70, 229)',
                            borderWidth: 1,
                            stack: 'stack0'
                        }, {
                            label: '⚠️ Multas',
                            data: fineAmounts,
                            backgroundColor: 'rgba(245, 158, 11, 0.85)',
                            borderColor: 'rgb(245, 158, 11)',
                            borderWidth: 1,
                            stack: 'stack0'
                        }, {
                            label: '🎁 Descontos',
                            data: discountAmounts.map(val => -val), // Negativo para subtrair visualmente
                            backgroundColor: 'rgba(239, 68, 68, 0.85)',
                            borderColor: 'rgb(239, 68, 68)',
                            borderWidth: 1,
                            stack: 'stack0'
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: true,
                        interaction: {
                            mode: 'index',
                            intersect: false
                        },
                        plugins: {
                            title: {
                                display: true,
                                text: '📊 Análise Financeira Detalhada - <?php echo e($payment_stats["period_label"]); ?>',
                                font: {
                                    size: 16,
                                    weight: 'bold'
                                },
                                padding: {
                                    top: 10,
                                    bottom: 20
                                },
                                color: '#374151'
                            },
                            legend: {
                                display: true,
                                position: 'bottom',
                                labels: {
                                    usePointStyle: true,
                                    padding: 15,
                                    font: {
                                        size: 12,
                                        weight: '600'
                                    },
                                    boxWidth: 12,
                                    boxHeight: 12
                                }
                            }
                        },
                        tooltips: {
                            mode: 'index',
                            intersect: false,
                            backgroundColor: 'rgba(0, 0, 0, 0.85)',
                            titleFontSize: 14,
                            titleFontStyle: 'bold',
                            bodyFontSize: 13,
                            borderColor: 'rgb(79, 70, 229)',
                            borderWidth: 2,
                            cornerRadius: 8,
                            xPadding: 15,
                            yPadding: 15,
                            displayColors: true,
                            callbacks: {
                                label: function(tooltipItem, data) {
                                    var label = data.datasets[tooltipItem.datasetIndex].label || '';
                                    if (label) {
                                        label += ': ';
                                    }
                                    var value = parseFloat(tooltipItem.yLabel) || 0;
                                    // Mostrar valor absoluto (descontos são negativos na stack)
                                    value = Math.abs(value);
                                    label += 'MT ' + value.toLocaleString('pt-MZ', {minimumFractionDigits: 2, maximumFractionDigits: 2});
                                    return label;
                                },
                                footer: function(tooltipItems, data) {
                                    // Adicionar cálculo detalhado no rodapé
                                    var index = tooltipItems[0].index;
                                    var base = parseFloat(baseAmounts[index]) || 0;
                                    var fine = parseFloat(fineAmounts[index]) || 0;
                                    var discount = parseFloat(discountAmounts[index]) || 0;
                                    var total = parseFloat(totalAmounts[index]) || 0;
                                    var count = parseInt(counts[index]) || 0;

                                    var footer = [];
                                    footer.push('━━━━━━━━━━━━━━━━━━━━━');
                                    footer.push('Base: MT ' + base.toFixed(2));
                                    footer.push('+ Multas: MT ' + fine.toFixed(2));
                                    footer.push('- Descontos: MT ' + discount.toFixed(2));
                                    footer.push('━━━━━━━━━━━━━━━━━━━━━');
                                    footer.push('💰 TOTAL: MT ' + total.toFixed(2));
                                    footer.push('📊 ' + count + ' pagamento(s)');
                                    return footer;
                                }
                            }
                        },
                        scales: {
                            yAxes: [{
                                type: 'linear',
                                position: 'left',
                                stacked: true,
                                ticks: {
                                    beginAtZero: true,
                                    fontColor: '#6b7280',
                                    fontSize: 12,
                                    fontStyle: 'bold',
                                    callback: function(value) {
                                        return 'MT ' + value.toLocaleString('pt-MZ', {minimumFractionDigits: 0, maximumFractionDigits: 0});
                                    }
                                },
                                gridLines: {
                                    color: 'rgba(0, 0, 0, 0.05)',
                                    drawBorder: false,
                                    zeroLineColor: 'rgba(0, 0, 0, 0.1)'
                                },
                                scaleLabel: {
                                    display: true,
                                    labelString: 'Valor (MT)',
                                    fontColor: '#667eea',
                                    fontSize: 13,
                                    fontStyle: 'bold'
                                }
                            }],
                            xAxes: [{
                                stacked: true,
                                ticks: {
                                    fontColor: '#374151',
                                    fontSize: 12,
                                    fontStyle: 'bold'
                                },
                                gridLines: {
                                    display: false,
                                    drawBorder: false
                                }
                            }]
                        },
                        legend: {
                            display: true,
                            position: 'top',
                            labels: {
                                usePointStyle: true,
                                padding: 20,
                                fontColor: '#374151',
                                fontSize: 13,
                                fontStyle: 'bold'
                            }
                        },
                        animation: {
                            duration: 1500,
                            easing: 'easeInOutQuart'
                        }
                    }
                });
        }

        // Create chart on initial load
        document.addEventListener('DOMContentLoaded', createPaymentChart);

        // Recreate chart after Livewire updates
        document.addEventListener('livewire:load', function() {
            Livewire.hook('message.processed', (message, component) => {
                // Small timeout to ensure DOM is updated
                setTimeout(createPaymentChart, 100);
            });
        });

        // Student Distribution Chart
        let studentDistributionChartInstance = null;

        function createStudentDistributionChart() {
            const studentDistributionData = <?php echo json_encode($student_distribution, 15, 512) ?>;

            const ctx = document.getElementById('studentDistributionChart');
            if (!ctx || studentDistributionData.length === 0) {
                return;
            }

            // Destroy existing chart
            if (studentDistributionChartInstance) {
                studentDistributionChartInstance.destroy();
                studentDistributionChartInstance = null;
            }

            // Preparar dados
            const classNames = studentDistributionData.map(item => item.name);
            const maleData = studentDistributionData.map(item => item.male);
            const femaleData = studentDistributionData.map(item => item.female);
            const totals = studentDistributionData.map(item => item.total);

            // Criar gráfico
            studentDistributionChartInstance = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: classNames,
                    datasets: [{
                        label: '👨 Masculino',
                        data: maleData,
                        backgroundColor: 'rgba(59, 130, 246, 0.85)',
                        borderColor: 'rgb(59, 130, 246)',
                        borderWidth: 1,
                        stack: 'stack0'
                    }, {
                        label: '👩 Feminino',
                        data: femaleData,
                        backgroundColor: 'rgba(236, 72, 153, 0.85)',
                        borderColor: 'rgb(236, 72, 153)',
                        borderWidth: 1,
                        stack: 'stack0'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: true,
                    interaction: {
                        mode: 'index',
                        intersect: false
                    },
                    plugins: {
                        title: {
                            display: false
                        },
                        legend: {
                            display: true,
                            position: 'bottom',
                            labels: {
                                usePointStyle: true,
                                padding: 15,
                                font: {
                                    size: 13,
                                    weight: '600'
                                },
                                color: '#374151'
                            }
                        },
                        tooltip: {
                            backgroundColor: 'rgba(0, 0, 0, 0.85)',
                            titleColor: '#fff',
                            bodyColor: '#fff',
                            borderColor: '#667eea',
                            borderWidth: 2,
                            padding: 12,
                            cornerRadius: 8,
                            displayColors: true,
                            callbacks: {
                                label: function(tooltipItem, data) {
                                    var label = data.datasets[tooltipItem.datasetIndex].label || '';
                                    if (label) {
                                        label += ': ';
                                    }
                                    label += tooltipItem.yLabel + ' estudante(s)';
                                    return label;
                                },
                                afterBody: function(tooltipItems, data) {
                                    var index = tooltipItems[0].index;
                                    var total = totals[index];
                                    return '━━━━━━━━━━━━━━━━\n📊 Total: ' + total + ' estudante(s)';
                                }
                            }
                        },
                        datalabels: {
                            display: true,
                            anchor: 'end',
                            align: 'top',
                            formatter: function(value, context) {
                                // Mostrar apenas o total no topo da barra empilhada
                                if (context.datasetIndex === 1) { // Feminino (última camada)
                                    return totals[context.dataIndex];
                                }
                                return '';
                            },
                            font: {
                                weight: 'bold',
                                size: 12
                            },
                            color: '#374151'
                        }
                    },
                    scales: {
                        yAxes: [{
                            stacked: true,
                            ticks: {
                                beginAtZero: true,
                                fontColor: '#6b7280',
                                fontSize: 12,
                                fontStyle: 'bold',
                                stepSize: 10
                            },
                            gridLines: {
                                color: 'rgba(0, 0, 0, 0.05)',
                                drawBorder: false,
                                zeroLineColor: 'rgba(0, 0, 0, 0.1)'
                            },
                            scaleLabel: {
                                display: true,
                                labelString: 'Número de Estudantes',
                                fontColor: '#667eea',
                                fontSize: 13,
                                fontStyle: 'bold'
                            }
                        }],
                        xAxes: [{
                            stacked: true,
                            ticks: {
                                fontColor: '#374151',
                                fontSize: 11,
                                fontStyle: 'bold'
                            },
                            gridLines: {
                                display: false,
                                drawBorder: false
                            }
                        }]
                    },
                    animation: {
                        duration: 1500,
                        easing: 'easeInOutQuart',
                        onComplete: function () {
                            // Desenhar números no topo das barras
                            var chartInstance = this.chart;
                            var ctx = chartInstance.ctx;
                            ctx.font = Chart.helpers.fontString(12, 'bold', Chart.defaults.global.defaultFontFamily);
                            ctx.fillStyle = '#374151';
                            ctx.textAlign = 'center';
                            ctx.textBaseline = 'bottom';

                            this.data.datasets.forEach(function (dataset, datasetIndex) {
                                if (datasetIndex === 1) { // Apenas para Feminino (última camada)
                                    var meta = chartInstance.controller.getDatasetMeta(datasetIndex);
                                    meta.data.forEach(function (bar, index) {
                                        var total = totals[index];
                                        ctx.fillText(total, bar._model.x, bar._model.y - 5);
                                    });
                                }
                            });
                        }
                    }
                }
            });
        }

        // Inicializar gráfico de estudantes
        document.addEventListener('DOMContentLoaded', createStudentDistributionChart);
        document.addEventListener('livewire:load', function() {
            Livewire.hook('message.processed', (message, component) => {
                setTimeout(createStudentDistributionChart, 100);
            });
        });
        </script>

        <style>
            .hover-lift {
                transition: transform 0.3s ease, box-shadow 0.3s ease;
            }
            .hover-lift:hover {
                transform: translateY(-5px);
                box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15) !important;
            }
        </style>
    <?php $__env->stopSection(); ?>
</div>

<style>
/* Dashboard Professional Styles */
.dashboard-page {
    background: transparent;
    min-height: auto;
    padding: 0;
    margin: 0;
}

.dashboard-container {
    max-width: none;
    width: auto;
    margin: 0;
    padding: 0;
}

/* Stats Grid */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.stat-card {
    background: white;
    border-radius: 16px;
    padding: 1.75rem;
    display: flex;
    align-items: center;
    gap: 1.5rem;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.06);
    transition: all 0.3s ease;
    text-decoration: none;
    color: inherit;
    position: relative;
    overflow: hidden;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 4px;
    height: 100%;
    background: currentColor;
    opacity: 0.7;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
}

.stat-icon-wrapper {
    flex-shrink: 0;
}

.stat-icon {
    width: 70px;
    height: 70px;
    border-radius: 14px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2rem;
    color: white;
}

.stat-students { color: #3b82f6; }
.stat-students .stat-icon { background: linear-gradient(135deg, #3b82f6, #2563eb); }

.stat-classes { color: #8b5cf6; }
.stat-classes .stat-icon { background: linear-gradient(135deg, #8b5cf6, #7c3aed); }

.stat-subjects { color: #10b981; }
.stat-subjects .stat-icon { background: linear-gradient(135deg, #10b981, #059669); }

.stat-staff { color: #f59e0b; }
.stat-staff .stat-icon { background: linear-gradient(135deg, #f59e0b, #d97706); }

.stat-content {
    flex: 1;
    min-width: 0;
}

.stat-label {
    display: block;
    font-size: 0.875rem;
    font-weight: 600;
    color: #6b7280;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 0.5rem;
}

.stat-value {
    font-size: 2.25rem;
    font-weight: 700;
    color: #111827;
    margin: 0 0 0.5rem;
    line-height: 1;
}

.stat-footer {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.stat-trend {
    display: flex;
    align-items: center;
    gap: 0.25rem;
    font-size: 0.875rem;
    font-weight: 500;
    color: #6b7280;
}

.stat-trend.positive {
    color: #10b981;
}

.stat-trend.negative {
    color: #ef4444;
}

/* Charts Grid */
.charts-grid {
    display: grid;
    grid-template-columns: 1fr 400px;
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.chart-card {
    background: white;
    border-radius: 16px;
    padding: 1.75rem;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.06);
}

.chart-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 1.5rem;
}

.chart-title {
    font-size: 1.25rem;
    font-weight: 700;
    color: #111827;
    margin: 0 0 0.25rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.chart-subtitle {
    font-size: 0.875rem;
    color: #6b7280;
    margin: 0;
}

.chart-legend {
    display: flex;
    gap: 1rem;
}

.legend-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 0.875rem;
    color: #6b7280;
}

.legend-dot {
    width: 12px;
    height: 12px;
    border-radius: 50%;
}

.chart-body {
    position: relative;
}

.chart-container {
    min-height: 300px;
    position: relative;
}

/* Chart.js Custom Styles */
.chart-container canvas {
    max-height: 320px;
}

/* Smooth chart loading */
@keyframes chartFadeIn {
    from {
        opacity: 0;
        transform: translateY(10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.chart-card {
    animation: chartFadeIn 0.6s ease-out;
}

/* Custom tooltips styling */
.chartjs-tooltip {
    background: rgba(0, 0, 0, 0.85) !important;
    border-radius: 8px !important;
    padding: 12px !important;
}

/* Legend styling improvements */
.chart-container .chartjs-legend {
    display: flex;
    justify-content: center;
    padding-top: 15px;
}

.chart-container .chartjs-legend li {
    margin: 0 12px;
}

/* Quick Actions */
.quick-actions-section {
    margin-bottom: 2rem;
}

.section-title {
    font-size: 1.5rem;
    font-weight: 700;
    color: #111827;
    margin: 0 0 1.5rem;
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.quick-actions-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    gap: 1.25rem;
}

.action-card {
    background: white;
    border-radius: 12px;
    padding: 1.5rem;
    text-align: center;
    transition: all 0.3s ease;
    text-decoration: none;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    border: 2px solid transparent;
}

.action-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
    border-color: #e5e7eb;
}

.action-icon {
    width: 60px;
    height: 60px;
    border-radius: 14px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.75rem;
    margin: 0 auto 1rem;
}

.action-card h4 {
    font-size: 1.125rem;
    font-weight: 600;
    color: #111827;
    margin: 0 0 0.5rem;
}

.action-card p {
    font-size: 0.875rem;
    color: #6b7280;
    margin: 0;
}

/* Responsive Design */
@media (max-width: 1200px) {
    .charts-grid {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 768px) {
    .dashboard-container {
        padding: 1rem;
    }

    .stats-grid {
        grid-template-columns: 1fr;
        gap: 1rem;
    }

    .stat-card {
        padding: 1.25rem;
    }

    .stat-icon {
        width: 60px;
        height: 60px;
        font-size: 1.75rem;
    }

    .stat-value {
        font-size: 1.875rem;
    }

    .chart-card {
        padding: 1.25rem;
    }

    .chart-title {
        font-size: 1.125rem;
    }

    .quick-actions-grid {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 576px) {
    .dashboard-page {
        padding: 0.75rem;
    }

    .dashboard-header {
        padding: 1.25rem;
    }

    .header-title {
        font-size: 1.25rem;
        gap: 0.5rem;
    }

    .stat-card {
        flex-direction: column;
        text-align: center;
        padding: 1.5rem;
    }

    .stat-value {
        font-size: 1.75rem;
    }

    .date-display {
        padding: 0.5rem 1rem;
        font-size: 0.875rem;
    }

    .action-icon {
        width: 50px;
        height: 50px;
        font-size: 1.5rem;
    }

    .action-card h4 {
        font-size: 1rem;
    }

    .chart-container {
        min-height: 250px;
    }
}

@media (max-width: 375px) {
    .header-title {
        font-size: 1.1rem;
    }

    .stat-value {
        font-size: 1.5rem;
    }

    .chart-title {
        font-size: 1rem;
    }

    .section-title {
        font-size: 1.25rem;
    }
}
</style>
<?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/livewire/admin/admin-home.blade.php ENDPATH**/ ?>