<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card shadow-sm border-0">
                        <div class="card-body" wire:init="loadData">
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <div>
                                    <h5 class="card-title mb-1" style="color: #374151; font-weight: 600; font-size: 1.5rem;">
                                        <i class="fas fa-users-class" style="color: #667eea;"></i>
                                        Estudantes da <?php echo e($class->name); ?>

                                    </h5>
                                    <p class="text-muted mb-0" style="font-size: 0.9rem;">
                                        <span class="badge bg-primary"><?php echo e($class->class); ?>ª Classe</span>
                                        <?php if(is_object($models) && method_exists($models, 'total')): ?>
                                            <span class="ms-2"><?php echo e($models->total()); ?> estudante(s)</span>
                                        <?php endif; ?>
                                    </p>
                                </div>
                                <a href="<?php echo e(route('admin.batch.marks')); ?>" class="btn btn-success shadow-sm" style="border-radius: 8px;">
                                    <i class="fa fa-table me-2"></i>Lançamento de Notas em Lote
                                </a>
                            </div>

                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <div class="input-group shadow-sm">
                                        <span class="input-group-text bg-white border-end-0" style="border-color: #e5e7eb;">
                                            <i class="fas fa-search text-muted"></i>
                                        </span>
                                        <input type="search"
                                               wire:model="search"
                                               placeholder="Pesquisar por nome ou ID do estudante..."
                                               class="form-control border-start-0"
                                               style="border-color: #e5e7eb; padding-left: 0;">
                                    </div>
                                </div>
                            </div>
                            <div class="table-responsive" wire:init="loadData">
                                <?php if(count($models)): ?>
                                    <table class="table table-hover align-middle">
                                        <thead style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                                            <tr>
                                                <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">#</th>
                                                <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                    <i class="fas fa-user me-2"></i>Nome
                                                </th>
                                                <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                    <i class="fas fa-venus-mars me-2"></i>Sexo
                                                </th>
                                                <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                    <i class="fas fa-birthday-cake me-2"></i>Data Nascimento
                                                </th>
                                                <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                    <i class="fas fa-id-card me-2"></i>ID Estudante
                                                </th>
                                                <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                    <i class="fas fa-door-open me-2"></i>Turma
                                                </th>
                                                <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                    <i class="fas fa-layer-group me-2"></i>Classe
                                                </th>
                                                <th scope="col" class="text-center" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                    <i class="fas fa-eye me-2"></i>Ações
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php ($count = 1); ?>
                                            <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr style="border-bottom: 1px solid #f3f4f6;">
                                                    <th scope="row" style="color: #9ca3af; font-weight: 500;"><?php echo e($count++); ?></th>
                                                    <?php $key = 'modal_' . $count; ?>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar-circle me-2" style="width: 40px; height: 40px; border-radius: 50%; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 0.9rem;">
                                                                <?php echo e(substr($model->name, 0, 1)); ?>

                                                            </div>
                                                            <span style="color: #374151; font-weight: 500;"><?php echo e($model->name); ?></span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <?php if($model->sex == 'Masculino'): ?>
                                                            <span class="badge bg-info"><i class="fas fa-mars me-1"></i><?php echo e($model->sex); ?></span>
                                                        <?php else: ?>
                                                            <span class="badge bg-pink" style="background-color: #ec4899;"><i class="fas fa-venus me-1"></i><?php echo e($model->sex); ?></span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td style="color: #6b7280;">
                                                        <i class="far fa-calendar me-1"></i>
                                                        <?php echo e(date('d/m/Y', strtotime($model->dob))); ?>

                                                    </td>
                                                    <td>
                                                        <span class="badge bg-light text-dark border" style="font-size: 0.85rem;"><?php echo e($model->student_id); ?></span>
                                                    </td>
                                                    <td style="color: #374151; font-weight: 500;"><?php echo e($model->class->name); ?></td>
                                                    <td>
                                                        <span class="badge" style="background-color: #4f46e5; font-size: 0.875rem; padding: 0.5rem 0.75rem;">
                                                            <?php echo e($model->class->class); ?>ª Classe
                                                        </span>
                                                    </td>
                                                    <td class="text-center">
                                                        <a href="<?php echo e(route('admin.list.students.marks', $model->slug)); ?>"
                                                           class="btn btn-sm btn-primary shadow-sm" style="border-radius: 6px;">
                                                            <i class="fas fa-eye me-1"></i>Ver Notas
                                                        </a>
                                                    </td>
                                                </tr>
                                                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('admin.classes.modal-exam', ['model' => $model])->html();
} elseif ($_instance->childHasBeenRendered($model->id)) {
    $componentId = $_instance->getRenderedChildComponentId($model->id);
    $componentTag = $_instance->getRenderedChildComponentTagName($model->id);
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild($model->id);
} else {
    $response = \Livewire\Livewire::mount('admin.classes.modal-exam', ['model' => $model]);
    $html = $response->html();
    $_instance->logRenderedChild($model->id, $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>

                                                    <div wire:ignore.self class="modal fade"
                                                        id="modal_<?php echo e($model->id); ?>" tabindex="-1"
                                                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                        <div class="modal-dialog  modal-lg modal-dialog-centered">
                                                            <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title"
                                                                        id="exampleModalCenterTitle">
                                                                        <?php echo e($model->name); ?>

                                                                    </h5>
                                                                    <button type="button" class="btn-close"
                                                                        data-bs-dismiss="modal"
                                                                        aria-label="Close"></button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <div class="row">
                                                                        <form class="row g-3"
                                                                            wire:submit.prevent="submit">
                                                                            <div class="col-md-12">
                                                                                <label for="title"
                                                                                    class="form-label">Disciplina
                                                                                </label>
                                                                                <select
                                                                                    class="form-control <?php $__errorArgs = ['subject_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                                    id="name"
                                                                                    wire:model="subject_id"
                                                                                    class="form-control input-lg dynamic">
                                                                                    <option value="" selected>Por
                                                                                        favor selecione a disciplina
                                                                                    </option>
                                                                                    <?php $__currentLoopData = $subjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                        <option
                                                                                            value="<?php echo e($subject->id); ?>">
                                                                                            <?php echo e($subject->name); ?>

                                                                                        </option>
                                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                                </select>
                                                                                <?php $__errorArgs = ['subject_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                    <span class="invalid-feedback"
                                                                                        role="alert">
                                                                                        <strong><?php echo e($message); ?></strong>
                                                                                    </span>
                                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                            </div>

                                                                            <div class="col-md-12">
                                                                                <label for="title"
                                                                                    class="form-label">Trimestre
                                                                                </label>
                                                                                <select
                                                                                    class="form-control <?php $__errorArgs = ['trimester_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                                    id="trimester_id"
                                                                                    wire:model="trimester_id"
                                                                                    class="form-control input-lg dynamic">
                                                                                    <option value="">Selecione o
                                                                                        trimestre</option>
                                                                                    <option value="1">Primeiro
                                                                                        trimestre</option>
                                                                                    <option value="2">Segundo
                                                                                        trimestre</option>
                                                                                    <option value="3">Terceiro
                                                                                        trimestre</option>

                                                                                </select>
                                                                                <?php $__errorArgs = ['trimester_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                    <span class="invalid-feedback"
                                                                                        role="alert">
                                                                                        <strong><?php echo e($message); ?></strong>
                                                                                    </span>
                                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                            </div>
                                                                            <div class="col-md-12">
                                                                                <label for="title"
                                                                                    class="form-label"> Tipo de teste
                                                                                </label>
                                                                                <select
                                                                                    class="form-control <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                                    id="type" wire:model="type"
                                                                                    class="form-control input-lg dynamic">
                                                                                    <option value="" selected>
                                                                                        Selecione o tipo de teste
                                                                                    </option>
                                                                                    <option value="1">ACS1</option>
                                                                                    <option value="2">ACS2</option>
                                                                                    <option value="3">AT</option>
                                                                                    <option value="4">NE</option>


                                                                                </select>
                                                                                <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                    <span class="invalid-feedback"
                                                                                        role="alert">
                                                                                        <strong><?php echo e($message); ?></strong>
                                                                                    </span>
                                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                            </div>
                                                                            <div class="col-md-12">
                                                                                <label for="MACS"
                                                                                    class="form-label">Nota</label>
                                                                                <input type="number"
                                                                                    class="form-control <?php $__errorArgs = ['MACS'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                                                    id="MACS" required
                                                                                    placeholder="Insira a nota..."
                                                                                    wire:model="MACS">
                                                                                <?php $__errorArgs = ['MACS'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                                    <span class="invalid-feedback"
                                                                                        role="alert">
                                                                                        <strong><?php echo e($message); ?></strong>
                                                                                    </span>
                                                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                            </div>

                                                                            <br><br>
                                                                            <div class="col-12">
                                                                                <button type="submit"
                                                                                    class="btn btn-primary btn-lg float-end"
                                                                                    wire:loading.class="disabled"
                                                                                    wire:offline.attr="disabled"><span
                                                                                        wire:target="submit"
                                                                                        wire:loading.class="spinner-border spinner-border-lg"></span>
                                                                                    Guardar
                                                                                </button>
                                                                            </div>
                                                                        </form>
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button"
                                                                            class="btn btn-secondary"
                                                                            data-bs-dismiss="modal">
                                                                            Fechar
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                    <div class="row float-end">
                                        <?php echo e($models->links()); ?>

                                    </div>
                                <?php else: ?>
                                    <br>
                                    <br>
                                    <div class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
<?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/livewire/admin/classes/teacher-list-class-students.blade.php ENDPATH**/ ?>