<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card" style="border: 1px solid #e2e8f0; border-radius: 0;">
                        <div class="card-body" wire:init="loadData" style="padding: 2rem;">

                            <!-- Header Section -->
                            <div class="mb-4 pb-3" style="border-bottom: 2px solid #e2e8f0;">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div>
                                        <h5 class="mb-2" style="color: #1e293b; font-weight: 600; font-size: 1.25rem; letter-spacing: -0.025em;">
                                            Notas do Estudante
                                        </h5>
                                        <p class="mb-0" style="color: #64748b; font-size: 0.95rem;">
                                            <strong style="color: #334155;"><?php echo e($model->name); ?></strong> |
                                            ID: <span style="color: #64748b;"><?php echo e($model->student_id); ?></span>
                                        </p>
                                    </div>
                                </div>
                            </div>

                            <!-- Filters Section -->
                            <div class="row mb-4">
                                <div class="col-md-5">
                                    <label class="form-label" style="color: #475569; font-size: 0.875rem; font-weight: 500; margin-bottom: 0.5rem;">Pesquisar por Disciplina</label>
                                    <input type="search"
                                           wire:model="search"
                                           placeholder="Digite o nome da disciplina..."
                                           class="form-control"
                                           style="border: 1px solid #cbd5e1; border-radius: 0; padding: 0.625rem 0.875rem; font-size: 0.9375rem;">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="color: #475569; font-size: 0.875rem; font-weight: 500; margin-bottom: 0.5rem;">Filtrar por Trimestre</label>
                                    <select wire:model="filterTrimester" class="form-select" style="border: 1px solid #cbd5e1; border-radius: 0; padding: 0.625rem 0.875rem; font-size: 0.9375rem;">
                                        <option value="">Todos os Trimestres</option>
                                        <option value="1">1º Trimestre</option>
                                        <option value="2">2º Trimestre</option>
                                        <option value="3">3º Trimestre</option>
                                    </select>
                                </div>
                                <div class="col-md-2 d-flex align-items-end">
                                    <?php if($search || $filterTrimester): ?>
                                        <button wire:click="$set('search', ''); $set('filterTrimester', '')"
                                                class="btn w-100"
                                                style="background-color: #f1f5f9; color: #475569; border: 1px solid #cbd5e1; border-radius: 0; padding: 0.625rem; font-size: 0.875rem; font-weight: 500;">
                                            Limpar Filtros
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Tables Grid -->
                            <div class="row">
                                <?php ($teachers = array()); ?>
                                <?php $__currentLoopData = $teacher; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teach): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php ($teachers[] = $teach->subject_id); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <!-- 1st Trimester -->
                                <div class="col-md-4">
                                    <div class="mb-4" style="border: 1px solid #e2e8f0;">
                                        <div class="px-3 py-2" style="background-color: #f8fafc; border-bottom: 1px solid #e2e8f0;">
                                            <h6 class="mb-0" style="color: #1e293b; font-size: 0.875rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em;">
                                                1º Trimestre
                                            </h6>
                                        </div>
                                        <div class="table-responsive" wire:init="loadData">
                                            <?php if(count($models)): ?>
                                                <table class="table table-sm mb-0" style="font-size: 0.875rem;">
                                                    <thead style="background-color: #f1f5f9;">
                                                        <tr>
                                                            <th style="color: #64748b; font-weight: 600; padding: 0.625rem 0.75rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">Disciplina</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">ACS1</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">ACS2</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">MACS</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">AT</th>
                                                            <th class="text-center" style="color: #1e293b; font-weight: 700; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0; background-color: #e0e7ff;">MT</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__currentLoopData = $models->where('trimester_id', 1)->sortBy('subject.name'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if(in_array( $model->subject->id,$teachers)): ?>
                                                            <tr style="border-bottom: 1px solid #f1f5f9;">
                                                                <td style="color: #1e293b; font-weight: 500; padding: 0.625rem 0.75rem;"><?php echo e($model->subject->name); ?></td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem;"><?php echo e(number_format($model->ACS1a, 1)); ?></td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem;"><?php echo e(number_format($model->ACS2a, 1)); ?></td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem; background-color: #fafafa;"><?php echo e(number_format(($model->ACS2a + $model->ACS1a) * 0.5, 1)); ?></td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem;"><?php echo e(number_format($model->AT, 1)); ?></td>
                                                                <td class="text-center" style="color: #1e293b; font-weight: 600; padding: 0.625rem 0.5rem; background-color: #e0e7ff;"><?php echo e(round((($model->ACS2a + $model->ACS1a)  + $model->AT) /3)); ?></td>
                                                            </tr>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            <?php else: ?>
                                                <div class="text-center py-4">
                                                    <p class="text-muted mb-0" style="font-size: 0.875rem;">Nenhum dado disponível</p>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>

                                <!-- 2nd Trimester -->
                                <div class="col-md-4">
                                    <div class="mb-4" style="border: 1px solid #e2e8f0;">
                                        <div class="px-3 py-2" style="background-color: #f8fafc; border-bottom: 1px solid #e2e8f0;">
                                            <h6 class="mb-0" style="color: #1e293b; font-size: 0.875rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em;">
                                                2º Trimestre
                                            </h6>
                                        </div>
                                        <div class="table-responsive" wire:init="loadData">
                                            <?php if(count($models)): ?>
                                                <table class="table table-sm mb-0" style="font-size: 0.875rem;">
                                                    <thead style="background-color: #f1f5f9;">
                                                        <tr>
                                                            <th style="color: #64748b; font-weight: 600; padding: 0.625rem 0.75rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">Disciplina</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">ACS1</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">ACS2</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">MACS</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">AT</th>
                                                            <th class="text-center" style="color: #1e293b; font-weight: 700; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0; background-color: #e0e7ff;">MT</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__currentLoopData = $models->where('trimester_id', 2)->sortBy('subject.name'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(in_array( $model2->subject->id,$teachers)): ?>
                                                            <tr style="border-bottom: 1px solid #f1f5f9;">
                                                                <td style="color: #1e293b; font-weight: 500; padding: 0.625rem 0.75rem;"><?php echo e($model2->subject->name); ?></td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem;"><?php echo e(number_format($model2->ACS1a, 1)); ?></td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem;"><?php echo e(number_format($model2->ACS2a, 1)); ?></td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem; background-color: #fafafa;"><?php echo e(number_format(($model2->ACS2a + $model2->ACS1a) * 0.5, 1)); ?></td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem;"><?php echo e(number_format($model2->AT, 1)); ?></td>
                                                                <td class="text-center" style="color: #1e293b; font-weight: 600; padding: 0.625rem 0.5rem; background-color: #e0e7ff;"><?php echo e(round((($model2->ACS2a + $model2->ACS1a)  + $model2->AT) /3)); ?></td>
                                                            </tr>
                                                         <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            <?php else: ?>
                                                <div class="text-center py-4">
                                                    <p class="text-muted mb-0" style="font-size: 0.875rem;">Nenhum dado disponível</p>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>

                                <!-- 3rd Trimester -->
                                <div class="col-md-4">
                                    <div class="mb-4" style="border: 1px solid #e2e8f0;">
                                        <div class="px-3 py-2" style="background-color: #f8fafc; border-bottom: 1px solid #e2e8f0;">
                                            <h6 class="mb-0" style="color: #1e293b; font-size: 0.875rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em;">
                                                3º Trimestre
                                            </h6>
                                        </div>
                                        <div class="table-responsive" wire:init="loadData">
                                            <?php if(count($models)): ?>
                                                <table class="table table-sm mb-0" style="font-size: 0.875rem;">
                                                    <thead style="background-color: #f1f5f9;">
                                                        <tr>
                                                            <th style="color: #64748b; font-weight: 600; padding: 0.625rem 0.75rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">Disciplina</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">ACS1</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">ACS2</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">MACS</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">AT</th>
                                                            <th class="text-center" style="color: #1e293b; font-weight: 700; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0; background-color: #e0e7ff;">MT</th>
                                                            <?php $__currentLoopData = $models->where('trimester_id', 3)->sortBy('subject.name'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if(in_array($model3->subject->id, $teachers)): ?>
                                                                    <?php ($classrr = \App\Models\Classroom::query()->where("id", $model3->classroom_id)->first()->class); ?>
                                                                    <?php if($classrr == 6 || $classrr == 10 || $classrr == 12): ?>
                                                                        <th class="text-center" style="color: #991b1b; font-weight: 700; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0; background-color: #fee2e2;">NE</th>
                                                                        <?php break; ?>
                                                                    <?php elseif($classrr == 3): ?>
                                                                        <th class="text-center" style="color: #991b1b; font-weight: 700; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0; background-color: #fee2e2;">AF</th>
                                                                        <?php break; ?>
                                                                    <?php endif; ?>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__currentLoopData = $models->where('trimester_id', 3)->sortBy('subject.name'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(in_array( $model3->subject->id,$teachers)): ?>
                                                            <tr style="border-bottom: 1px solid #f1f5f9;">
                                                                <td style="color: #1e293b; font-weight: 500; padding: 0.625rem 0.75rem;"><?php echo e($model3->subject->name); ?></td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem;"><?php echo e(number_format($model3->ACS1a, 1)); ?></td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem;"><?php echo e(number_format($model3->ACS2a, 1)); ?></td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem; background-color: #fafafa;"><?php echo e(number_format(($model3->ACS2a + $model3->ACS1a) * 0.5, 1)); ?></td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem;"><?php echo e(number_format($model3->AT, 1)); ?></td>
                                                                <td class="text-center" style="color: #1e293b; font-weight: 600; padding: 0.625rem 0.5rem; background-color: #e0e7ff;"><?php echo e(round((($model3->ACS2a + $model3->ACS1a)  + $model3->AT) /3)); ?></td>

                                                                <?php ($classrr = \App\Models\Classroom::query()->where("id", $model3->classroom_id)->first()->class); ?>
                                                                <?php if($classrr == 6 || $classrr == 10 || $classrr == 12): ?>
                                                                    <td class="text-center" style="color: #991b1b; font-weight: 600; padding: 0.625rem 0.5rem; background-color: #fee2e2;"><?php echo e($model3->NE); ?></td>
                                                                <?php elseif($classrr == 3): ?>
                                                                    <td class="text-center" style="color: #991b1b; font-weight: 600; padding: 0.625rem 0.5rem; background-color: #fee2e2;"><?php echo e($model3->NE); ?></td>
                                                                <?php endif; ?>
                                                            </tr>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            <?php else: ?>
                                                <div class="text-center py-4">
                                                    <p class="text-muted mb-0" style="font-size: 0.875rem;">Nenhum dado disponível</p>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/livewire/admin/classes/teacher-view-marks-student.blade.php ENDPATH**/ ?>