<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($title ?? 'Referência de Pagamento'); ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 10px;
            color: #333;
            padding: 15px 25px;
        }
        .header {
            text-align: center;
            margin-bottom: 12px;
            border-bottom: 2px solid #667eea;
            padding-bottom: 8px;
        }
        .header h1 {
            font-size: 18px;
            color: #667eea;
            margin-bottom: 3px;
        }
        .header p {
            font-size: 9px;
            color: #666;
        }
        .section {
            margin-bottom: 10px;
        }
        .section-title {
            background-color: #667eea;
            color: white;
            padding: 4px 8px;
            font-size: 11px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        .info-row {
            display: table;
            width: 100%;
            margin-bottom: 3px;
        }
        .info-label {
            display: table-cell;
            width: 35%;
            font-weight: bold;
            color: #555;
            padding: 2px 0;
            font-size: 9px;
        }
        .info-value {
            display: table-cell;
            width: 65%;
            padding: 2px 0;
            font-size: 9px;
        }
        .reference-box {
            background-color: #f8f9fa;
            border: 2px solid #667eea;
            border-radius: 5px;
            padding: 12px;
            text-align: center;
            margin: 10px 0;
        }
        .reference-number {
            font-size: 22px;
            font-weight: bold;
            color: #667eea;
            letter-spacing: 1px;
            margin: 5px 0;
        }
        .entity-code {
            font-size: 16px;
            font-weight: bold;
            color: #28a745;
            margin: 5px 0;
        }
        .amount {
            font-size: 18px;
            font-weight: bold;
            color: #28a745;
            margin: 5px 0;
        }
        .instructions {
            background-color: #e7f3ff;
            border-left: 4px solid #0dcaf0;
            padding: 8px;
            margin-top: 10px;
        }
        .instructions h3 {
            color: #0dcaf0;
            font-size: 11px;
            margin-bottom: 5px;
        }
        .instructions ul {
            margin-left: 15px;
            line-height: 1.4;
            font-size: 9px;
        }
        .instructions p {
            font-size: 9px;
        }
        .status-badge {
            display: inline-block;
            padding: 2px 8px;
            border-radius: 3px;
            font-size: 9px;
            font-weight: bold;
        }
        .status-pending {
            background-color: #ffc107;
            color: #000;
        }
        .status-paid {
            background-color: #28a745;
            color: white;
        }
        .status-expired {
            background-color: #dc3545;
            color: white;
        }
        .status-cancelled {
            background-color: #6c757d;
            color: white;
        }
        .footer {
            margin-top: 15px;
            padding-top: 8px;
            border-top: 1px solid #ddd;
            text-align: center;
            font-size: 8px;
            color: #999;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>REFERÊNCIA DE PAGAMENTO</h1>
        <p>Documento gerado em <?php echo e(now()->format('d/m/Y H:i:s')); ?></p>
    </div>

    <!-- Dados do Estudante -->
    <div class="section">
        <div class="section-title">DADOS DO ESTUDANTE</div>
        <div class="info-row">
            <div class="info-label">Nome:</div>
            <div class="info-value"><?php echo e($reference['student_name']); ?></div>
        </div>
        <div class="info-row">
            <div class="info-label">ID do Estudante:</div>
            <div class="info-value"><?php echo e($reference['student_id']); ?></div>
        </div>
        <div class="info-row">
            <div class="info-label">Classe:</div>
            <div class="info-value"><?php echo e($reference['class']); ?></div>
        </div>
    </div>

    <!-- Dados da Referência -->
    <div class="reference-box">
        <p style="font-size: 9px; color: #666; margin-bottom: 2px;">NÚMERO DA REFERÊNCIA</p>
        <div class="reference-number"><?php echo e($reference['reference_number']); ?></div>

        <p style="font-size: 9px; color: #666; margin-top: 8px; margin-bottom: 2px;">ENTIDADE</p>
        <div class="entity-code"><?php echo e($reference['entity_code']); ?></div>

        <p style="font-size: 9px; color: #666; margin-top: 8px; margin-bottom: 2px;">VALOR A PAGAR</p>
        <div class="amount">MT <?php echo e(number_format($reference['amount'], 2, ',', '.')); ?></div>
    </div>

    <!-- Detalhes Adicionais -->
    <div class="section">
        <div class="section-title">DETALHES DA REFERÊNCIA</div>
        <div class="info-row">
            <div class="info-label">Mês/Ano:</div>
            <div class="info-value"><?php echo e($reference['fee_month']); ?>/<?php echo e($reference['fee_year']); ?></div>
        </div>
        <div class="info-row">
            <div class="info-label">Status:</div>
            <div class="info-value">
                <?php
                    $statusClass = match($reference['status']) {
                        'paid' => 'status-paid',
                        'pending' => 'status-pending',
                        'expired' => 'status-expired',
                        'cancelled' => 'status-cancelled',
                        default => 'status-pending'
                    };
                    $statusText = match($reference['status']) {
                        'paid' => 'PAGO',
                        'pending' => 'PENDENTE',
                        'expired' => 'EXPIRADO',
                        'cancelled' => 'CANCELADO',
                        default => 'PENDENTE'
                    };
                ?>
                <span class="status-badge <?php echo e($statusClass); ?>"><?php echo e($statusText); ?></span>
            </div>
        </div>
        <div class="info-row">
            <div class="info-label">Data de Geração:</div>
            <div class="info-value"><?php echo e($reference['created_at']); ?></div>
        </div>
        <div class="info-row">
            <div class="info-label">Data de Expiração:</div>
            <div class="info-value"><?php echo e($reference['expires_at'] ?? 'N/A'); ?></div>
        </div>
        <?php if($reference['paid_at']): ?>
        <div class="info-row">
            <div class="info-label">Data de Pagamento:</div>
            <div class="info-value"><?php echo e($reference['paid_at']); ?></div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Instruções de Pagamento -->
    <div class="instructions">
        <h3>COMO PAGAR</h3>
        <p style="margin-bottom: 4px;">Para pagar, dirija-se a qualquer caixa ATM e siga os passos:</p>
        <ul>
            <li>Selecione <strong>"Pagamentos"</strong> → <strong>"Pagamento de Serviços"</strong></li>
            <li>Entidade: <strong><?php echo e($reference['entity_code']); ?></strong></li>
            <li>Referência: <strong><?php echo e($reference['reference_number']); ?></strong></li>
            <li>Valor: <strong>MT <?php echo e(number_format($reference['amount'], 2, ',', '.')); ?></strong></li>
            <li>Conclua e guarde o comprovativo</li>
        </ul>
        <p style="margin-top: 5px; font-size: 8px; color: #666;">
            <strong>Importante:</strong> O sistema será atualizado automaticamente após o pagamento.
        </p>
    </div>

    <div class="footer">
        <p>Este documento foi gerado automaticamente pelo sistema de gestão escolar.</p>
        <p>Para mais informações, contacte a secretaria da instituição.</p>
    </div>
</body>
</html>
<?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/admin/fee/reference-pdf.blade.php ENDPATH**/ ?>