<?php

namespace Chatify\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;
use App\Models\ChMessage as Message;
use App\Models\ChChannel as Channel;
use App\Models\ChFavorite as Favorite;
use Chatify\Facades\ChatifyMessenger as Chatify;
use App\Models\User;
use App\Models\Admin;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;
use Illuminate\Support\Facades\Log;
use Kreait\Firebase\Exception\Messaging\NotFound;
use Kreait\Firebase\Factory;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Validator;

class MessagesController extends Controller
{
    protected $perPage = 30;

     /**
     * Authinticate the connection for pusher
     *
     * @param Request $request
     * @return void
     */
    public function createNewChannel(Request $request)
    {
        $user = Auth::guard('api')->user();
        
        $firebaseCredentials = [
            "type" => "service_account",
            "project_id" => "copmoz-3x",
            "private_key_id" => "bb9e045f0e2345c069b299a14636203509899ef8",
            "private_key" => "-----BEGIN PRIVATE KEY-----\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDYfKrqJJyR6/8w\nP0NI75wA0OMzBMq53JD0GX/2G488VD2gE+Wbxt90e/6PUGdrOEwo7C+ilCNKsoX7\nzyy6l6kOt6MgVjO39bc7/qwaKYcA05/48grMrLMUxb6SNAMmKmj3CTQ9dU/zAmqA\n96HleqAkHt22wRSQ8hy4qg44CC1f8faBJxGb68YeMm9TmoYcdUhc7QT13JoMRZjl\nbi5gNDVIFWDyUhXeVpvw13Z3Sfo+EgkiT2Tb2Nr8//rptIabmrhzUsAFTEKnHblh\nY+1nsxBBwImu1NRtr5aQUCNLUZXcbWpuoym6EZtCLe3u6/mL3wI05407q1YqpUOq\nppfDwuHdAgMBAAECggEAMuv0Kfotp/dKgddHpObTm6+G2a/VXa2fnQNIgaPO5+Jq\n0nYLqr43PoeSA7TmdqZ556BSvhu5R29Bq876FvPojLEuWkNci/dsv9xyL/83pb6h\noOWSG729q/OtlWdNnFMaeI0+L/yhrygQ1EArYTacZ5KpFT1KcKO6lMdPa+ekgK4T\nPuwGVD/3VDFG9AWCEm+v3w6bQAhpKbdZiBPpGvTrfFHYov97/Yzv/iC3599VnW+i\no3GweFGaqsOn4PxuyIyYujzgoIc6kBrivUV+ddxZqLufrsQL1uE78SuWjhRNS8/k\n5rUD3Qvaj3BOQzkqCnttclfPZYSmbjMtVyLOMjMcQQKBgQDkE1SnrhY/dZF5QCFg\nIMaf7wkPLLCSStugOeYMGx2oeD0MxaY9L9N1ffRLekngffzANrO/ybE7AlRzgBJB\n2NYFd7fueihmrWuTpMafkBivG+mf+HdTjkxF0aQfYUL+MMW7viBBzGDbwckRSTX5\n5pSqzEHmRvctiLTfHqqgUnDeIQKBgQDy/hzbdteqvgqRok7KoXy3ciij4SQbDOQZ\n19KcmMTFgMiT/xm/3uni924Qw82VVSYQjDbAoSltTl7cpvtkXzSB2LIg00YEhfcE\nj/atYfswDIBYBAGCUZDalOn6s/8TWuTGVfCkQVwHA2Xa3rKqIrI1gHTuu5N4J/P4\niCmL3Vd0PQKBgQC1mirC5Rvz5ZIywHySxSZCfJtzCLuDkLV1zAQ/yWuBFFRQEiS+\n/ZDbMbJOUw32AXs6NZREdr125fEGkoh3A8fOTLgY3A3FS/qncgFxVdRBwfDxHm8t\nCdXzleyfy9sC+STIy6d1nN3WvWNzLx8aX54qrT8fs4vnJr4WFp330Azs4QKBgQCc\nnDj/Hb5sdmWbbW+425HlLfeRf+bkZE+TdG1yrmeMH6+m6zCuYD6AIRbYSUp0J9gL\nrEMRrg1kPLGZJyo5i77svTw5OdIT0j/dueez4cWiNzx0/cf3NRjWOEoBYgdRczCl\nv/gD9XgZsQ/xm7ytOQWAxBUZVN38AEwW77NPSM43xQKBgCgCmFCO57u8Fc6d+4G9\nBy/Vfmy3tZpwGCTGqxkwhFvG+qXZTERJOwRg4jejIM/W6iQlOPmfsis2CWhCZvYL\nSimfvuVeWSVixdnsxVpjVyyT7ci9jMhPXeL7LtMCjNF4hB34qgejqpkwh62Zqg0h\nNuy5ZdoARi0VwY/spf6HK03b\n-----END PRIVATE KEY-----\n",
            "client_email" => "firebase-adminsdk-as4sm@copmoz-3x.iam.gserviceaccount.com",
            "client_id" => "112030584520787629755",
            "auth_uri" => "https://accounts.google.com/o/oauth2/auth",
            "token_uri" => "https://oauth2.googleapis.com/token",
            "auth_provider_x509_cert_url" => "https://www.googleapis.com/oauth2/v1/certs",
            "client_x509_cert_url" => "https://www.googleapis.com/robot/v1/metadata/x509/firebase-adminsdk-as4sm%40copmoz-3x.iam.gserviceaccount.com",
            "universe_domain" => "googleapis.com"
        ];
    
        $factory = (new Factory)->withServiceAccount($firebaseCredentials);
        $messaging = $factory->createMessaging();


        $token = $user->device_token;
            try {
                    if (strlen($token) >= 152) {
                        $notification = Notification::fromArray([
                            'token' => $token,
                            'title' => "hello",
                            'body' => "How are you",
                            'image' => null,
                        ]);
        
                        $message = CloudMessage::withTarget('token', $token)
                            ->withNotification($notification)
                            ->withHighestPossiblePriority()
                            ->withDefaultSounds();
                        $messaging->send($message);
                    } else {
                        Log::channel('log_notifications')->error("No token registered for user: {$user->name} - Token: ($user->device_token). Notification not sent.");
                    }
                } catch (NotFound $e) {
                        // Handle the 'NotFound' exception
                        Log::channel('log_notifications')->error("{$user->name} - Token not found: {$e->getMessage()}");
                } catch (\Exception $e) {
                // Handle all other exceptions
                echo 'An error occurred: ' . $e->getMessage();
                // Log the error, notify the user, or take appropriate action
            }

        // Return a response, for example
        return response()->json([
            'users' => "Hello",
        ], 201);
    }

    public function getChannelId(Request $request)
    {
		$user_id = $request['user_id'];
		$res = Chatify::getOrCreateChannel($user_id);
		
		// send the response
		return Response::json($res, 200);
    }


    public function pusherAuth(Request $request)
    {   

        $user = Auth::guard('api')->user();

    if (!$user) {
        return response()->json([
            'status' => '401',
            'message' => 'Unauthorized! Invalid token.'
        ], 401);
    } else {
        return Chatify::pusherAuth(
            $user,  // Pass the user based on the token
            $user,
            $request['channel_name'],
            $request['socket_id']
        );
    }

    }

    /**
     * Fetch data by id for (user/group)
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function idFetchData(Request $request)
    {
        return auth()->user();
        // Favorite
        $favorite = Chatify::inFavorite($request['id']);

        // User data
        if ($request['type'] == 'user') {
            $fetch = User::where('id', $request['id'])->first();
            if($fetch){
                $userAvatar = Chatify::getUserWithAvatar($fetch)->avatar;
            }
        }

        // send the response
        return Response::json([
            'favorite' => $favorite,
            'fetch' => $fetch ?? null,
            'user_avatar' => $userAvatar ?? null,
        ]);
    }

    /**
     * This method to make a links for the attachments
     * to be downloadable.
     *
     * @param string $fileName
     * @return \Illuminate\Http\JsonResponse
     */
    public function download($fileName)
    {
        $path = config('chatify.attachments.folder') . '/' . $fileName;
        if (Chatify::storage()->exists($path)) {
            return response()->json([
                'file_name' => $fileName,
                'download_path' => Chatify::storage()->url($path)
            ], 200);
        } else {
            return response()->json([
                'message'=>"Sorry, File does not exist in our server or may have been deleted!"
            ], 404);
        }
    }

/**
 * Send a message to database
 *
 * @param Request $request
 * @return JSON response
 */
public function send(Request $request)
{

    // Default error response
    $error = (object)[
        'status' => 0,
        'message' => null
    ];
    $attachment = null;
    $attachment_title = null;

    // Handle file attachment
    if ($request->hasFile('file')) {
        $allowed_extensions = array_merge(Chatify::getAllowedImages(), Chatify::getAllowedFiles());

        $file = $request->file('file');
        if ($file->getSize() < Chatify::getMaxUploadSize()) {
            if (in_array(strtolower($file->extension()), $allowed_extensions)) {
                $attachment_title = $file->getClientOriginalName();
                $attachment = Str::uuid() . "." . $file->extension();
                $file->storeAs(config('chatify.attachments.folder'), $attachment, config('chatify.storage_disk_name'));
            } else {
                $error->status = 1;
                $error->message = "File extension not allowed!";
            }
        } else {
            $error->status = 1;
            $error->message = "File size you are trying to upload is too large!";
        }
    }

    // Proceed if no errors
    if (!$error->status) {
        // Send to database
        $message = Chatify::newMessage([
            'type' => $request['type'],
            'from_id' => Auth::user()->id,
            'to_channel_id' => $request['channel_id'],
            'body' => trim($request['message']),
            'attachment' => $attachment ? json_encode((object)[
                'new_name' => $attachment,
                'old_name' => trim($attachment_title),
            ]) : null,
        ]);

        // Fetch message for response
        $messageData = Chatify::parseMessage($message);

        // Notify the recipient
        if (Auth::user()->id == $messageData["from_id"]) {
            Chatify::push("private-chatify." . $request['channel_id'], 'messaging', [
                'from_id' => Auth::user()->id,
                'to_id' => $request['channel_id'],
                'message' => $messageData
            ]);
        }

        // Send notification after successfully saving the message
        $this->sendNotification($request['channel_id'], $message, $attachment);
    }

    // Return response
    return response()->json([
        'status' => '200',
        'error' => $error,
        'message' => $messageData ?? [],
        'tempID' => $request['temporaryMsgId'],
    ]);
}


protected function sendNotification($channelId, $message, $attachment)
{
    try {
        // Retrieve user IDs associated with the channel from the ch_channel_user table
        $userIds = DB::table('ch_channel_user')
            ->where('channel_id', $channelId)
            ->pluck('user_id');

        if ($userIds->isEmpty()) {
            throw new \Exception("No users found for channel_id: " . $channelId);
        }

        $firebaseCredentials = [
            "type" => "service_account",
            "project_id" => "copmoz-3x",
            "private_key_id" => "7768bcef3df838b966f6ec0f3fd398ced9336439",
            "private_key" => "-----BEGIN PRIVATE KEY-----\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDY12nvQbs5PGiU\nuZrrhOKpCB5viTy6PdNNB0vz8MRA+8SL4RaZG8b/AA9qgNRj03GMx3cP6OVFMi7C\n7/KRjjHJisfK0etOqfRc8IVrG4pizwmetMLdE1PsSNsHaC/mddLQKbKwsf8QhJGb\npSRI4PMdgSGmsvpn0L0ki7DhrdRF7d8NdFFLdrXTtULSmpWyh+Mvt9GApM/ffQh6\nAC0X04BANj449xCAJVFsjfDrXgN4/ZOOBUItLZK0ICDjuaf8009ABdxn28Y0oRQC\nIk4fbPtBcLhofFyXiGDV0XiAvgCioyM4eTPDLfU3d9NbgF7pHo2aust4qg2qt5/k\ncVKN4TMhAgMBAAECggEAMOaXdcTpj3VPkmavCLkNkpgJoRaectO5gLAKEWe1IoCE\nqRToTzwD6wLc9yQ5gY+wFlLvR0+60JmKER0io2+hS7W368XeXn2WZZU6SVbLJRBS\nt49FOK0AqpMdjfSRhNQCaD5XFWD2yAdVfPfHkIXmXbt+1sSbEulwljrId4SHkAMz\n+epUKT48svL+Kbdijz9zZjzw1LkX768tn4G+7vDNv2VgQnZbWHun0beOHvYesb7A\ncHQqT20B8wHRlVzUV5Mj61Tzgn84Oq+7TFwFkw/kYu3ErtP+Cwv+LWExnyeZ2ZMe\nvGPQRvN9BRbr5gyIJzc0FX9jPzfI/7lbdePVdgHNTwKBgQD3i9aSfBO+SiMsh3y8\nsBkE8sG6bP/lXk9ySLEV/3LFB9sRJpFOe4hCOvFY2wb0pHbVZd65o2FdmvRZm5DK\nrJA8oqByOIt9x9dBMIEQW4IrNNOeJwEflpagL/32KH4L16PPcf3CYZRLQCxVRMlm\n+FTTtGDpydnA/e8YO8weGU2aDwKBgQDgPyP1QiIbvotj9V3hNXYfiT88m/Al9roe\nHkQ2psE3YCz4BQGQ8xfPYmY3dDyHFegPLHHDiHMkvPTcFxt0S9P7k/eKOLBpgp9e\nihrNoDXBD5B0wgLQc1Mp4HYEeTnH9mEKOGURznOIF8X4uVY7+WzV56Rb38NZHIi7\nf0J54/lPzwKBgGbm92RfNanVkbeR/rVFErFu5D9Fzj4frTDZrNtzG9dxw4vml2Kj\nkWnOrML+EW8i6s8ckLBkjTXnEwoo09CcWT0LcVzpynqX1xAfRJdzIrIpPIqythHW\nfHjMWmq4PGVZ15uFTDJAc++wFn2/oWUvd7ulcN/ea6mBJaHSQbCFXi/bAoGBALu1\nvtjPShPlVXMP8kzRXpaZYXjPo59zv2n0te71eWlsNVhLgHsgMf8kBCJJR11ghgcl\nkfk2YAQRs/oD0bRwwPqnap+mQm2frN4LRtJ3WGfKKobB3G83ChdU0BWAkFCFOce/\nW0MjiOwT0mEYa0n6yRLpO1i4nyIZ0473wOKdZZVbAoGBAL4+ffKdzPJy4SG4v0L5\nPvYPW4u2gukA3G4aTWOg2EwUGq2HLaGFCvDqE+hR3bGqVEhk6X12vHuke4UFaN44\nXUfs8v65F/LT7VG0+dhfpDzbfhnVoTqsJOB3obQnQzJPfk4FThEQOBqepKV8PDyo\nVosJTLofmtwZH823UAZIIOd/\n-----END PRIVATE KEY-----\n",
            "client_email" => "firebase-adminsdk-as4sm@copmoz-3x.iam.gserviceaccount.com",
            "client_id" => "112030584520787629755",
            "auth_uri" => "https://accounts.google.com/o/oauth2/auth",
            "token_uri" => "https://oauth2.googleapis.com/token",
            "auth_provider_x509_cert_url" => "https://www.googleapis.com/oauth2/v1/certs",
            "client_x509_cert_url" => "https://www.googleapis.com/robot/v1/metadata/x509/firebase-adminsdk-as4sm%40copmoz-3x.iam.gserviceaccount.com",
            "universe_domain" => "googleapis.com"
        ];

        $factory = (new Factory)->withServiceAccount($firebaseCredentials);
        $messaging = $factory->createMessaging();
        Log::info('Firebase Messaging initialized');

        // For each user in the channel, send a notification
        foreach ($userIds as $userId) {
            $user = User::where('id', $userId)->first();
            if (!$user) {
                Log::error("User not found for ID: $userId");
                continue;
            }

            // Get device tokens for the user
            $tokens = DeviceToken::where('user_id', $user->id)->pluck('token');
            if ($tokens->isEmpty()) {
                Log::error("No device tokens found for user: " . $user->name);
                continue;
            }

            Log::info('Device tokens retrieved for user: ' . $user->name, ['tokens' => $tokens]);

            // Send notification for each device token
            foreach ($tokens as $token) {
                try {
                    $notification = Notification::fromArray([
                        'token' => $token,
                        'title' => "Nova mensagem de " . Auth::user()->name,
                        'body' => ($attachment) ? "Ficheiro anexado" : $message->body,
                    ]);

                    $firebaseMessage = CloudMessage::withTarget('token', $token)
                        ->withNotification($notification)
                        ->withHighestPossiblePriority()
                        ->withDefaultSounds();

                    $messaging->send($firebaseMessage);
                    Log::info('Notification sent to token: ' . $token);

                } catch (\Kreait\Firebase\Exception\Messaging\InvalidMessage $e) {
                    Log::error("Invalid token: {$token}. Error: {$e->getMessage()}");
                    DeviceToken::where('token', $token)->delete();  // Remove invalid token
                } catch (\Exception $e) {
                    Log::error("Error sending notification: " . $e->getMessage());
                }
            }
        }

    } catch (\Exception $e) {
        Log::error('Error sending notifications: ' . $e->getMessage());
    }
}

    /**
     * fetch [user/group] messages from database
     *
     * @param Request $request
     * @return JSON response
     */
    public function fetch(Request $request)
    {
        $query = Chatify::fetchMessagesQuery($request['id'])->latest();
        $messages = $query->paginate($request->per_page ?? $this->perPage);
        $totalMessages = $messages->total();
        $lastPage = $messages->lastPage();
        $response = [
            'total' => $totalMessages,
            'last_page' => $lastPage,
            'last_message_id' => collect($messages->items())->last()->id ?? null,
            'messages' => $messages->items(),
        ];
        return Response::json($response);
    }

    
    public function seen(Request $request)
    {
        try {
            $userId = Auth::user()->id;
            // Aceitar tanto 'id' quanto 'channel_id' (JS envia 'channel_id')
            $channelId = $request['channel_id'] ?? $request['id'];

            Log::info('📩 [Chatify API] Marcando mensagens como vistas', [
                'user_id' => $userId,
                'channel_or_user_id' => $channelId,
                'request_data' => $request->all(),
            ]);

            // Tentar marcar como visto usando canal primeiro
            $updatedCount = Message::where('to_channel_id', $channelId)
                ->where('from_id', '!=', $userId) // Não marcar mensagens próprias
                ->where('seen', 0)
                ->update([
                    'seen' => 1,
                    'updated_at' => now()
                ]);

            // Se não atualizou nada, tentar método antigo (conversas diretas sem canal)
            if ($updatedCount === 0) {
                $updatedCount = Message::where('from_id', $channelId)
                    ->where('to_id', $userId)
                    ->where('seen', 0)
                    ->update([
                        'seen' => 1,
                        'updated_at' => now()
                    ]);
            }

            Log::info('✅ [Chatify API] Mensagens marcadas como vistas', [
                'channel_or_user_id' => $channelId,
                'updated_count' => $updatedCount,
            ]);

            return Response::json([
                'status' => 1,
                'updated_count' => $updatedCount,
            ], 200);

        } catch (\Exception $e) {
            Log::error('❌ [Chatify API] Erro ao marcar mensagens como vistas: ' . $e->getMessage());
            return Response::json([
                'status' => 0,
                'error' => $e->getMessage(),
            ], 500);
        }
    }

   public function markMessagesSeen(Request $request)
   {
   $userId = Auth::id();

    // Ensure the request includes a channel ID
    $channelId = $request->channel_id;

    if (!$channelId) {
        return response()->json(['status' => 'error', 'message' => 'Channel ID is required'], 400);
    }

    // Get all messages in the specified channel that were not sent by the authenticated user
    $messages = Message::where('to_channel_id', $channelId)
        ->where('from_id', '<>', $userId)
        ->get();


    $updatedCount = 0;

    // Update each message's seen field to the user ID
    foreach ($messages as $message) {
        // Only update if not already seen by this user
        if ($message->seen !== $userId) {
            $message->seen = 1; // Set the seen field to the user ID
            $message->save(); // Save the updated message
            $updatedCount++; // Increment the updated count
        }
    }

    if ($updatedCount > 0) {
        return response()->json(['status' => 'success', 'message' => 'All messages marked as seen', 'updated_count' => $updatedCount]);
    } else {
        return response()->json(['status' => 'success', 'message' => 'No unseen messages found']);
    }
  }       		
 

    /**
     * Get contacts list
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse response
     */
    public function getContacts(Request $request){
    $users_list = []; // ou algum valor apropriado

    // Get the token from the request header
    $user = Auth::guard('api')->user();

    if (!$user) {
        return response()->json([
            'status' => '401',
            'message' => 'Unauthorized! Invalid token.'
        ], 401);
    } else {
        

        $query = Channel::join('ch_messages', 'ch_channels.id', '=', 'ch_messages.to_channel_id')
            ->join('ch_channel_user', 'ch_channels.id', '=', 'ch_channel_user.channel_id')
            ->where('ch_channel_user.user_id','=',Auth::user()->id)
            ->select('ch_channels.*', DB::raw('ch_messages.created_at messaged_at'))
            ->groupBy('ch_channels.id')
            ->orderBy('messaged_at', 'desc')
            ->paginate($request->per_page ?? $this->perPage);

        $channelsList = $query->items();

        if (count($channelsList) > 0) {

            foreach ($channelsList as $channel) {
                $lastMessage = Chatify::getLastMessageQuery($channel->id);
                $unseenCounter = Chatify::countUnseenMessages($channel->id);
                if ($lastMessage) {
                   $lastMessage->created_at = $lastMessage->created_at->toIso8601String();
                   $lastMessage->timeAgo = $lastMessage->created_at->diffForHumans();
                }

                // check if this channel is a group
            if (isset($channel->owner_id)) {
                $users_list[] = [
                    'get' => 'contact-group',
                    'channel' => Chatify::getChannelWithAvatar($channel),
                    'last_message' => $lastMessage,
                    'unseen_counter' => $unseenCounter,
                ];
                
            } else {
                $user = Chatify::getUserInOneChannel($channel->id);
                $users_list[] = [
                    'get' => 'contact-user',
                    'channel' => $channel,
                    'user' => Chatify::getUserWithAvatar($user),
                    'last_message' => $lastMessage,
                    'unseen_counter' => $unseenCounter,
                ];
            }
        }

        } else {
            $contacts = '<p class="message-hint center-el"><span>Sua lista de contatos está vazia</span></p>';
        }

        return response()->json([
            'contacts' => $users_list,
            'total' => $query->total() ?? 0,
            'last_page' => $query->lastPage() ?? 1,
        ], 200);
    }
    }


    /**
     * Put a user in the favorites list
     *
     * @param Request $request
     * @return void
     */
    public function favorite(Request $request)
    {
        $userId = $request['user_id'];
        // check action [star/unstar]
        $favoriteStatus = Chatify::inFavorite($userId) ? 0 : 1;
        Chatify::makeInFavorite($userId, $favoriteStatus);

        // send the response
        return Response::json([
            'status' => @$favoriteStatus,
        ], 200);
    }

    /**
     * Get favorites list
     *
     * @param Request $request
     * @return void
     */
    public function getFavorites(Request $request)
    {
        $favorites = Favorite::where('user_id', Auth::user()->id)->get();
        foreach ($favorites as $favorite) {
            $favorite->user = User::where('id', $favorite->favorite_id)->first();
        }
        return Response::json([
            'total' => count($favorites),
            'favorites' => $favorites ?? [],
        ], 200);
    }

    /**
     * Search in messenger
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function search(Request $request)
    {
        $input = trim(filter_var($request['input']));
        
        $records = User::select("id", "name", "avatar","active_status",  DB::raw("-1"))->where('id', '!=', Auth::user()->id)
            ->where('name', 'LIKE', "%{$input}%");
        $recordsteacher = Admin::select("id", "name", "avatar", "active_status", "role" )->where('id', '!=', Auth::user()->id)
            ->where('name', 'LIKE', "%{$input}%")
            ->union($records)
            ->paginate($request->per_page ?? $this->perPage);


        return Response::json([
            'records' => $recordsteacher->items(),
            'total' => $recordsteacher->total(),
            'last_page' => $recordsteacher->lastPage()
        ], 200);
    }

    /**
     * Get shared photos
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function sharedPhotos(Request $request)
    {
        $images = Chatify::getSharedPhotos($request['user_id']);

        foreach ($images as $image) {
            $image = asset(config('chatify.attachments.folder') . $image);
        }
        // send the response
        return Response::json([
            'shared' => $images ?? [],
        ], 200);
    }

    /**
     * Delete conversation
     *
     * @param Request $request
     * @return void
     */
    public function deleteConversation(Request $request)
    {
        // delete
        $delete = Chatify::deleteConversation($request['channel_id']);

        // send the response
        return Response::json([
            'deleted' => $delete ? 1 : 0,
        ], 200);
    }

    /**
     * Delete message
     *
     * @param Request $request
     * @return JsonResponse
     */


    public function deleteMessage(Request $request)
    {
        // delete
        $delete = Chatify::deleteMessage($request['id']);

        // send the response
        return Response::json([
            'deleted' => $delete ? 1 : 0,
        ], 200);
    }

    public function updateSettings(Request $request)
    {
        $msg = null;
        $error = $success = 0;

        // dark mode
        if ($request['dark_mode']) {
            $request['dark_mode'] == "dark"
                ? User::where('id', Auth::user()->id)->update(['dark_mode' => 1])  // Make Dark
                : User::where('id', Auth::user()->id)->update(['dark_mode' => 0]); // Make Light
        }

        // If messenger color selected
        if ($request['messengerColor']) {
            $messenger_color = trim(filter_var($request['messengerColor']));
            User::where('id', Auth::user()->id)
                ->update(['messenger_color' => $messenger_color]);
        }
        // if there is a [file]
        if ($request->hasFile('avatar')) {
            // allowed extensions
            $allowed_images = Chatify::getAllowedImages();

            $file = $request->file('avatar');
            // check file size
            if ($file->getSize() < Chatify::getMaxUploadSize()) {
                if (in_array(strtolower($file->extension()), $allowed_images)) {
                    // delete the older one
                    if (Auth::user()->avatar != config('chatify.user_avatar.default')) {
                        $path = Chatify::getUserAvatarUrl(Auth::user()->avatar);
                        if (Chatify::storage()->exists($path)) {
                            Chatify::storage()->delete($path);
                        }
                    }
                    // upload
                    $avatar = Str::uuid() . "." . $file->extension();
                    $update = User::where('id', Auth::user()->id)->update(['avatar' => $avatar]);
                    $file->storeAs(config('chatify.user_avatar.folder'), $avatar, config('chatify.storage_disk_name'));
                    $success = $update ? 1 : 0;
                } else {
                    $msg = "File extension not allowed!";
                    $error = 1;
                }
            } else {
                $msg = "File size you are trying to upload is too large!";
                $error = 1;
            }
        }

        // send the response
        return Response::json([
            'status' => $success ? 1 : 0,
            'error' => $error ? 1 : 0,
            'message' => $error ? $msg : 0,
        ], 200);
    }

    /**
     * Set user's active status
     *
     * @param Request $request
     * @return void
     */
    public function setActiveStatus(Request $request)
    {
        $activeStatus = $request['status'] > 0 ? 1 : 0;
        $status = User::where('id', Auth::user()->id)->update(['active_status' => $activeStatus]);
        return Response::json([
            'status' => $status,
        ], 200);
    }
    
     /**
     * Store typing status for a channel
     * When a user is typing (typing=1), store in cache with 5s TTL
     * When a user stops typing (typing=0), remove from cache
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function typing(Request $request)
    {
        // Validate request
        $validator = Validator::make($request->all(), [
            'channel_id' => 'required|uuid',
            'typing' => 'required|in:0,1',
        ]);

        if ($validator->fails()) {
            return Response::json([
                'status' => 'error',
                'message' => 'Validation failed',
                'errors' => $validator->errors()
            ], 422);
        }

        $channelId = $request->input('channel_id');
        $typing = $request->input('typing');
        $userId = Auth::id();

        // Cache key pattern: typing:{channel_id}:{user_id}
        $key = "typing:{$channelId}:{$userId}";

        if ($typing == 1) {
            // User is typing - store in cache with 5 seconds TTL
            Cache::put($key, now()->timestamp, 5);

            Log::info('💬 [Typing] User started typing', [
                'user_id' => $userId,
                'channel_id' => $channelId,
                'key' => $key
            ]);
        } else {
            // User stopped typing - remove from cache
            Cache::forget($key);

            Log::info('🛑 [Typing] User stopped typing', [
                'user_id' => $userId,
                'channel_id' => $channelId,
                'key' => $key
            ]);
        }

        return Response::json(['status' => 'success'], 200);
    }

    /**
     * Check if another user is typing in the channel
     * Returns typing status only for OTHER users (not the requester)
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function typingStatus(Request $request)
    {
        // Validate request
        $validator = Validator::make($request->all(), [
            'channel_id' => 'required|uuid',
        ]);

        if ($validator->fails()) {
            return Response::json([
                'status' => 'error',
                'message' => 'Validation failed',
                'errors' => $validator->errors()
            ], 422);
        }

        $channelId = $request->input('channel_id');
        $currentUserId = Auth::id();

        try {
            // Get all users in the channel (except current user)
            $userIdsInChannel = DB::table('ch_channel_user')
                ->where('channel_id', $channelId)
                ->where('user_id', '!=', $currentUserId)
                ->pluck('user_id');

            // Check if any of them is typing
            foreach ($userIdsInChannel as $userId) {
                $key = "typing:{$channelId}:{$userId}";
                $timestamp = Cache::get($key);

                // Check if still valid (less than 3 seconds old)
                if ($timestamp && (now()->timestamp - $timestamp) < 3) {
                    // User is typing
                    $user = User::find($userId);

                    Log::info('✅ [Typing Status] Found active typing', [
                        'typing_user_id' => $userId,
                        'typing_user_name' => $user->name ?? 'Unknown',
                        'channel_id' => $channelId,
                        'requester_id' => $currentUserId
                    ]);

                    return Response::json([
                        'is_typing' => true,
                        'user_id' => $userId,
                        'user_name' => $user->name ?? null
                    ], 200);
                }
            }

            return Response::json(['is_typing' => false], 200);

        } catch (\Exception $e) {
            Log::error('❌ [Typing Status] Error checking typing status: ' . $e->getMessage());

            // Return false on error to avoid breaking the app
            return Response::json(['is_typing' => false], 200);
        }
    }
}

