<?php

namespace App\Http\Livewire\Admin\Admins;

use App\Jobs\MailJob;
use App\Models\Admin;
use App\Traits\SysPermissions;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;
use Exception;
use Twilio\Rest\Client;
use Illuminate\Support\Facades\URL;

class AddAdmin extends Component
{
    use FindGuard, SysPermissions, LivewireAlert;

    public $name;
    public $phone_number;
    public $email, $role;

    public $access = [];

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    protected function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'role' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:admins'],
            'phone_number' => ['required', 'numeric'],
        ];
    }

    /**
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    /**
     * update user password here
     */
    public function submit()
    {
        $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }


    public function linkOrRemovePrivilege(string $privilege)
    {
        // check if it exists in array
        if (in_array($privilege, $this->access)) {
            unset($this->access[array_search($privilege, $this->access)]);
        } else {
            $this->access[] = $privilege;
        }
    }

    public function confirmed()
    {
        $checkemail = Admin::where('email', $this->email)->get();
        if (count($checkemail) >= 1) {
            $this->alert('warning', 'Desculpe, este e-mail já foi enviado.');
            return back();
        }
        // generate password
        $password = rand(100000, 500000);
        // $password = rand(100000, 500000);
        // create officer here
        $hod = Admin::query()->create([
            'name' => $this->name,
            'email' => $this->email,
            'role' => $this->role,
            'phone_number' => $this->phone_number,
            'password' => bcrypt($password),
        ]);

        // assign roles/permissions
        // foreach ($this->access as $permission) {
        //     $hod->givePermissionTo($permission);
        // }
        // todo send sms
        try {
            $account_sid = getenv("TWILIO_SID");
            $auth_token = getenv("TWILIO_TOKEN");
            $twilio_number = getenv("TWILIO_FROM");

            $client = new Client($account_sid, $auth_token);

            // Generate the callback URL based on your route
            $callbackUrl = route('admin.login');

            // Include the URL on a new line using \n
            $message = "Ola " . $this->name . ", Voce foi registado no sistema de gestao escolar COPMOZ, o seu Email: $this->email  \ne a sua senha:" . $password . "\n \nLink para login: $callbackUrl";

            $client->messages->create('+258' . $this->phone_number, [
                'from' => $twilio_number,
                'body' => $message,
            ]);
        } catch (Exception $e) {
            $this->alert('error', 'Erro ao enviar notificações por SMS');
        }
        // send user account credentials
        dispatch(new MailJob(
            $this->name,
            $this->email,
            config('app.name') . ' Conta de administrador',
            'Sua conta foi ativada, por favor use ' . $password . ' como sua senha para fazer login.',
            true,
            route('admin.login'),
            'CHECK ACCOUNT'
        ))->onQueue('emails')->delay(1);

        Note::createSystemNotification(Admin::class, 'Nova conta do Admin', 'Você criou uma conta com sucesso ' . $this->name);
        $this->emit('noteAdded');
        $this->alert('success', 'Você criou o administrador com sucesso ' . $this->name);
        $this->reset();
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        return view('livewire.admin.admins.add-admin', [
            'permissions' => $this->permissions(),
        ]);
    }
}
