<?php

namespace App\Http\Livewire\User\Inc;

use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;

class Header extends Component
{
   
    use FindGuard, LivewireAlert;

    public $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = ['noteAdded' => 'incrementNoteCount'];

    public function incrementNoteCount()
    {
        $this->loadData();
    }

    public function markAsRead()
    {
        foreach (Note::unreadNotifications(false) as $notification) {
            $notification->status = true;
            $notification->forceDelete();
        }

        $this->loadData();
        $this->alert('success', 'Todas as notificações marcadas como lidas...');
    }

    public function logout()
    {
        $this->findGuardType()->logout();
        return redirect()->route('login');
    }

    public function render()
    {
        return view('livewire.user.inc.header', [
            'notifications' => $this->readyToLoad
                ? Note::unreadNotifications(false)
                : [],
            'user' => $this->findGuardType()->user()
        ]);
    }
}