<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Relatório final de cada disciplina</h5>
                            <form class="row g-3" wire:submit.prevent="generateReport">
                                  <div class="col-md-6">
                                    <label for="class" class="form-label">Classe</label>
                                    <select class="form-control @error('class') is-invalid @enderror"
                                            id="class" wire:model="class"
                                            class="form-control input-lg dynamic">
                                       <option value="">Selecione a classe</option>
                                        <option value="1">1ª Classe</option>
                                        <option value="2">2ª Classe</option>
                                        <option value="3">3ª Classe</option>
                                        <option value="4">4ª Classe</option>
                                        <option value="5">5ª Classe</option>
                                        <option value="6">6ª Classe</option>
                                        <option value="7">7ª Classe</option>
                                        <option value="8">8ª Classe</option>
                                        <option value="9">9ª Classe</option>
                                        <option value="10">10ª Classe</option>
                                        <option value="11">11ª Classe</option>
                                        <option value="12">12ª Classe</option>
                                    </select>
                                    @error('class')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="class" class="form-label">Turma</label>
                                    <div class="form-floating">

                                        <select name="number"
                                            class="form-control @error('class_id') is-invalid @enderror" id="class_id"
                                            required placeholder="Select Date" wire:model="class_id">
                                            <option value="2" selected="selected">Selecione a turma</option>
                                            @foreach ($classes as $class)
                                                <option value="{{ $class->id }}">{{ $class->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('class_id')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                @php ($teachers = array())
                                @foreach($teacher as $teach) 
                                    @php($teachers[] = $teach->subject_id)
                                @endforeach 
                                <div class="col-md-6">
                                    <label for="class" class="form-label">Disciplina </label>
                                    <div class="form-floating">

                                        <select name="number"
                                            class="form-control @error('subject_id') is-invalid @enderror"
                                            id="subject_id" required placeholder="" wire:model="subject_id">
                                            <option value="" selected="selected">Selecione disciplina</option>
                                            @foreach ($subjects as $subject)
                                                @if($user->role == 2 && in_array($subject->id,$teachers))
                                                    <option value="{{ $subject->id }}">{{ $subject->name }}</option>
                                                @elseif( $user->role == 3 || $user->role == 0)
                                                    <option value="{{ $subject->id }}">{{ $subject->name }}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                        @error('subject_id')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>


                                 <div class="col-md-6">
                                    <label for="class" class="form-label">Ano</label>
                                    <select class="form-control @error('year') is-invalid @enderror"
                                            id="class" wire:model="year"
                                            class="form-control input-lg dynamic">
                                        <option value="">Selecione o ano lectivo</option>
                                        <option value="2023">2023</option>
                                        <option value="2024" selected>2024</option>
                                        <option value="2025">2025</option>
                                        <option value="2026">2026</option>
                                        <option value="2027">2027</option>
                                        <option value="2028">2028</option>
                                        <option value="2029">2029</option>
                                        <option value="2030">2030</option>
                                    </select>
                                    @error('year')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary btn-lg float-end"
                                        wire:loading.class="disabled" wire:offline.attr="disabled"><span
                                            wire:target="generateReport"
                                            wire:loading.class="spinner-border spinner-border-lg"></span>
                                        Gerar relatório
                                    </button>
                                </div>
                            </form>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
