<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Adicionar nota do estudante {{ $model->name }}</h5>
                            <form class="row g-3" wire:submit.prevent="submit">
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Disciplina </label>
                                    <select class="form-control @error('subject_id') is-invalid @enderror" id="name"
                                        wire:model="subject_id" class="form-control input-lg dynamic">
                                        <option value="" selected>Selecione a disciplina</option>
                                        @foreach ($subjects as $subject)
                                            <option value="{{ $subject->id }}"> {{ $subject->name }} </option>
                                        @endforeach
                                    </select>
                                    @error('subject_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Trimestre </label>
                                    <select class="form-control @error('trimester_id') is-invalid @enderror" id="trimester_id"
                                        wire:model="trimester_id" class="form-control input-lg dynamic">
                                        <option value="">Selecione o trimestre</option>
                                        <option value="1">Primeiro trimestre</option>
                                        <option value="2">Segundo trimestre</option>
                                        <option value="3">Terceiro trimestre</option>

                                    </select>
                                    @error('trimester_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Tipo de teste </label>
                                    <select class="form-control @error('type') is-invalid @enderror" id="type"
                                        wire:model="type" class="form-control input-lg dynamic">
                                        <option value="" selected>Selecione o tipo de teste</option>
                                        <option value="1">ACS1</option>
                                        <option value="2">ACS2</option>
                                        <option value="3">AT</option>

                                    </select>
                                    @error('type')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="MACS" class="form-label">Nota</label>
                                    <input type="text" class="form-control @error('MACS') is-invalid @enderror" id="MACS"
                                        required placeholder="Insira a nota..." wire:model="MACS">
                                    @error('MACS')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Ano </label>
                                    <select class="form-control @error('years') is-invalid @enderror" id="years"
                                        wire:model="years" class="form-control input-lg dynamic">
                                        <option value="<?=date("Y")?>" selected><?=date("Y")?></option>
                                        <option value="2025">2025</option>
                                        <option value="2026">2026</option>
                                        <option value="2027">2027</option>
                                        <option value="2028">2028</option>

                                    </select>
                                    @error('type')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <br><br>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary btn-lg float-end"
                                            wire:loading.class="disabled"
                                            wire:offline.attr="disabled"><span wire:target="submit"
                                                                               wire:loading.class="spinner-border spinner-border-lg"></span>
                                        Guardar
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
