<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Relatório</h5>
                            <form class="row g-3" wire:submit.prevent="generateReport">
                                <div class="col-md-6">
                                    <label for="class" class="form-label">Trimestre</label>
                                    <div class="form-floating">

                                        <select name="text" class="form-control @error('trimester_id') is-invalid @enderror"
                                        id="trimester_id" required placeholder=""
                                        wire:model="trimester_id">
                                        <option value="1" selected="selected">Escolher trimestre</option>
                                            <option value="1" >Primeiro trimestre</option>
                                            <option value="2" >Segundo trimestre</option>
                                            <option value="3">Terceiro trimestre</option>
                                        </select>
                                        @error('trimester_id')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label for="class" class="form-label">Escolher classe</label>
                                    <div class="form-floating">

                                        <select name="number" class="form-control @error('class_id') is-invalid @enderror"
                                        id="class_id" required placeholder=""
                                        wire:model="class_id">
                                        <option value="2" selected="selected">Selecionar classe</option>
                                        @foreach ($classes as $class)
                                        <option value="{{ $class->id }}">{{ $class->name }}</option>
                                        @endforeach
                                        </select>
                                        @error('class_id')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label for="class" class="form-label">Escolher a disciplina</label>
                                    <div class="form-floating">

                                        <select name="number" class="form-control @error('subject_id') is-invalid @enderror"
                                        id="subject_id" required placeholder=""
                                        wire:model="subject_id">
                                            <option value="" selected="selected">Selecionar disciplina</option>
                                            @foreach ($subjects as $subject)
                                            <option value="{{ $subject->id }}">{{ $subject->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('subject_id')
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary btn-lg float-end"
                                            wire:loading.class="disabled"
                                            wire:offline.attr="disabled"><span wire:target="generateReport"
                                                                               wire:loading.class="spinner-border spinner-border-lg"></span>
                                        Gerar relatório
                                    </button>
                                </div>
                            </form>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
