<?php
namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;

class MessageSent implements ShouldBroadcast
{
    use SerializesModels;

    public $message;
    public $channelId;

    public function __construct($message, $channelId)
    {
        $this->message = $message;
        $this->channelId = $channelId;
    }

    public function broadcastOn()
    {
        return [
            new PrivateChannel('chatify.' . $this->channelId),
            new PrivateChannel('chatify.user-chat'), // Canal global
        ];
    }

    public function broadcastAs()
    {
        return 'messaging';
    }
}