<?php

namespace App\Exports;

use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class EstudantesExport implements FromCollection, WithHeadings, ShouldAutoSize, WithStyles
{
    protected $filters;

    public function __construct($filters = [])
    {
        $this->filters = $filters;
    }

    public function collection()
    {
        $query = User::query()->with('class');

        // Aplicar filtros
        if (!empty($this->filters['search'])) {
            $query->where(function ($q) {
                $q->where('name', 'like', '%' . $this->filters['search'] . '%')
                  ->orWhere('slug', 'like', '%' . $this->filters['search'] . '%')
                  ->orWhere('student_id', 'like', '%' . $this->filters['search'] . '%')
                  ->orWhere('phone_number', 'like', '%' . $this->filters['search'] . '%');
            });
        }

        if (!empty($this->filters['class'])) {
            $query->whereHas('class', function ($subQuery) {
                $subQuery->where('class', $this->filters['class']);
            });
        }

        if (!empty($this->filters['turma'])) {
            $query->where('classroom_id', $this->filters['turma']);
        }

        if (isset($this->filters['status']) && $this->filters['status'] !== '') {
            $query->where('is_active', $this->filters['status']);
        }

        if (isset($this->filters['payment']) && $this->filters['payment'] !== '') {
            $query->where('is_paid', $this->filters['payment']);
        }

        $estudantes = $query->orderBy('name')->get();

        return $estudantes->map(function ($estudante) {
            return [
                'nome' => $estudante->name,
                'id_estudante' => $estudante->student_id ?: '-',
                'classe' => $estudante->class ? $estudante->class->class . 'ª Classe ' . $estudante->class->name : '-',
                'telefone' => $estudante->phone_number ?: '-',
                'email' => $estudante->email ?: '-',
                'estado_pagamento' => $estudante->is_paid ? 'Pago' : 'Não Pago',
                'estado_acesso' => $estudante->is_active ? 'Ativo' : 'Desativado',
            ];
        });
    }

    public function headings(): array
    {
        return [
            'Nome',
            'ID Estudante',
            'Classe',
            'Telefone',
            'Email',
            'Estado de Pagamento',
            'Estado de Acesso',
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}
