<?php

namespace App\Helpers;

class NumberToWords
{
    private static $unidades = [
        '', 'um', 'dois', 'três', 'quatro', 'cinco', 'seis', 'sete', 'oito', 'nove'
    ];

    private static $dezenas = [
        '', '', 'vinte', 'trinta', 'quarenta', 'cinquenta', 'sessenta', 'setenta', 'oitenta', 'noventa'
    ];

    private static $dez_a_dezenove = [
        'dez', 'onze', 'doze', 'treze', 'catorze', 'quinze', 'dezasseis', 'dezassete', 'dezoito', 'dezanove'
    ];

    private static $centenas = [
        '', 'cento', 'duzentos', 'trezentos', 'quatrocentos', 'quinhentos', 'seiscentos', 'setecentos', 'oitocentos', 'novecentos'
    ];

    /**
     * Converte número para extenso
     */
    public static function convert($number): string
    {
        if (!is_numeric($number)) {
            return '';
        }

        $number = floatval($number);
        $inteiro = floor($number);
        $decimal = round(($number - $inteiro) * 100);

        $extenso = self::converterInteiro($inteiro);

        if ($decimal > 0) {
            $extenso .= ' e ' . self::converterInteiro($decimal) . ' centavos';
        }

        return $extenso;
    }

    private static function converterInteiro($numero): string
    {
        if ($numero == 0) {
            return 'zero';
        }

        if ($numero < 0) {
            return 'menos ' . self::converterInteiro(abs($numero));
        }

        $extenso = '';

        // Milhões
        if ($numero >= 1000000) {
            $milhoes = floor($numero / 1000000);
            $extenso .= self::converterCentenas($milhoes);
            $extenso .= $milhoes == 1 ? ' milhão' : ' milhões';
            $numero %= 1000000;
            if ($numero > 0) {
                $extenso .= $numero < 100 ? ' e ' : ', ';
            }
        }

        // Milhares
        if ($numero >= 1000) {
            $milhares = floor($numero / 1000);
            if ($milhares > 1) {
                $extenso .= self::converterCentenas($milhares) . ' mil';
            } else {
                $extenso .= 'mil';
            }
            $numero %= 1000;
            if ($numero > 0) {
                $extenso .= $numero < 100 ? ' e ' : ' ';
            }
        }

        // Centenas, dezenas e unidades
        if ($numero > 0) {
            $extenso .= self::converterCentenas($numero);
        }

        return trim($extenso);
    }

    private static function converterCentenas($numero): string
    {
        if ($numero == 100) {
            return 'cem';
        }

        $extenso = '';

        // Centenas
        if ($numero >= 100) {
            $centena = floor($numero / 100);
            $extenso .= self::$centenas[$centena];
            $numero %= 100;
            if ($numero > 0) {
                $extenso .= ' e ';
            }
        }

        // Dezenas especiais (10-19)
        if ($numero >= 10 && $numero <= 19) {
            $extenso .= self::$dez_a_dezenove[$numero - 10];
        }
        // Dezenas normais
        else if ($numero >= 20) {
            $dezena = floor($numero / 10);
            $extenso .= self::$dezenas[$dezena];
            $numero %= 10;
            if ($numero > 0) {
                $extenso .= ' e ';
            }
        }

        // Unidades
        if ($numero > 0 && $numero < 10) {
            $extenso .= self::$unidades[$numero];
        }

        return trim($extenso);
    }
}
