<?php

namespace App\Http\Livewire\Admin\Downloadcenter;

use App\Models\Admin;
use App\Models\Downloadcenter;
use App\Models\Classroom;
use App\Models\User;
use App\Models\Downloadfile;
use App\Models\Downloadsetings;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;
use App\Http\Controllers\SystemController;
use App\Models\Category;
use Livewire\WithFileUploads;
use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;
use Illuminate\Support\Facades\Log;
use Kreait\Firebase\Exception\Messaging\NotFound;
use App\Helpers\FirebaseHelper;


class AddDownload extends Component
{
    use FindGuard, LivewireAlert, WithFileUploads;

    
    public $media_details; 
    public $title, $description, $category_id, $photo,  $pdf, $author,  $validatedData, $type, $class_id, $student_id;
    public $photos = [];
    public $updateMode = false;
    public $user;
    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    protected array $rules = [
        'title' => ['required', 'string', 'max:255'],
        'author' => ['required', 'string', 'max:255'],
        'description' => ['nullable', 'string', 'max:255'],
        'photos.*' => ['required', 'mimes:pdf,doc,docx,xls,xlsx,png,jpeg,jpg,gif', 'max:51200'],
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);

    }


public function submit()
{
    $this->validate(); // Validate all fields including multiple files
    // Define a mensagem padrão
    $this->message = 'Nova matriz: "' . $this->title . ' autor: ' . $this->author . '" foi lançada.';

    $downloadcenter = Downloadcenter::create([
        'title' => $this->title,
        'author' => $this->author,
        'description' => $this->description,
    ]);

    // Set default type if empty
    if (empty($this->type)) {
        $this->type = "all";
    }

    Downloadsetings::create([
            'type' => $this->type,
            'class_id' => $this->class_id,
            'student_id' => $this->student_id,
            "download_id" => $downloadcenter->slug,
            "active" => "active",
        ]);

    foreach ($this->photos as $photo) {
        $details = SystemController::store_media($photo);

        Downloadfile::create([
            'download_id' => $downloadcenter->slug,
            'media_name' => $details[0],
            'media_url' => $details[1],
        ]);
    }

    Note::createSystemNotification(Admin::class, 'Nova matriz', 'Nova matriz adicionada com sucesso ' . $this->title);
        $this->emit('noteAdded');
        $this->alert('success', 'Nova matriz adicionada com sucesso ' . $this->title);

         // Save values before reset
         $title = $this->title;
         $message = $this->message;
         $notificationType = $this->type;
         $classId = $this->class_id;
         $studentId = $this->student_id;
         $downloadId = $downloadcenter->slug;
         // Get first file URL (or you can send all files)
         $firstFile = Downloadfile::where('download_id', $downloadcenter->slug)->first();
         $mediaUrl = $firstFile ? $firstFile->media_url : '';

    // Reset fields and flash success message
     $this->reset(['title', 'author', 'description', 'photos', 'type', 'class_id', 'student_id']);
     session()->flash('success', 'Push notification sent successfully.');

         // Check the type of notification
         try {
            if ($notificationType == 'all') {
                $users = User::whereHas('deviceTokens')->get();
            } elseif ($notificationType == 'class') {
                $users = User::where('classroom_id', $classId)->get();
            } elseif ($notificationType == 'student') {
                $user = User::find($studentId);
                $users = $user ? [$user] : [];
            } else {
                $users = [];
            }

            if (!empty($users)) {
                self::sendNotificationsStatic($users, $downloadId, $mediaUrl, $title, $message);
            }
        } catch (\Exception $e) {
            Log::channel('log_notifications')->error('Error sending notifications: ' . $e->getMessage());
        }
   
}

 
    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }


    private static function sendNotificationsStatic($users, $downloadId, $mediaUrl, $title, $message)
{
    // Get Firebase credentials from environment variables
    $firebaseCredentials = FirebaseHelper::getCredentials();

    $factory = (new Factory)->withServiceAccount($firebaseCredentials);
    $messaging = $factory->createMessaging();

    foreach ($users as $user) {
        $deviceTokens = $user->deviceTokens;
        $successfulSend = false;

        foreach ($deviceTokens as $deviceToken) {
            $token = $deviceToken->token;

            try {
                // FCM tokens are typically 140-163 characters long
                if (strlen($token) >= 140 && strlen($token) <= 200) {
                    $notification = Notification::create($title, $message);

                    $fcmMessage = CloudMessage::withTarget('token', $token)
                        ->withNotification($notification)
                        ->withData([
                            'download_id' => (string) $downloadId,
                            'media_url' => (string) $mediaUrl,
                            'type' => 'download',
                            'click_action' => 'FLUTTER_NOTIFICATION_CLICK',
                        ])
                        ->withHighestPossiblePriority()
                        ->withDefaultSounds();

                    $messaging->send($fcmMessage);
                    $successfulSend = true;
                    Log::channel('log_notifications')->info("Notification sent successfully to {$user->name} via token: " . substr($token, 0, 20) . "... with file: " . $mediaUrl);
                } else {
                    // Token length invalid - delete it
                    Log::channel('log_notifications')->warning("Deleting invalid token for user: {$user->name} - Token invalid length (length: " . strlen($token) . ")");
                    $deviceToken->delete();
                }
            } catch (NotFound $e) {
                // Token not found in Firebase - it's invalid/expired, delete it
                Log::channel('log_notifications')->warning("Deleting invalid token for user: {$user->name} - Token not found in Firebase");
                $deviceToken->delete();
            } catch (\Kreait\Firebase\Exception\MessagingException $e) {
                // Firebase messaging error - likely invalid token, delete it
                Log::channel('log_notifications')->warning("Deleting invalid token for user: {$user->name} - Firebase error: {$e->getMessage()}");
                $deviceToken->delete();
            } catch (\Exception $e) {
                // Other errors - log but don't delete token
                Log::channel('log_notifications')->error("Error sending notification to {$user->name}: {$e->getMessage()}");
            }
        }

        if (!$successfulSend && $deviceTokens->count() > 0) {
            Log::channel('log_notifications')->error("Failed to send notification to {$user->name} - All tokens were invalid or failed");
        }
    }
}

    public function render()
    {
        if(!empty($this->type)){
            return view('livewire.admin.downloadcenter.add-download', [
                'Classroom' => Classroom::query()->orderBy('class')->get(),
                'students' => User::Where("classroom_id",$this->class_id)->get(),
            ]);
        }else{
            return view('livewire.admin.downloadcenter.add-download', [
                'Classroom' => Classroom::query()->orderBy('class')->get(),
            ]);
        }
    }
}
