<?php

namespace App\Http\Livewire\Admin\Downloadcenter;


use App\Http\Controllers\SystemController;
use App\Models\Downloadcenter;
use App\Models\Downloadsetings;
use App\Models\User;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithFileUploads;
use Note\Note;

class EditDownload extends Component
{
    use FindGuard, LivewireAlert;

    public $title, $photo, $category_id, $description, $pdf, $author, $user, $slug;
    public $validatedData;
    public $updateMode = false;

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function mount($slug)
    {
        $model = Downloadcenter::query()->where('slug', $slug)->first();

        if (!$model) {
            abort(404, 'Matriz não encontrada');
        }

        // Store slug instead of the entire model
        $this->slug = $slug;
        $this->title = $model->title;
        $this->author = $model->author;
        $this->description = $model->description;
    }

    protected array $rules = [
        'title' => ['required', 'string'],
        'author' => ['required', 'string'],
        'description' => ['required', 'string'],
      //'category_id' => ['required', 'string'],
        'photo' => ['nullable'], // 2MB Max
      //'pdf' => ['nullable', 'mimes:pdf'], // 2MB Max
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function submit()
    {
        $this->validatedData = $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        // Reload the model using the slug
        $model = Downloadcenter::query()->where('slug', $this->slug)->first();

        if (!$model) {
            $this->alert('error', 'Matriz não encontrada');
            return;
        }

        // Prepare update data
        $updateData = [
            'title' => $this->title,
            'author' => $this->author,
            'description' => $this->description
        ];

        // Add photo if uploaded
        if ($this->photo) {
            $details = SystemController::store_media($this->photo);
            $updateData['media_name'] = $details[0];
            $updateData['media_url'] = $details[1];
        }

        // Add PDF if uploaded
        if ($this->pdf) {
            $pdfde = SystemController::store_media($this->pdf);
            $updateData['pdf_name'] = $pdfde[0];
            $updateData['pdf_url'] = $pdfde[1];
        }

        // Single update with all data
        try {
            $model->update($updateData);
        } catch (\Exception $e) {
            $this->alert('error', 'Erro ao atualizar: ' . $e->getMessage());
            return;
        }

        Note::createSystemNotification(\App\Models\Admin::class, 'Detalhes', "Atualizado com sucesso {$this->title}");
        $this->emit('noteAdded');
        $this->alert('success', "Atualizado com sucesso {$this->title}");

        // Redirect first, then reset is not needed
        return redirect()->route('admin.downloads');
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }
    public function render()
    {
        return view('livewire.admin.downloadcenter.edit-download', [
            //'subjects' => Category::query()->orderBy('name')->get(),
        ]);
    }
}
