<?php

namespace App\Http\Livewire\Admin\Fee;

use App\Models\Admin;
use App\Models\FeeGroup;
use App\Models\FeeType;
use App\Models\FeeMaster1;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use App\Models\FeeStructure;

class ListFeeMaster extends Component
{
    use WithPagination, FindGuard, LivewireAlert;

    public $search, $delete, $deleteFeeStructure;
    protected $queryString = ['search'];
    protected string $paginationTheme = 'bootstrap';
    public bool $readyToLoad = false;

    protected $listeners = [
        'confirmed',
        'cancelled',
        'FeeMasterDeleted' => '$refresh', // 🔥 Auto-refresh on deletion
        'FeeStructureDeleted' => '$refresh', 
    ];

    /**
     * Reset pagination when searching
     */
    public function updatingSearch()
    {
        $this->resetPage();
    }

    /**
     * Load data when triggered
     */
    public function loadData()
    {
        $this->readyToLoad = true;
        $this->dispatchBrowserEvent('refreshTable'); // 🔥 Ensure UI updates
    }

       public function toggleActiveStatus($id)
    {
        // Find the FeeStructure by its ID
        $feeStructure = FeeStructure::find($id);

        // Toggle the active status
        $feeStructure->active = !$feeStructure->active;

        // Save the changes to the database
        $feeStructure->save();

        // Show a success message
        $this->alert('success', 'Status atualizado com sucesso!');
    }

    /**
     * Confirm delete action
     */
    // public function submit($id)
    // {
    //     $this->delete = FeeMaster1::query()->firstWhere('id', $id);
    //     $this->confirm('Tem certeza de que deseja prosseguir?', [
    //         'toast' => false,
    //         'position' => 'center',
    //         'showConfirmButton' => true,
    //         'confirmButtonText' => 'Sim, eu tenho certeza!',
    //         'cancelButtonText' => 'Não, cancelar!',
    //         'onConfirmed' => 'confirmed',
    //         'onDismissed' => 'cancelled'
    //     ]);
    // }

    public function submit($id, $type)
    {
        if ($type === 'master') {
            $this->delete = FeeMaster1::query()->firstWhere('id', $id);
            $this->confirm('Tem certeza de que deseja prosseguir?', [
                'toast' => false,
                'position' => 'center',
                'showConfirmButton' => true,
                'confirmButtonText' => 'Sim, eu tenho certeza!',
                'cancelButtonText' => 'Não, cancelar!',
                'onConfirmed' => 'confirmed',
                'onDismissed' => 'cancelled'
            ]);
        } elseif ($type === 'structure') {
            // Ensure this is setting the FeeStructure correctly
            $this->deleteFeeStructure = FeeStructure::find($id); // Using `find` method directly
            if ($this->deleteFeeStructure) {
                FeeStructure::where('id', $this->deleteFeeStructure->id)->delete();

                // Emit event to refresh the list
                $this->emit('FeeStructureDeleted');

                // Reset the component state
                $this->reset(['deleteFeeStructure']);
                $this->resetPage(); // 🔥 Reset pagination to avoid errors

                // Show success alert
                $this->alert('success', 'Fee Structure Deletado com sucesso');
            } else {
                $this->alert('error', 'FeeStructure not found.');
            }
        }
    }

    /**
     * Delete FeeMaster and refresh list
     */
    public function confirmed()
    {
        FeeMaster1::where('id', $this->delete->id)->delete();
        
        // Emit event to refresh list
        $this->emit('FeeMasterDeleted');

        // Reset component state
        $this->reset(['delete']);
        $this->resetPage(); // 🔥 Reset pagination to avoid errors

        // Show success alert
        $this->alert('success', 'Deletado com sucesso');
    }

    public function confirmedFeeStructureuu()
    {
        // Check if the FeeStructure exists and then proceed to delete
        if ($this->deleteFeeStructure) {
            // Debugging - Check the FeeStructure object
            dd($this->deleteFeeStructure); // Remove after debugging

            // Perform the deletion
            FeeStructure::where('id', $this->deleteFeeStructure->id)->delete();

            // Emit event to refresh the list
            $this->emit('FeeStructureDeleted');

            // Reset the component state
            $this->reset(['deleteFeeStructure']);
            $this->resetPage(); // 🔥 Reset pagination to avoid errors

            // Show success alert
            $this->alert('success', 'Fee Structure Deletado com sucesso');
        } else {
            $this->alert('error', 'Erro ao excluir. Não encontrado.');
        }
    }


    /**
     * Handle cancel action
     */
    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    /**
     * Edit fee structure - redirect to add page with ID
     */
    public function edit($id)
    {
        return redirect()->route('admin.add.feemaster', ['id' => $id]);
    }

    /**
     * Render Livewire component
     */
    public function render()
    {
        $feeMasters = $this->readyToLoad
            ? FeeMaster1::with(['FeeGroup', 'FeeType'])
                ->whereHas('FeeGroup', function ($query) {
                    $query->where('name', 'like', '%' . $this->search . '%');
                })
                ->latest('updated_at')
                ->paginate(10) // Paginate first
            : collect(); // Return an empty collection if data not loaded

        // Group the paginated result by FeeGroup name
        $feeGroups = $feeMasters->groupBy(function ($item) {
            return $item->feeGroup->name ?? 'Uncategorized'; // Ensure it doesn't break if null
        });

         $feeStructures = $this->readyToLoad
            ? FeeStructure::latest()->paginate(10) // Paginate FeeStructures
            : collect(); // Return an empty collection if data is not loaded



        return view('livewire.admin.fee.list-fee-master', [
            'feeGroups' => $feeGroups,
            'feeMasters' => $feeMasters, // For pagination links
            'feeStructures' => $feeStructures, 
        ]);
    }
}
