<?php

namespace App\Http\Livewire\Admin\Noticeboard;

use App\Models\Admin;
use App\Models\Classroom;
use App\Models\User;
use App\Models\Noticeboard;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;
use App\Http\Controllers\SystemController;
use App\Http\Controllers\PushNotificationController;
use App\Models\Category;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\Auth;
use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;
use Illuminate\Support\Facades\Log;
use Kreait\Firebase\Exception\Messaging\NotFound;
use App\Helpers\FirebaseHelper;

class AddNotice extends Component
{
    use FindGuard, LivewireAlert, WithFileUploads;

    public $title, $description, $category_id, $photo,$pdf,  $validatedData, $type, $class_id, $student_id, $created_by;
    public $updateMode = false;
    public $user;
    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    protected array $rules = [
        'title' => ['required', 'string', 'max:255'],
        //'photo' => ['required'], // 2MB Max
        //'pdf' => ['required', 'mimes:pdf'], // 2MB Max
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);

    }

    public function submit()
    {
    $this->validatedData = $this->validate();
    // Retrieve the currently logged-in user
    $user = Auth::user();
    // Define a mensagem padrão
    $this->message = 'Novo comunicado: "' . $this->title . '" foi lançado.';

    // Ensure the user is not null
    if (!$user) {
        $this->alert('error', 'Usuário não autenticado.');
        return;
    }

        $details = SystemController::store_media($this->photo);

        if(empty($this->type)){
            $this->type = "all";
        }

        $downloadcenter = Noticeboard::query()->create([
            'title' => $this->title,
            'description' => $this->description,
            'media_name'=> $details[0],
            'media_url'=>$details[1],
            'type'=>$this->type,
            'class_id'=> $this->class_id,
            'student_id'=>$this->student_id,
            'created_by'=>$user->id,
        ]);

        Note::createSystemNotification(Admin::class, 'Novo comunicado', 'Novo comunicado adicionado com sucesso ' . $this->title);
        $this->emit('noteAdded');
        $this->alert('success', 'Novo comunicado adicionado com sucesso ' . $this->title);

        // Save values before reset
        $title = $this->title;
        $message = $this->message;
        $notificationType = $this->type;
        $classId = $this->class_id;
        $studentId = $this->student_id;
        $comunicadoId = $downloadcenter->id;
        $mediaUrl = $details[1];

        // Reset fields
        $this->reset(['title', 'photo', 'type', 'class_id', 'student_id', 'created_by']);
        session()->flash('success', 'Push notification sent successfully.');

        // Send notifications synchronously but quickly
        try {
            if ($notificationType == 'all') {
                $users = User::whereHas('deviceTokens')->get();
            } elseif ($notificationType == 'class') {
                $users = User::where('classroom_id', $classId)->get();
            } elseif ($notificationType == 'student') {
                $user = User::find($studentId);
                $users = $user ? [$user] : [];
            } else {
                $users = [];
            }

            if (!empty($users)) {
                self::sendNotificationsStatic($users, $comunicadoId, $mediaUrl, $title, $message);
            }
        } catch (\Exception $e) {
            Log::channel('log_notifications')->error('Error sending notifications: ' . $e->getMessage());
        }
    }

    public function confirmed()
    {

        
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }
    public function render()
    {
        if(!empty($this->type)){
            return view('livewire.admin.noticeboard.add-notice', [
                'Classroom' => Classroom::query()->orderBy('class')->get(),
                'students' => User::Where("classroom_id",$this->class_id)->get(),
            ]);
        }else{
            return view('livewire.admin.noticeboard.add-notice', [
                'Classroom' => Classroom::query()->orderBy('class')->get(),
            ]);
        }
    }


    private static function sendNotificationsStatic($users, $comunicadoId, $mediaUrl, $title, $message)
    {
        // Get Firebase credentials from environment variables
        $firebaseCredentials = FirebaseHelper::getCredentials();

        $factory = (new Factory)->withServiceAccount($firebaseCredentials);
        $messaging = $factory->createMessaging();

        foreach ($users as $user) {
            $deviceTokens = $user->deviceTokens;
            $successfulSend = false;

            foreach ($deviceTokens as $deviceToken) {
                $token = $deviceToken->token;

                try {
                    // FCM tokens are typically 140-163 characters long
                    if (strlen($token) >= 140 && strlen($token) <= 200) {
                        $notification = Notification::create($title, $message);

                        $fcmMessage = CloudMessage::withTarget('token', $token)
                            ->withNotification($notification)
                            ->withData([
                                'comunicado_id' => (string) $comunicadoId,
                                'media_url' => (string) $mediaUrl,
                                'type' => 'comunicado',
                                'click_action' => 'FLUTTER_NOTIFICATION_CLICK',
                            ])
                            ->withHighestPossiblePriority()
                            ->withDefaultSounds();

                        $messaging->send($fcmMessage);
                        $successfulSend = true;
                        Log::channel('log_notifications')->info("Notification sent successfully to {$user->name} via token: " . substr($token, 0, 20) . "... with file: " . $mediaUrl);
                    } else {
                        // Token length invalid - delete it
                        Log::channel('log_notifications')->warning("Deleting invalid token for user: {$user->name} - Token invalid length (length: " . strlen($token) . ")");
                        $deviceToken->delete();
                    }
                } catch (NotFound $e) {
                    // Token not found in Firebase - it's invalid/expired, delete it
                    Log::channel('log_notifications')->warning("Deleting invalid token for user: {$user->name} - Token not found in Firebase");
                    $deviceToken->delete();
                } catch (\Kreait\Firebase\Exception\MessagingException $e) {
                    // Firebase messaging error - likely invalid token, delete it
                    Log::channel('log_notifications')->warning("Deleting invalid token for user: {$user->name} - Firebase error: {$e->getMessage()}");
                    $deviceToken->delete();
                } catch (\Exception $e) {
                    // Other errors - log but don't delete token
                    Log::channel('log_notifications')->error("Error sending notification to {$user->name}: {$e->getMessage()}");
                }
            }

            if (!$successfulSend && $deviceTokens->count() > 0) {
                Log::channel('log_notifications')->error("Failed to send notification to {$user->name} - All tokens were invalid or failed");
            }
        }
    }
}
