<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckExcelImportPermission
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = auth()->user();

        // Check if user has permission to import Excel files
        if ($user->role === 0 || $user->role === 3) { // Admin or Academic registrar
            return $next($request);
        }

        if ($user->role === 2) { // Teacher
            // Check if teacher is allowed to add marks
            if ($user->canAddMarks === 'yes') {
                return $next($request);
            }
        }

        abort(403, 'You do not have permission to import Excel files.');
    }
}
