<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Chatify\Traits\UUID;

class ChMessage extends Model
{
    use UUID;

    protected $fillable = [
        'from_id',
        'to_id',
        'to_channel_id',
        'body',
        'attachment',
        'seen',
        'reply_id'
    ];

    protected $casts = [
        'seen' => 'array'
    ];

    /**
     * Relationship to the original message (for replies)
     */
    public function replyTo()
    {
        return $this->belongsTo(ChMessage::class, 'reply_id', 'id');
    }
}
