<?php

//ANTIGO
//namespace App\Models;
//
//use Illuminate\Database\Eloquent\Model;
//
//class PaymentReference extends Model
//{
//    protected $table = 'payment_references';
//    
//    protected $fillable = [
//        'student_id',
//        'entity_code',
//        'reference_number',
//        'amount',
//        'fee_month',
//        'fee_year',
//        'expires_at',
//        'status'
//    ];
//
//    protected $casts = [
//        'amount' => 'decimal:2',
//        'fee_year' => 'integer',
//        'expires_at' => 'datetime',
//    ];
//
//    // Relacionamento com o estudante
//    public function student()
//    {
//        return $this->belongsTo(User::class, 'student_id');
//    }
//
//    // Scopes
//    public function scopePending($query)
//    {
//        return $query->where('status', 'pending');
//    }
//
//    public function scopePaid($query)
//    {
//        return $query->where('status', 'paid');
//    }
//
//    public function scopeForStudent($query, $studentId)
//    {
//        return $query->where('student_id', $studentId);
//    }
//
//    public function scopeForMonth($query, $month, $year)
//    {
//        return $query->where('fee_month', $month)->where('fee_year', $year);
//    }
//}


////NOVO COM BMEPS
//namespace App\Models;
//
//use Illuminate\Database\Eloquent\Factories\HasFactory;
//use Illuminate\Database\Eloquent\Model;
//
//class PaymentReference extends Model
//{
//    use HasFactory;
//
//    protected $table = 'payment_references';
//
//    protected $fillable = [
//        'student_id',
//        'entity_code',
//        'reference_number',
//        'amount',
//        'fee_month',
//        'fee_year',
//        'expires_at',
//        'status',
//
//        // Campos BMEPS (certifique-se de que existem na tabela)
//        'paid_at',
//        'paid_amount',
//        'commission_charged',
//        'bmeps_transaction_id',
//    ];
//
//    protected $casts = [
//        'amount' => 'decimal:2',
//        'paid_amount' => 'decimal:2',
//        'commission_charged' => 'decimal:2',
//        'fee_year' => 'integer',
//        'expires_at' => 'datetime',
//        'paid_at' => 'datetime',
//    ];
//
//    protected $dates = [
//        'expires_at',
//        'paid_at',
//    ];
//
//    /* ========================
//     * Relacionamentos
//     * ====================== */
//
//    // FK na própria payment_references (opcional, se usares essa coluna)
//    public function bmepsTransactionBySelfFk()
//    {
//        return $this->belongsTo(BmepsTransaction::class, 'bmeps_transaction_id');
//    }
//
//    // Relação preferida: BmepsTransaction tem 'payment_reference_id'
//    public function bmepsTransaction()
//    {
//        // hasOne usa por padrão 'payment_reference_id' em bmeps_transactions
//        return $this->hasOne(BmepsTransaction::class);
//    }
//
//    public function student()
//    {
//        return $this->belongsTo(User::class, 'student_id');
//    }
//
//    /* ========================
//     * Scopes
//     * ====================== */
//
//    public function scopePending($query)
//    {
//        return $query->where('status', 'pending');
//    }
//
//    public function scopePaid($query)
//    {
//        return $query->where('status', 'paid');
//    }
//
//    public function scopeExpired($query)
//    {
//        return $query->where('status', 'expired');
//    }
//
//    public function scopeForStudent($query, $studentId)
//    {
//        return $query->where('student_id', $studentId);
//    }
//
//    public function scopeForMonth($query, $month, $year)
//    {
//        return $query->where('fee_month', $month)->where('fee_year', $year);
//    }
//
//    public function scopeExpiringSoon($query, $days = 3)
//    {
//        return $query->where('status', 'pending')
//                     ->where('expires_at', '<=', now()->addDays($days));
//    }
//
//    public function scopeByAmountRange($query, $min, $max)
//    {
//        return $query->whereBetween('amount', [$min, $max]);
//    }
//
//    /* ========================
//     * Acessores / Helpers de UI
//     * ====================== */
//
//    public function getStatusBadgeAttribute()
//    {
//        $badges = [
//            'paid'     => '<span class="badge bg-success">Pago</span>',
//            'pending'  => '<span class="badge bg-warning">Pendente</span>',
//            'expired'  => '<span class="badge bg-danger">Expirado</span>',
//            'cancelled'=> '<span class="badge bg-secondary">Cancelado</span>',
//        ];
//        return $badges[$this->status] ?? '<span class="badge bg-light text-dark">Desconhecido</span>';
//    }
//
//    public function getFormattedReferenceAttribute()
//    {
//        $ref = $this->reference_number;
//        if (strlen($ref) === 11) {
//            return substr($ref, 0, 3) . ' ' . substr($ref, 3, 3) . ' ' . substr($ref, 6, 3) . ' ' . substr($ref, 9, 2);
//        }
//        return $ref;
//    }
//
//    public function getIsExpiredAttribute()
//    {
//        return $this->expires_at && $this->expires_at->isPast() && $this->status === 'pending';
//    }
//
//    public function getDaysUntilExpiryAttribute()
//    {
//        if (!$this->expires_at || $this->status !== 'pending') {
//            return null;
//        }
//        return now()->diffInDays($this->expires_at, false);
//    }
//
//    public function getFormattedAmountAttribute()
//    {
//        return number_format($this->amount, 2, ',', '.') . ' MT';
//    }
//
//    public function getFormattedPaidAmountAttribute()
//    {
//        return $this->paid_amount !== null
//            ? number_format($this->paid_amount, 2, ',', '.') . ' MT'
//            : 'N/A';
//    }
//
//    public function getExpiryStatusAttribute()
//    {
//        if ($this->status !== 'pending' || !$this->expires_at) {
//            return null;
//        }
//        $d = $this->days_until_expiry;
//        if ($d < 0)  return 'expired';
//        if ($d <= 1) return 'expires_today';
//        if ($d <= 3) return 'expires_soon';
//        return 'active';
//    }
//
//    public function getExpiryStatusBadgeAttribute()
//    {
//        $badges = [
//            'expired'       => '<span class="badge bg-danger">Expirado</span>',
//            'expires_today' => '<span class="badge bg-warning">Expira Hoje</span>',
//            'expires_soon'  => '<span class="badge bg-warning">Expira em Breve</span>',
//            'active'        => '<span class="badge bg-success">Ativo</span>',
//        ];
//        return $badges[$this->expiry_status] ?? '';
//    }
//
//    public function getProfitMarginAttribute()
//    {
//        if (!$this->commission_charged || !$this->paid_amount) {
//            return 0;
//        }
//        return round(($this->commission_charged / $this->paid_amount) * 100, 2);
//    }
//
//    public function isPaid(): bool     { return $this->status === 'paid'; }
//    public function isPending(): bool  { return $this->status === 'pending'; }
//    public function isExpired(): bool  { return $this->is_expired; }
//    public function canBePaid(): bool  { return $this->status === 'pending' && !$this->is_expired; }
//
//    public function hasDiscrepancy(): bool
//    {
//        if ($this->paid_amount === null || $this->amount === null) return false;
//        return abs($this->paid_amount - $this->amount) > 0.01;
//    }
//
//    public function getDiscrepancyAmount(): float
//    {
//        return $this->hasDiscrepancy()
//            ? round($this->paid_amount - $this->amount, 2)
//            : 0.0;
//    }
//
//    public function isRecentlyPaid(int $days = 7): bool
//    {
//        return $this->paid_at && $this->paid_at->greaterThan(now()->subDays($days));
//    }
//
//    public function getPaymentDelay(): ?int
//    {
//        if (!$this->paid_at) return null;
//        return $this->created_at?->diffInDays($this->paid_at);
//    }
//
//    /* ========================
//     * Mutators
//     * ====================== */
//
//    public function setReferenceNumberAttribute($value)
//    {
//        // Garante 11 dígitos numéricos
//        $this->attributes['reference_number'] = str_pad(
//            preg_replace('/\D/', '', (string) $value),
//            11,
//            '0',
//            STR_PAD_LEFT
//        );
//    }
//
//    public function setFeeMonthAttribute($value)
//    {
//        $months = [
//            'janeiro' => 'January', 'jan' => 'January',
//            'fevereiro' => 'February', 'feb' => 'February',
//            'março' => 'March', 'mar' => 'March',
//            'abril' => 'April', 'apr' => 'April',
//            'maio' => 'May', 'may' => 'May',
//            'junho' => 'June', 'jun' => 'June',
//            'julho' => 'July', 'jul' => 'July',
//            'agosto' => 'August', 'aug' => 'August',
//            'setembro' => 'September', 'sep' => 'September',
//            'outubro' => 'October', 'oct' => 'October',
//            'novembro' => 'November', 'nov' => 'November',
//            'dezembro' => 'December', 'dec' => 'December',
//        ];
//
//        $normalized = strtolower(trim((string) $value));
//        $this->attributes['fee_month'] = $months[$normalized] ?? ucfirst($normalized);
//    }


namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class PaymentReference extends Model
{
    protected $fillable = [
        'student_id',
        'entity_code',
        'reference_number',
        'amount',
        'fee_month',
        'fee_year',
        'status',
        'expires_at',
        'paid_at'
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'fine_amount' => 'decimal:2',
        'expires_at' => 'datetime',  // CORRIGIDO: datetime ao invés de date
        'paid_at' => 'datetime',
    ];

    public function student(): BelongsTo
    {
        return $this->belongsTo(User::class, 'student_id');
    }

    public function bmepsTransactions(): HasMany
    {
        return $this->hasMany(BmepsTransaction::class);
    }

    public function feeAssigns(): HasMany
    {
        return $this->hasMany(FeeAssign::class);
    }
}

