<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Http\Resources\Json\JsonResource;



class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
        // Override Chatify Messenger to support reply_id
        app()->bind('ChatifyMessenger', function () {
            return new \App\Services\ChatifyMessenger;
        });
    }

   public function boot()
    {
        JsonResource::withoutWrapping();

        // Set global JSON response behavior
        response()->macro('json', function ($value = null, $status = 200, array $headers = [], $options = 0) {
            return response()->json($value, $status, $headers, $options | JSON_UNESCAPED_UNICODE);
        });
    }
}
