<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('fee_month_deadlines', function (Blueprint $table) {
            $table->id();
            $table->string('month'); // Janeiro, Fevereiro, Março, etc.
            $table->integer('year'); // 2025, 2026, etc.
            $table->date('deadline')->nullable(); // Data limite para gerar referência (null = sem limite)
            $table->boolean('allow_late_payment')->default(true); // Permitir pagamento após prazo
            $table->text('notes')->nullable(); // Observações administrativas
            $table->timestamps();

            // Índice único para evitar duplicação
            $table->unique(['month', 'year']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('fee_month_deadlines');
    }
};
