<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Estudantes Regulares</title>
    <style>
        @page {
            size: A4;
            margin: 15mm;
        }
        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
            margin: 0;
            padding: 0;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #28a745;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            font-size: 18px;
            font-weight: bold;
        }
        .header p {
            margin: 5px 0;
            color: #666;
            font-size: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }
        thead {
            background-color: #28a745;
            color: white;
        }
        th {
            padding: 8px 5px;
            text-align: left;
            font-size: 10px;
            font-weight: bold;
        }
        td {
            padding: 6px 5px;
            border-bottom: 1px solid #ddd;
            font-size: 9px;
        }
        tr:nth-child(even) {
            background-color: #f8f9fa;
        }
        .footer {
            margin-top: 20px;
            text-align: center;
            font-size: 9px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        .badge-regular {
            background-color: #28a745;
            color: white;
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 8px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>COLÉGIO POLITÉCNICO DE MOÇAMBIQUE</h1>
        <p>Estudantes Regulares (Com Pagamento em Dia)</p>
        <p>Gerado em: {{ date('d/m/Y H:i') }}</p>
    </div>

    <table>
        <thead>
            <tr>
                @foreach($headings as $heading)
                    <th>{{ $heading }}</th>
                @endforeach
            </tr>
        </thead>
        <tbody>
            @foreach($students as $student)
                <tr>
                    <td><strong>{{ $student['nome'] }}</strong></td>
                    <td>{{ $student['email'] }}</td>
                    <td>{{ $student['telefone'] }}</td>
                    <td>{{ $student['classe_turma'] }}</td>
                    <td><span class="badge-regular">{{ $student['estado'] }}</span></td>
                    <td>{{ $student['data'] }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        <p><strong>Total de estudantes regulares:</strong> {{ count($students) }}</p>
        <p>Este documento foi gerado automaticamente pelo sistema.</p>
    </div>
</body>
</html>
