<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card shadow-sm border-0">
                        <div class="card-body" wire:init="loadData">
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <div>
                                    <h5 class="card-title mb-1" style="color: #374151; font-weight: 600; font-size: 1.5rem;">
                                        <i class="fas fa-chalkboard-teacher" style="color: #667eea;"></i>
                                        Minhas Classes
                                    </h5>
                                    <p class="text-muted mb-0" style="font-size: 0.9rem;">Gerencie as turmas que você leciona</p>
                                </div>
                            </div>

                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <div class="input-group shadow-sm">
                                        <span class="input-group-text bg-white border-end-0" style="border-color: #e5e7eb;">
                                            <i class="fas fa-search text-muted"></i>
                                        </span>
                                        <input type="search"
                                               wire:model="search"
                                               placeholder="Pesquisar por turma, classe ou descrição..."
                                               class="form-control border-start-0"
                                               style="border-color: #e5e7eb; padding-left: 0;">
                                    </div>
                                </div>
                            </div>
                            <div class="table-responsive" wire:init="loadData">
                                @if(count($models))
                                    <table class="table table-hover align-middle">
                                        <thead style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                                        <tr>
                                            <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">#</th>
                                            <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                <i class="fas fa-door-open me-2"></i>Turma
                                            </th>
                                            <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                <i class="fas fa-layer-group me-2"></i>Classe
                                            </th>
                                            <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                <i class="fas fa-info-circle me-2"></i>Descrição
                                            </th>
                                            <th scope="col" class="text-center" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                <i class="fas fa-users me-2"></i>Estudantes
                                            </th>
                                            <th scope="col" style="font-weight: 600; font-size: 0.875rem; border: none;">
                                                <i class="fas fa-calendar-alt me-2"></i>Criado em
                                            </th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @php($count = 1)
                                        @foreach($models as $model)
                                            <tr style="border-bottom: 1px solid #f3f4f6;">
                                                <th scope="row" style="color: #9ca3af; font-weight: 500;">{{ $count++ }}</th>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-circle me-2" style="width: 40px; height: 40px; border-radius: 50%; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 0.9rem;">
                                                            {{ substr($model->name, 0, 1) }}
                                                        </div>
                                                        <span style="color: #374151; font-weight: 600;">{{ $model->name }}</span>
                                                    </div>
                                                </td>
                                                <td>
                                                    <span class="badge" style="background-color: #4f46e5; font-size: 0.875rem; padding: 0.5rem 0.75rem;">
                                                        {{ $model->class }}ª Classe
                                                    </span>
                                                </td>
                                                <td style="color: #6b7280; max-width: 250px; overflow: hidden; text-overflow: ellipsis;">
                                                    {!! Str::limit($model->description, 50) !!}
                                                </td>
                                                <td class="text-center">
                                                    @if ($user->role==3)
                                                    <a href="{{ route('admin.list.class.students.academic', $model->slug) }}"
                                                        class="btn btn-primary shadow-sm" style="border-radius: 8px;">
                                                        <i class="fa fa-eye me-2"></i>
                                                        Ver Estudantes
                                                        <span class="badge bg-white text-primary ms-2">{{ $model->students->count() }}</span>
                                                    </a>
                                                    @else
                                                    <a href="{{ route('admin.list.class.students.teacher', $model->slug) }}"
                                                       class="btn btn-primary shadow-sm" style="border-radius: 8px;">
                                                        <i class="fa fa-eye me-2"></i>
                                                        Ver Estudantes
                                                        <span class="badge bg-white text-primary ms-2">{{ $model->students->count() }}</span>
                                                    </a>
                                                    @endif
                                                </td>
                                                <td style="color: #6b7280; font-size: 0.875rem;">
                                                    <i class="far fa-clock me-1"></i>
                                                    {{ date('d/m/Y', strtotime($model->created_at)) }}
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                    <div class="row float-end">
                                        {{ $models->links() }}
                                    </div>
                                @else
                                    <br>
                                    <br>
                                    <div  class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
