<div class="page-content">
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="row mb-4 mt-3">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="pt-3">
                        <h1 class="h3 mb-1 text-primary">
                            <i class="fas fa-file-download me-2"></i>Lista de Matrizes
                        </h1>
                        <p class="text-muted mb-0">
                            Gerencie e visualize as matrizes disponíveis
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters Card -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h5 class="card-title mb-0 text-primary">
                        <i class="fas fa-filter me-2"></i>Filtros de Pesquisa
                        @php
                            $activeFilters = 0;
                            if($selectedClass) $activeFilters++;
                            if($selectedTurma) $activeFilters++;
                            if($search) $activeFilters++;
                            if($filter) $activeFilters++;
                        @endphp
                        @if($activeFilters > 0)
                            <span class="badge bg-info ms-2">{{ $activeFilters }} ativo{{ $activeFilters > 1 ? 's' : '' }}</span>
                        @endif
                    </h5>
                    <div class="d-flex gap-2">
                        @if(!isset($student))
                        <div class="btn-group" role="group">
                            <button type="button" wire:click="exportPDF" class="btn btn-danger btn-sm">
                                <i class="fa fa-file-pdf me-1"></i>PDF
                            </button>
                            <button type="button" wire:click="exportExcel" class="btn btn-success btn-sm">
                                <i class="fa fa-file-excel me-1"></i>Excel
                            </button>
                        </div>
                        @endif
                        @if($activeFilters > 0)
                        <button wire:click="$set('selectedClass', ''); $set('selectedTurma', ''); $set('search', ''); $set('filter', '')"
                                class="btn btn-sm btn-outline-secondary">
                            <i class="fas fa-times me-1"></i>Limpar Filtros
                        </button>
                        @endif
                    </div>
                </div>

                <div class="row g-3">
                    @if(!isset($student))
                        <!-- Classe (apenas para admin) -->
                        <div class="col-md-3">
                            <label for="selectedClass" class="form-label">Classe</label>
                            <select class="form-select" wire:model="selectedClass">
                                <option value="">Todas as Classes</option>
                                @foreach($classes as $class)
                                    <option value="{{ $class->class }}">{{ $class->class }}ª Classe</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Turma (apenas para admin) -->
                        <div class="col-md-3">
                            <label for="selectedTurma" class="form-label">Turma</label>
                            <select class="form-select" wire:model="selectedTurma" {{ !$selectedClass ? 'disabled' : '' }}>
                                <option value="">Todas as Turmas</option>
                                @foreach($turmas as $turma)
                                    <option value="{{ $turma->id }}">{{ $turma->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    @endif

                    <!-- Pesquisar -->
                    <div class="col-md-{{ isset($student) ? '6' : '3' }}">
                        <label for="search" class="form-label">Pesquisar</label>
                        <div class="input-group">
                            <input type="text" class="form-control"
                                   wire:model.debounce.300ms="search"
                                   placeholder="Digite...">
                            <span class="input-group-text">
                                <i class="fas fa-search"></i>
                            </span>
                        </div>
                    </div>

                    <!-- Filtrar Por Campo -->
                    <div class="col-md-{{ isset($student) ? '6' : '3' }}">
                        <label for="filter" class="form-label">Campo</label>
                        <select class="form-select" wire:model="filter">
                            <option value="">Todos</option>
                            <option value="title">Título</option>
                            <option value="description">Descrição</option>
                            @if(!isset($student))
                                <option value="student">Estudante</option>
                                <option value="type">Tipo</option>
                            @endif
                            <option value="year">Ano</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <!-- Matrizes Card -->
        <div class="card border-0 shadow-sm">
            <div class="card-body p-0">
                <div class="d-flex justify-content-between align-items-center p-4 border-bottom">
                    <h5 class="card-title mb-0 text-primary">
                        <i class="fas fa-table me-2"></i>Matrizes
                        @if(count($models))
                            <span class="badge bg-primary ms-2">{{ $models->total() }}</span>
                        @endif
                    </h5>

                    @if(count($selectedIds) > 0 && !isset($student))
                        <form wire:submit.prevent="bulkDelete" class="d-inline">
                            <button type="submit" class="btn btn-danger btn-sm">
                                <i class="fas fa-trash me-1"></i>Apagar Selecionados ({{ count($selectedIds) }})
                            </button>
                        </form>
                    @endif
                </div>

                <div class="table-responsive" wire:init="loadData">
                    @if(count($models))
                        <form wire:submit.prevent="bulkDelete">
                            <table class="table table-hover align-middle mb-0 matrizes-table">
                                <thead class="bg-light">
                                    <tr>
                                        @if(!isset($student))
                                            <th width="50px" class="ps-4">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" wire:model="selectAll">
                                                </div>
                                            </th>
                                        @endif
                                        <th>#</th>
                                        @if(!isset($student))
                                            <th>Para</th>
                                        @endif
                                        <th>Classe</th>
                                        <th>Estudante</th>
                                        <th>Título</th>
                                        <th>Descrição</th>
                                        <th>Ficheiro</th>
                                        <th>Data de Lançamento</th>
                                        @if(!isset($student))
                                            <th class="text-end pe-4">Ações</th>
                                        @endif
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($models as $model)
                                        @php
                                            $get_class = $model->class_id ? \App\Models\Classroom::find($model->class_id) : null;
                                            $get_student = $model->student_id ? \App\Models\User::find($model->student_id) : null;
                                            $get_download = \App\Models\Downloadcenter::where("slug", $model->download_id)->first();
                                            $get_files = \App\Models\Downloadfile::where("download_id", $model->download_id)->get();
                                            $user = Auth::user();

                                            $title = match($model->type) {
                                                'all' => 'Todos',
                                                'student' => 'Estudante',
                                                'class' => 'Classe',
                                                default => 'Indefinido'
                                            };

                                            $typeBadgeColor = match($model->type) {
                                                'all' => 'primary',
                                                'student' => 'info',
                                                'class' => 'success',
                                                default => 'secondary'
                                            };
                                        @endphp

                                        @if(isset($student) && (empty($model->student_id) || $model->student_id == $user->id))
                                            <tr>
                                                <td><span class="text-muted fw-bold">{{ $loop->iteration }}</span></td>
                                                <td>
                                                    @if($get_class)
                                                        <div class="d-flex align-items-center">
                                                            <i class="fas fa-graduation-cap text-primary me-2"></i>
                                                            <span>{{ $get_class->class }} Classe - {{ $get_class->name }}</span>
                                                        </div>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($get_student)
                                                        <div class="d-flex align-items-center">
                                                            <i class="fas fa-user text-info me-2"></i>
                                                            <span>{{ $get_student->name }}</span>
                                                        </div>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($get_download)
                                                        <strong class="text-dark">{{ $get_download->title }}</strong>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($get_download)
                                                        <span class="text-muted">{{ Str::limit($get_download->description, 50) }}</span>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @forelse($get_files as $file)
                                                        <a href="{{ $file->media_url }}" target="_blank" class="text-decoration-none">
                                                            <i class="fas fa-file-download text-success me-1"></i>
                                                            <span class="text-primary">{{ Str::limit($file->media_name, 30) }}</span>
                                                        </a><br>
                                                    @empty
                                                        <span class="text-muted">Nenhum arquivo</span>
                                                    @endforelse
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <i class="fas fa-calendar text-muted me-2"></i>
                                                        <span class="text-muted">{{ $model->created_at->format('d/m/Y H:i') }}</span>
                                                    </div>
                                                </td>
                                            </tr>
                                        @elseif(!isset($student))
                                            <tr>
                                                <td class="ps-4">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" wire:model="selectedIds" value="{{ $model->id }}">
                                                    </div>
                                                </td>
                                                <td><span class="text-muted fw-bold">{{ $loop->iteration }}</span></td>
                                                <td><span class="badge bg-{{ $typeBadgeColor }}">{{ $title }}</span></td>
                                                <td>
                                                    @if($get_class)
                                                        <div class="d-flex align-items-center">
                                                            <i class="fas fa-graduation-cap text-primary me-2"></i>
                                                            <span>{{ $get_class->class }} Classe - {{ $get_class->name }}</span>
                                                        </div>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($get_student)
                                                        <div class="d-flex align-items-center">
                                                            <i class="fas fa-user text-info me-2"></i>
                                                            <span>{{ $get_student->name }}</span>
                                                        </div>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($get_download)
                                                        <strong class="text-dark">{{ $get_download->title }}</strong>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($get_download)
                                                        <span class="text-muted">{{ Str::limit($get_download->description, 50) }}</span>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @forelse($get_files as $file)
                                                        <a href="{{ $file->media_url }}" target="_blank" class="text-decoration-none">
                                                            <i class="fas fa-file-download text-success me-1"></i>
                                                            <span class="text-primary">{{ Str::limit($file->media_name, 30) }}</span>
                                                        </a><br>
                                                    @empty
                                                        <span class="text-muted">Nenhum arquivo</span>
                                                    @endforelse
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <i class="fas fa-calendar text-muted me-2"></i>
                                                        <span class="text-muted">{{ $model->created_at->format('d/m/Y H:i') }}</span>
                                                    </div>
                                                </td>
                                                <td class="pe-4">
                                                    <div class="d-flex justify-content-end gap-2 action-cell">
                                                        <a href="{{ route('admin.edit.Download', $model->download_id) }}"
                                                           class="btn btn-sm btn-outline-primary"
                                                           title="Editar">
                                                            <i class="fas fa-edit"></i>
                                                        </a>
                                                        <button type="button"
                                                                wire:click="submit('{{ $model->download_id }}')"
                                                                class="btn btn-sm btn-outline-danger"
                                                                title="Apagar">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </form>

                        <div class="d-flex justify-content-center p-4 border-top">
                            {{ $models->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <div wire:loading class="mb-3">
                                <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                                    <span class="visually-hidden">Carregando...</span>
                                </div>
                                <p class="mt-3 mb-0">Processando...</p>
                            </div>
                            <div wire:loading.remove>
                                <i class="fas fa-inbox text-muted" style="font-size: 3rem;"></i>
                                <h5 class="mt-3">Nenhuma matriz encontrada</h5>
                                <p class="text-muted">Ajuste os filtros para encontrar matrizes ou adicione novas</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .matrizes-table {
        font-size: 14px;
    }

    .matrizes-table thead th {
        font-weight: 600;
        text-transform: uppercase;
        font-size: 12px;
        letter-spacing: 0.5px;
        color: #495057;
        border-bottom: 2px solid #dee2e6;
        padding: 1rem;
    }

    .matrizes-table tbody td {
        padding: 1rem;
        vertical-align: middle;
    }

    .matrizes-table tbody tr:hover {
        background-color: #f8f9fa;
    }

    .action-cell .btn {
        transition: all 0.2s ease;
    }

    .action-cell .btn:hover {
        transform: translateY(-2px);
    }

    .badge {
        padding: 0.35rem 0.65rem;
        font-weight: 500;
        font-size: 11px;
    }

    .card {
        transition: box-shadow 0.3s ease;
    }

    .card:hover {
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1) !important;
    }

    .form-check-input {
        cursor: pointer;
    }

    .form-check-input:checked {
        background-color: #0d6efd;
        border-color: #0d6efd;
    }

    .input-group-text {
        background-color: #f8f9fa;
        border-left: none;
    }

    .input-group .form-control {
        border-right: none;
    }

    .input-group .form-control:focus {
        border-color: #ced4da;
        box-shadow: none;
    }

    .input-group .form-control:focus + .input-group-text {
        border-color: #80bdff;
    }

    /* Disabled select styling */
    .form-select:disabled {
        background-color: #e9ecef;
        cursor: not-allowed;
        opacity: 0.6;
    }

    /* Badge info color adjustment */
    .badge.bg-info {
        font-size: 0.75rem;
        padding: 0.25rem 0.5rem;
    }

    @media (max-width: 768px) {
        .matrizes-table {
            font-size: 12px;
        }

        .matrizes-table thead {
            display: none;
        }

        .matrizes-table tbody tr {
            display: block;
            margin-bottom: 1rem;
            border: 1px solid #dee2e6;
            border-radius: 0.25rem;
        }

        .matrizes-table tbody td {
            display: block;
            text-align: right;
            padding: 0.75rem 1rem;
            border-bottom: 1px solid #f0f0f0;
        }

        .matrizes-table tbody td:last-child {
            border-bottom: none;
        }

        .action-cell {
            justify-content: flex-end !important;
        }
    }
</style>
