<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="card border-0 shadow">
                <div class="card-header bg-primary text-white py-3 d-flex justify-content-between align-items-center">
                    <h2 class="h5 mb-0">
                        <i class="fas fa-edit me-2"></i>
                        Editar Comunicado
                    </h2>
                    <a href="{{ route('admin.notice') }}" class="btn btn-sm btn-light">
                        <i class="fas fa-list me-1"></i>Ver Todos os Comunicados
                    </a>
                </div>

                <div class="card-body">
                    <div class="row justify-content-center">
                        <div class="col-12 col-lg-10">
                            <form wire:submit.prevent="submit" class="needs-validation" novalidate>
                                <div class="row g-3">
                                    <!-- Título -->
                                    <div class="col-12">
                                        <label for="title" class="form-label fw-semibold">Título <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-heading"></i></span>
                                            <input type="text"
                                                   id="title"
                                                   wire:model="title"
                                                   class="form-control @error('title') is-invalid @enderror"
                                                   placeholder="Insira o título..."
                                                   required>
                                        </div>
                                        @error('title') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Descrição -->
                                    <div class="col-12">
                                        <label for="description" class="form-label fw-semibold">Descrição</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-align-left"></i></span>
                                            <textarea
                                                id="description"
                                                wire:model="description"
                                                class="form-control @error('description') is-invalid @enderror"
                                                placeholder="Insira a descrição..."
                                                rows="4"></textarea>
                                        </div>
                                        @error('description') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Ficheiro -->
                                    <div class="col-12">
                                        <label for="photo" class="form-label fw-semibold">Ficheiro</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-file-upload"></i></span>
                                            <input type="file"
                                                   id="photo"
                                                   wire:model="photo"
                                                   class="form-control @error('photo') is-invalid @enderror">
                                        </div>
                                        @error('photo') <span class="text-danger small">{{ $message }}</span> @enderror
                                        <div wire:loading wire:target="photo" class="mt-2">
                                            <small class="text-primary">
                                                <span class="spinner-border spinner-border-sm me-1"></span>
                                                Carregando ficheiro...
                                            </small>
                                        </div>
                                    </div>
                                </div>

                                <!-- Botões -->
                                <div class="d-grid gap-2 mt-4">
                                    <button type="submit"
                                            class="btn btn-primary btn-lg"
                                            wire:loading.attr="disabled"
                                            wire:offline.attr="disabled">
                                        <span wire:loading.remove wire:target="submit">
                                            <i class="fas fa-save me-2"></i>Guardar Alterações
                                        </span>
                                        <span wire:loading wire:target="submit">
                                            <span class="spinner-border spinner-border-sm me-2"></span>
                                            Guardando...
                                        </span>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .form-label.fw-semibold {
            font-weight: 600;
            color: #495057;
        }

        .input-group-text {
            background-color: #f8f9fa;
            border-right: none;
        }

        .input-group .form-control,
        .input-group .form-select,
        .input-group textarea {
            border-left: none;
        }

        .input-group .form-control:focus,
        .input-group .form-select:focus,
        .input-group textarea:focus {
            border-color: #ced4da;
            box-shadow: none;
        }

        .input-group:focus-within .input-group-text {
            border-color: #80bdff;
        }
    </style>
</div>
