<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card shadow-sm border-0" style="border-radius: 12px;">
                        <div class="card-body" wire:init="loadData">
                            <!-- Header -->
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <h5 class="card-title mb-0" style="font-weight: 600; color: #2c3e50;">
                                    Lista de Comunicados
                                </h5>
                                @if(!isset($student))
                                <div class="btn-group" role="group">
                                    <button type="button" wire:click="exportPDF" class="btn btn-danger btn-sm">
                                        <i class="fa fa-file-pdf me-1"></i>PDF
                                    </button>
                                    <button type="button" wire:click="exportExcel" class="btn btn-success btn-sm">
                                        <i class="fa fa-file-excel me-1"></i>Excel
                                    </button>
                                </div>
                                @endif
                            </div>

                            <!-- Filters -->
                            <div class="row g-3 mb-4">
                                <div class="col-md-2">
                                    <label for="selectedType" class="form-label">Para</label>
                                    <select class="form-select" wire:model="selectedType" id="selectedType">
                                        <option value="">Todos</option>
                                        <option value="all">Todos Geral</option>
                                        <option value="class">Classe</option>
                                        <option value="student">Estudante</option>
                                    </select>
                                </div>

                                <div class="col-md-2">
                                    <label for="selectedClass" class="form-label">Classe</label>
                                    <select class="form-select" wire:model="selectedClass" id="selectedClass">
                                        <option value="">Todas</option>
                                        @foreach($classes as $class)
                                            <option value="{{ $class->class }}">{{ $class->class }}ª</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-2">
                                    <label for="selectedTurma" class="form-label">Turma</label>
                                    <select class="form-select" wire:model="selectedTurma" id="selectedTurma" {{ !$selectedClass ? 'disabled' : '' }}>
                                        <option value="">Todas</option>
                                        @foreach($turmas as $turma)
                                            <option value="{{ $turma->id }}">{{ $turma->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label for="search" class="form-label">Pesquisar</label>
                                    <input
                                        type="search"
                                        wire:model.debounce.300ms="search"
                                        placeholder="Buscar por descrição..."
                                        class="form-control"
                                        id="search"
                                    />
                                </div>
                            </div>

                            <!-- Table -->
                            <div class="table-responsive" wire:init="loadData">
                                @if(count($models))
                                    <table class="table table-hover align-middle">
                                        <thead class="table-light">
                                            <tr>
                                                <th scope="col" style="width: 50px;">#</th>
                                                <th scope="col">Para</th>
                                                <th scope="col">Classe</th>
                                                <th scope="col">Estudante</th>
                                                <th scope="col">Descrição</th>
                                                <th scope="col">Ficheiro</th>
                                                @if(!isset($student))
                                                <th scope="col">Data</th>
                                                <th scope="col" style="width: 120px;">Acção</th>
                                                @endif
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @php
                                            $count = 1;
                                            $isStudentView = isset($student);
                                        @endphp
                                        @foreach($models as $model)
                                            @php
                                                $get_class = null;
                                                $get_student = null;

                                                if(!empty($model->class_id)){
                                                    $get_class = \App\Models\Classroom::query()->where("id",$model->class_id)->first();
                                                }
                                                if(!empty($model->student_id)){
                                                    $get_student = \App\Models\User::query()->where("id",$model->student_id)->first();
                                                }

                                                // Determinar o tipo
                                                $title = '';
                                                if($model->type == "all"){
                                                    $title = "Todos";
                                                }elseif($model->type == "student"){
                                                    $title = "Estudante";
                                                }elseif($model->type == "class"){
                                                    $title = "Classe";
                                                }

                                                // Verificar permissão para estudantes
                                                $canDisplay = true;
                                                if($isStudentView){
                                                    $user = Auth::user();
                                                    $canDisplay = empty($model->student_id) || $model->student_id == $user->id;
                                                }
                                            @endphp

                                            @if($canDisplay)
                                            <tr style="transition: all 0.2s;">
                                                <th scope="row">{{ $count++ }}</th>
                                                <td>
                                                    @if($model->type == "all")
                                                        <span class="badge bg-primary">{{ $title }}</span>
                                                    @elseif($model->type == "class")
                                                        <span class="badge bg-info">{{ $title }}</span>
                                                    @else
                                                        <span class="badge bg-warning text-dark">{{ $title }}</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if(!empty($model->class_id) && $get_class)
                                                        {{ $get_class->class }}ª Classe {{ $get_class->name }}
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if(!empty($model->student_id) && $get_student)
                                                        {{ $get_student->name }}
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <strong>{!! Str::limit($model->title, 50) !!}</strong>
                                                </td>
                                                <td>
                                                    @if($model->media_url)
                                                        <a href="{{ $model->media_url }}" class="text-primary text-decoration-none" target="_blank">
                                                            <i class="fa fa-file-download me-1"></i>
                                                            {{ Str::limit($model->media_name, 30) }}
                                                        </a>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                @if(!$isStudentView)
                                                <td>
                                                    <small class="text-muted">{{ \Carbon\Carbon::parse($model->created_at)->format('d/m/Y H:i') }}</small>
                                                </td>
                                                <td>
                                                    <div class="btn-group btn-group-sm" role="group">
                                                        <a href="{{ route('admin.edit.notice', $model->slug) }}"
                                                            class="btn btn-outline-primary btn-sm">
                                                            <span class="fa fa-edit"></span>
                                                        </a>
                                                        <button type="button" wire:click="submit('{{ $model->slug }}')"
                                                            class="btn btn-outline-danger btn-sm">
                                                            <span class="fa fa-trash"></span>
                                                        </button>
                                                    </div>
                                                </td>
                                                @endif
                                            </tr>
                                            @endif
                                        @endforeach
                                        </tbody>
                                    </table>

                                    <div class="d-flex justify-content-center mt-3">
                                        {{ $models->links() }}
                                    </div>
                                @else
                                    <div class="text-center py-5">
                                        <div wire:loading class="spinner-border text-primary mb-3" role="status">
                                            <span class="visually-hidden">Processando...</span>
                                        </div>
                                        <p class="text-muted"><strong>Nenhum comunicado foi encontrado.</strong></p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .table-hover tbody tr:hover {
            background-color: #f8f9fa;
            transform: translateY(-2px);
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        .form-select:focus, .form-control:focus {
            border-color: #4e73df;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        }

        .badge {
            font-weight: 500;
            padding: 0.35em 0.65em;
        }
    </style>
</div>
