<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col-12">
                    <!-- Header -->
                    <div class="card border-0 shadow-sm mb-4">
                        <div class="card-header bg-primary text-white py-3">
                            <h2 class="h5 mb-0">
                                <i class="fas fa-file-invoice-dollar me-2"></i>Relatórios de Pagamentos
                            </h2>
                        </div>
                    </div>

                    <!-- Filters Card -->
                    <div class="card border-0 shadow-sm mb-4">
                        <div class="card-header bg-white border-bottom py-3">
                            <h5 class="mb-0"><i class="fas fa-filter me-2 text-primary"></i>Filtros Avançados</h5>
                        </div>
                        <div class="card-body p-4">
                            <form wire:submit.prevent="generateReport">
                                <!-- Filter Type Selection -->
                                <div class="row mb-4">
                                    <div class="col-12">
                                        <label class="form-label fw-semibold">Tipo de Relatório <span class="text-danger">*</span></label>
                                        <div class="btn-group w-100" role="group">
                                            <input type="radio" class="btn-check" wire:model="filter_type" value="all" id="filter_all">
                                            <label class="btn btn-outline-primary" for="filter_all">
                                                <i class="fas fa-globe me-1"></i>Todos
                                            </label>

                                            <input type="radio" class="btn-check" wire:model="filter_type" value="class" id="filter_class">
                                            <label class="btn btn-outline-primary" for="filter_class">
                                                <i class="fas fa-school me-1"></i>Por Turma
                                            </label>

                                            <input type="radio" class="btn-check" wire:model="filter_type" value="student" id="filter_student">
                                            <label class="btn btn-outline-primary" for="filter_student">
                                                <i class="fas fa-user-graduate me-1"></i>Por Estudante
                                            </label>

                                            <input type="radio" class="btn-check" wire:model="filter_type" value="reference" id="filter_reference">
                                            <label class="btn btn-outline-primary" for="filter_reference">
                                                <i class="fas fa-barcode me-1"></i>Por Referência
                                            </label>

                                            <input type="radio" class="btn-check" wire:model="filter_type" value="receipt" id="filter_receipt">
                                            <label class="btn btn-outline-primary" for="filter_receipt">
                                                <i class="fas fa-file-invoice me-1"></i>Por Recibo
                                            </label>

                                            <input type="radio" class="btn-check" wire:model="filter_type" value="transaction" id="filter_transaction">
                                            <label class="btn btn-outline-primary" for="filter_transaction">
                                                <i class="fas fa-receipt me-1"></i>Por Transaction ID
                                            </label>

                                            <input type="radio" class="btn-check" wire:model="filter_type" value="date" id="filter_date">
                                            <label class="btn btn-outline-primary" for="filter_date">
                                                <i class="fas fa-calendar me-1"></i>Por Data
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="row g-3">
                                    <!-- Class Filter -->
                                    @if($filter_type === 'class')
                                        <div class="col-md-6">
                                            <label for="class_id" class="form-label fw-semibold">Turma <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-school"></i></span>
                                                <select wire:model="class_id" id="class_id" class="form-select @error('class_id') is-invalid @enderror" required>
                                                    <option value="">Selecione a Turma</option>
                                                    @foreach($classrooms as $classroom)
                                                        <option value="{{ $classroom->id }}">{{ $classroom->class }} - {{ $classroom->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            @error('class_id')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    @endif

                                    <!-- Student Filter (Hierárquico: Classe → Turma → Estudante) -->
                                    @if($filter_type === 'student')
                                        <!-- Selecionar Classe -->
                                        <div class="col-md-4">
                                            <label for="student_class_name" class="form-label fw-semibold">Classe <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-layer-group"></i></span>
                                                <select wire:model="student_class_name" id="student_class_name" class="form-select" required>
                                                    <option value="">Selecione a Classe</option>
                                                    @foreach($available_classes as $class)
                                                        <option value="{{ $class }}">{{ $class }}ª Classe</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <!-- Selecionar Turma -->
                                        <div class="col-md-4">
                                            <label for="student_classroom_id" class="form-label fw-semibold">Turma <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-school"></i></span>
                                                <select wire:model="student_classroom_id" id="student_classroom_id" class="form-select" required
                                                    @if(!$student_class_name) disabled @endif>
                                                    <option value="">{{ $student_class_name ? 'Selecione a Turma' : 'Primeiro selecione a classe' }}</option>
                                                    @foreach($classrooms_by_class as $classroom)
                                                        <option value="{{ $classroom->id }}">{{ $classroom->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <!-- Selecionar Estudante -->
                                        <div class="col-md-4">
                                            <label for="student_id" class="form-label fw-semibold">Estudante <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-user-graduate"></i></span>
                                                <select wire:model="student_id" id="student_id" class="form-select @error('student_id') is-invalid @enderror" required
                                                    @if(!$student_classroom_id) disabled @endif>
                                                    <option value="">{{ $student_classroom_id ? 'Selecione o Estudante' : 'Primeiro selecione a turma' }}</option>
                                                    @foreach($students_by_classroom as $student)
                                                        <option value="{{ $student->id }}">{{ $student->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            @error('student_id')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    @endif

                                    <!-- Reference Filter -->
                                    @if($filter_type === 'reference')
                                        <div class="col-md-6">
                                            <label for="reference_number" class="form-label fw-semibold">Número de Referência <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-barcode"></i></span>
                                                <input type="text"
                                                       wire:model="reference_number"
                                                       id="reference_number"
                                                       class="form-control @error('reference_number') is-invalid @enderror"
                                                       placeholder="Digite a referência (11 dígitos)"
                                                       maxlength="11"
                                                       required>
                                            </div>
                                            @error('reference_number')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    @endif

                                    <!-- Receipt Number Filter -->
                                    @if($filter_type === 'receipt')
                                        <div class="col-md-6">
                                            <label for="receipt_number" class="form-label fw-semibold">Número de Recibo <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-file-invoice"></i></span>
                                                <input type="text"
                                                       wire:model="receipt_number"
                                                       id="receipt_number"
                                                       class="form-control @error('receipt_number') is-invalid @enderror"
                                                       placeholder="Digite o número do recibo"
                                                       required>
                                            </div>
                                            @error('receipt_number')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    @endif

                                    <!-- Transaction ID Filter -->
                                    @if($filter_type === 'transaction')
                                        <div class="col-md-6">
                                            <label for="transaction_id" class="form-label fw-semibold">POS Transaction ID <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-receipt"></i></span>
                                                <input type="text"
                                                       wire:model="transaction_id"
                                                       id="transaction_id"
                                                       class="form-control @error('transaction_id') is-invalid @enderror"
                                                       placeholder="Digite o Transaction ID"
                                                       required>
                                            </div>
                                            @error('transaction_id')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    @endif

                                    <!-- Date Range -->
                                    <div class="col-md-3">
                                        <label for="date_from" class="form-label fw-semibold">Data Inicial <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-calendar-alt"></i></span>
                                            <input type="date"
                                                   wire:model="date_from"
                                                   id="date_from"
                                                   class="form-control @error('date_from') is-invalid @enderror"
                                                   required>
                                        </div>
                                        @error('date_from')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <div class="col-md-3">
                                        <label for="date_to" class="form-label fw-semibold">Data Final <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-calendar-check"></i></span>
                                            <input type="date"
                                                   wire:model="date_to"
                                                   id="date_to"
                                                   class="form-control @error('date_to') is-invalid @enderror"
                                                   required>
                                        </div>
                                        @error('date_to')
                                            <div class="invalid-feedback d-block">{{ $message }}</div>
                                        @enderror
                                    </div>

                                    <!-- Payment Status -->
                                    <div class="col-md-3">
                                        <label for="payment_status" class="form-label fw-semibold">Status de Pagamento</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-check-circle"></i></span>
                                            <select wire:model="payment_status" id="payment_status" class="form-select">
                                                <option value="">Todos</option>
                                                <option value="paid">Pagos</option>
                                                <option value="pending">Pendentes</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <!-- Action Buttons -->
                                <div class="d-flex gap-2 justify-content-end border-top pt-4 mt-4">
                                    <button type="button" wire:click="resetFilters" class="btn btn-outline-secondary">
                                        <i class="fas fa-redo me-2"></i>Limpar Filtros
                                    </button>
                                    <button type="submit" class="btn btn-primary px-4" wire:loading.attr="disabled">
                                        <span wire:loading.remove wire:target="generateReport">
                                            <i class="fas fa-search me-2"></i>Gerar Relatório
                                        </span>
                                        <span wire:loading wire:target="generateReport">
                                            <span class="spinner-border spinner-border-sm me-2"></span>Gerando...
                                        </span>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Results Section -->
                    @if($showResults)
                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-white border-bottom py-3 d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="mb-1"><i class="fas fa-list-alt me-2 text-success"></i>Resultados do Relatório</h5>
                                    <p class="text-muted mb-0 small">
                                        <strong>{{ number_format($totalCount) }}</strong> registro(s) encontrado(s)
                                    </p>
                                </div>
                                <div class="d-flex gap-2">
                                    <a href="{{ route('admin.fee.reports.export.pdf', request()->query()) }}" class="btn btn-danger btn-sm" target="_blank">
                                        <i class="fas fa-file-pdf me-1"></i>Exportar PDF
                                    </a>
                                    <a href="{{ route('admin.fee.reports.export.excel', request()->query()) }}" class="btn btn-success btn-sm">
                                        <i class="fas fa-file-excel me-1"></i>Exportar Excel
                                    </a>
                                </div>
                            </div>
                            <div class="card-body p-0">
                                @if($results->count() > 0)
                                    <div class="table-responsive">
                                        <table class="table table-hover table-striped align-middle mb-0">
                                            <thead class="table-light">
                                                <tr>
                                                    <th style="width: 5%">#</th>
                                                    <th>Estudante</th>
                                                    <th>Turma</th>
                                                    <th>Referência</th>
                                                    <th>Mês/Ano</th>
                                                    <th>Valor</th>
                                                    <th>Multa</th>
                                                    <th>Total</th>
                                                    <th>Modo</th>
                                                    <th>Data</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($results as $index => $payment)
                                                    <tr>
                                                        <td class="text-muted">{{ $results->firstItem() + $index }}</td>
                                                        <td>
                                                            <div class="d-flex align-items-center">
                                                                <i class="fas fa-user-circle text-primary me-2"></i>
                                                                <strong>{{ $payment->student->name ?? 'N/A' }}</strong>
                                                            </div>
                                                        </td>
                                                        <td>{{ $payment->student->classroom->class ?? 'N/A' }} - {{ $payment->student->classroom->name ?? '' }}</td>
                                                        <td>
                                                            <span class="badge bg-secondary">{{ $payment->paymentReference->reference_number ?? ($payment->reference_number ?? 'N/A') }}</span>
                                                        </td>
                                                        <td>{{ $payment->month }}/{{ $payment->year }}</td>
                                                        <td>MT {{ number_format($payment->amount ?? 0, 2, ',', '.') }}</td>
                                                        <td>
                                                            @if($payment->fine > 0)
                                                                <span class="text-danger">MT {{ number_format($payment->fine, 2, ',', '.') }}</span>
                                                            @else
                                                                <span class="text-muted">-</span>
                                                            @endif
                                                        </td>
                                                        <td><strong>MT {{ number_format(($payment->amount ?? 0) + ($payment->fine ?? 0) - ($payment->discount ?? 0), 2, ',', '.') }}</strong></td>
                                                        <td>
                                                            <span class="badge {{ $payment->payment_mode === 'Manual' ? 'bg-info' : 'bg-primary' }}">
                                                                {{ $payment->payment_mode ?? 'N/A' }}
                                                            </span>
                                                        </td>
                                                        <td class="text-muted small">{{ \Carbon\Carbon::parse($payment->created_at)->format('d/m/Y H:i') }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                            <tfoot class="table-light">
                                                <tr class="border-top border-2">
                                                    <td colspan="5" class="text-end align-middle py-1" rowspan="3" style="font-size: 0.85rem;">
                                                        <strong>TOTAIS</strong>
                                                    </td>
                                                    <td class="text-end py-1" style="font-size: 0.85rem; white-space: nowrap;">Subtotal:</td>
                                                    <td class="py-1" style="font-size: 0.85rem; white-space: nowrap;"><strong class="text-primary">MT&nbsp;{{ number_format($subtotal, 2, ',', '.') }}</strong></td>
                                                    <td colspan="3" class="text-muted py-1" style="font-size: 0.7rem;">(Pagamentos sem multa)</td>
                                                </tr>
                                                <tr>
                                                    <td class="text-end py-1" style="font-size: 0.85rem; white-space: nowrap;">Multas:</td>
                                                    <td class="py-1" style="font-size: 0.85rem; white-space: nowrap;"><strong class="text-warning">MT&nbsp;{{ number_format($totalFine, 2, ',', '.') }}</strong></td>
                                                    <td colspan="3" class="text-muted py-1" style="font-size: 0.7rem;">(Valor das multas)</td>
                                                </tr>
                                                <tr class="table-success">
                                                    <td class="text-end py-1" style="font-size: 0.85rem; white-space: nowrap;"><strong>Total:</strong></td>
                                                    <td class="py-1" style="font-size: 0.9rem; white-space: nowrap;"><strong class="text-success">MT&nbsp;{{ number_format($totalAmount, 2, ',', '.') }}</strong></td>
                                                    <td colspan="3" class="text-muted py-1" style="font-size: 0.7rem;">(Subtotal + Multa)</td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>

                                    <!-- Pagination -->
                                    <div class="p-3 border-top">
                                        {{ $results->links() }}
                                    </div>
                                @else
                                    <div class="text-center py-5">
                                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                        <p class="text-muted"><strong>Nenhum pagamento encontrado com os filtros selecionados.</strong></p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
