<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="card border-0 shadow">
                <div class="card-header bg-primary text-white py-3 d-flex justify-content-between align-items-center">
                    <h2 class="h5 mb-0">
                        <i class="fas fa-sms me-2"></i>
                        Enviar SMS
                    </h2>
                    <a href="{{ route('admin.sms') }}" class="btn btn-sm btn-light">
                        <i class="fas fa-list me-1"></i>Ver Todos os SMS
                    </a>
                </div>

                <div class="card-body">
                    <div class="row justify-content-center">
                        <div class="col-12 col-lg-10">
                            <form wire:submit.prevent="submit" class="needs-validation" novalidate>
                                <div class="row g-3">
                                    <!-- Enviar Para -->
                                    <div class="col-md-6">
                                        <label for="type" class="form-label fw-semibold">Enviar Para <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-users"></i></span>
                                            <select id="type"
                                                    wire:model="type"
                                                    class="form-select"
                                                    required>
                                                <option value="all">Todos</option>
                                                <option value="class">Classe Ou Turma</option>
                                                <option value="student">Estudante</option>
                                            </select>
                                        </div>
                                    </div>

                                    <!-- Tipo de Estudante -->
                                    <div class="col-md-6">
                                        <label class="form-label fw-semibold">Enviar Para Estudantes <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-user-check"></i></span>
                                            <div class="form-control d-flex align-items-center gap-3">
                                                <div class="form-check">
                                                    <input type="radio"
                                                           class="form-check-input @error('student_type') is-invalid @enderror"
                                                           id="student_type_regular"
                                                           name="student_type"
                                                           value="1"
                                                           wire:model="student_type"
                                                           checked
                                                           required>
                                                    <label class="form-check-label" for="student_type_regular">
                                                        Regulares
                                                    </label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="radio"
                                                           class="form-check-input @error('student_type') is-invalid @enderror"
                                                           id="student_type_irregular"
                                                           name="student_type"
                                                           value="0"
                                                           wire:model="student_type"
                                                           required>
                                                    <label class="form-check-label" for="student_type_irregular">
                                                        Irregulares
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        @error('student_type') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Turma (condicional) -->
                                    @if($type == "class" || $type == "student")
                                    <div class="col-md-6">
                                        <label for="class_id" class="form-label fw-semibold">Turma <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-door-open"></i></span>
                                            <select id="class_id"
                                                    wire:model="class_id"
                                                    class="form-select @error('class_id') is-invalid @enderror"
                                                    required>
                                                <option value="">Selecione a turma...</option>
                                                @foreach($Classroom as $class)
                                                    <option value="{{ $class->id }}">{{ $class->class }}ª - {{ $class->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @error('class_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>
                                    @endif

                                    <!-- Estudante (condicional) -->
                                    @if($type == "student")
                                    <div class="col-md-6">
                                        <label for="student_id" class="form-label fw-semibold">Estudante <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-user-graduate"></i></span>
                                            <select id="student_id"
                                                    wire:model="student_id"
                                                    class="form-select @error('student_id') is-invalid @enderror"
                                                    required>
                                                <option value="">Selecione o estudante...</option>
                                                @foreach($students as $student)
                                                    <option value="{{ $student->id }}">{{ $student->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @error('student_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>
                                    @endif

                                    <!-- Mensagem -->
                                    <div class="col-12">
                                        <label for="message" class="form-label fw-semibold">Mensagem <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light align-items-start pt-2"><i class="fas fa-comment-dots"></i></span>
                                            <textarea id="message"
                                                      wire:model="title"
                                                      class="form-control @error('title') is-invalid @enderror"
                                                      rows="5"
                                                      placeholder="Escreva a mensagem aqui..."
                                                      required></textarea>
                                        </div>
                                        @error('title') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>
                                </div>

                                <!-- Botões -->
                                <div class="d-grid gap-2 mt-4">
                                    <button type="submit"
                                            class="btn btn-primary btn-lg"
                                            wire:loading.attr="disabled"
                                            wire:offline.attr="disabled">
                                        <span wire:loading.remove wire:target="submit">
                                            <i class="fas fa-paper-plane me-2"></i>Enviar SMS
                                        </span>
                                        <span wire:loading wire:target="submit">
                                            <span class="spinner-border spinner-border-sm me-2"></span>
                                            Enviando...
                                        </span>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .form-label.fw-semibold {
            font-weight: 600;
            color: #495057;
        }

        .input-group-text {
            background-color: #f8f9fa;
            border-right: none;
        }

        .input-group .form-control,
        .input-group .form-select {
            border-left: none;
        }

        .input-group .form-control:focus,
        .input-group .form-select:focus {
            border-color: #ced4da;
            box-shadow: none;
        }

        .input-group:focus-within .input-group-text {
            border-color: #80bdff;
        }

        .form-check-input:checked {
            background-color: #0d6efd;
            border-color: #0d6efd;
        }
    </style>
</div>
