<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="card border-0 shadow">
                <div class="card-header bg-primary text-white py-3">
                    <h2 class="h5 mb-0">
                        <i class="fas fa-chalkboard-teacher me-2"></i>
                        Atribuir Disciplinas aos Professores
                    </h2>
                </div>

                <div class="card-body">
                    <div class="row justify-content-center">
                        <div class="col-12 col-md-10 col-lg-8 col-xl-7">
                            <form wire:submit.prevent="submit" class="needs-validation" novalidate>
                                <!-- Professor -->
                                <div class="form-group mb-3">
                                    <label for="teacher_id" class="form-label fw-semibold">Professor <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light"><i class="fas fa-user-tie"></i></span>
                                        <select id="teacher_id"
                                                wire:model="teacher_id"
                                                class="form-select @error('teacher_id') is-invalid @enderror"
                                                required>
                                            <option value="">Selecione o professor...</option>
                                            @foreach($teachers as $teacher)
                                                <option value="{{ $teacher->id }}">{{ $teacher->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @error('teacher_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>

                                <!-- Classe -->
                                <div class="form-group mb-3">
                                    <label for="class" class="form-label fw-semibold">Classe <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light"><i class="fas fa-layer-group"></i></span>
                                        <select id="class"
                                                wire:model="class"
                                                class="form-select @error('class') is-invalid @enderror"
                                                required>
                                            <option value="">Selecione a classe...</option>
                                            @for($i = 1; $i <= 12; $i++)
                                                <option value="{{ $i }}">{{ $i }}ª Classe</option>
                                            @endfor
                                        </select>
                                    </div>
                                    @error('class') <span class="text-danger small">{{ $message }}</span> @enderror
                                </div>

                                <!-- Turmas -->
                                <div class="form-group mb-3">
                                    <label for="classroom_id" class="form-label fw-semibold">Turmas <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light"><i class="fas fa-door-open"></i></span>
                                        <select id="classroom_id"
                                                wire:model="classroom_id"
                                                class="form-select @error('classroom_id') is-invalid @enderror"
                                                multiple
                                                size="4"
                                                required
                                                {{ !$class ? 'disabled' : '' }}>
                                            @if(count($classrooms) > 0)
                                                @foreach($classrooms as $classroom)
                                                    <option value="{{ $classroom->id }}">{{ $classroom->name }}</option>
                                                @endforeach
                                            @else
                                                <option disabled>Selecione uma classe primeiro...</option>
                                            @endif
                                        </select>
                                    </div>
                                    <small class="text-muted">Segure Ctrl (ou Cmd) para selecionar múltiplas turmas</small>
                                    @error('classroom_id') <span class="text-danger small d-block">{{ $message }}</span> @enderror
                                </div>

                                <!-- Disciplinas -->
                                <div class="form-group mb-4">
                                    <label for="selectedSubjects" class="form-label fw-semibold">Disciplinas <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <span class="input-group-text bg-light"><i class="fas fa-book"></i></span>
                                        <select id="selectedSubjects"
                                                wire:model="selectedSubjects"
                                                class="form-select @error('selectedSubjects') is-invalid @enderror"
                                                multiple
                                                size="5"
                                                required>
                                            @foreach($subjects as $subject)
                                                <option value="{{ $subject->id }}">{{ $subject->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <small class="text-muted">Segure Ctrl (ou Cmd) para selecionar múltiplas disciplinas</small>
                                    @error('selectedSubjects') <span class="text-danger small d-block">{{ $message }}</span> @enderror
                                </div>

                                <!-- Botões -->
                                <div class="d-grid gap-2">
                                    <button type="submit"
                                            class="btn btn-primary btn-lg"
                                            wire:loading.attr="disabled"
                                            wire:offline.attr="disabled">
                                        <span wire:loading.remove wire:target="submit">
                                            <i class="fas fa-save me-2"></i>Guardar
                                        </span>
                                        <span wire:loading wire:target="submit">
                                            <span class="spinner-border spinner-border-sm me-2"></span>
                                            Processando...
                                        </span>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .form-label.fw-semibold {
            font-weight: 600;
            color: #495057;
        }

        .input-group-text {
            background-color: #f8f9fa;
            border-right: none;
        }

        .input-group .form-control,
        .input-group .form-select {
            border-left: none;
        }

        .input-group .form-control:focus,
        .input-group .form-select:focus {
            border-color: #ced4da;
            box-shadow: none;
        }

        .input-group:focus-within .input-group-text {
            border-color: #80bdff;
        }

        /* Multi-select styling */
        select[multiple] {
            padding: 0.5rem;
        }

        select[multiple] option {
            padding: 0.5rem;
            border-radius: 4px;
            margin-bottom: 2px;
        }

        select[multiple] option:hover {
            background-color: #0d6efd;
            color: white;
        }

        select[multiple]:disabled {
            background-color: #e9ecef;
            cursor: not-allowed;
            opacity: 0.6;
        }
    </style>
</div>
