<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card mt-4">
                        <div class="card-body">
                            <h5 class="card-title">Disciplinas Atribuídas aos Professores</h5>

                            <div class="row mb-3">
                                <div class="col-md-4 mb-2 mb-md-0">
                                    <input type="text" class="form-control" placeholder="Pesquisar professor..." wire:model.debounce.500ms="searchProfessor">
                                </div>
                                <div class="col-md-4 mb-2 mb-md-0">
                                    <input type="text" class="form-control" placeholder="Pesquisar disciplina..." wire:model.debounce.500ms="searchSubject">
                                </div>
                                <div class="col-md-4">
                                    <select class="form-control" wire:model="searchClass">
                                        <option value="">Todas as classes</option>
                                        @for ($i = 1; $i <= 12; $i++)
                                            <option value="{{ $i }}">{{ $i }}ª Classe</option>
                                        @endfor
                                    </select>
                                </div>
                            </div>

                            @if (session()->has('success'))
                                <div class="alert alert-success">{{ session('success') }}</div>
                            @endif
                            @if (session()->has('error'))
                                <div class="alert alert-danger">{{ session('error') }}</div>
                            @endif

                            <div class="table-responsive">
                                <table class="table table-bordered table-hover align-middle">
                                    <thead>
                                        <tr>
                                            <th>Professor</th>
                                            <th>Classe</th>
                                            <th>Turma</th>
                                            <th>Disciplina</th>
                                            <th style="width: 120px;">Ações</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($assignedSubjects as $assignment)
                                            <tr>
                                                <td>{{ data_get($assignment, 'teacher.name', '-') }}</td>
                                                <td>
                                                    {{ data_get($assignment, 'class')
                                                        ? data_get($assignment, 'class') . 'ª Classe'
                                                        : 'Classe indefinida' }}
                                                </td>
                                                <td>{{ data_get($assignment, 'classroom.name', '-') }}</td>
                                                <td>{{ data_get($assignment, 'subject.name', '-') }}</td>
                                                <td>
                                                    <button
                                                        wire:click="removeAssignment(
                                                            {{ $assignment->teacher_id }},
                                                            {{ $assignment->classroom_id }},
                                                            {{ $assignment->subject_id }},
                                                            '{{ data_get($assignment, 'class') }}'
                                                        )"
                                                        class="btn btn-danger btn-sm"
                                                        onclick="return confirm('Tem certeza que deseja remover esta atribuição?');"
                                                    >
                                                        Remover
                                                    </button>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="5" class="text-center">Nenhuma disciplina atribuída encontrada.</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                                <div class="d-flex justify-content-center mt-3">
                                    {{ $assignedSubjects->links() }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

