<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Comprovativo de Pagamento</title>
    <style>
        @page { size: A4; margin: 25.4mm; }

        * { box-sizing: border-box; margin: 0; padding: 0; }

        body {
            font-family: Arial, DejaVu Sans, sans-serif;
            color: #333;
            font-size: 11px;
            line-height: 1.35;
        }

        .page-wrap {
            max-width: 600px;
            margin: 0 auto;
        }

        table {
            width: auto !important;
            max-width: 100%;
            margin: 0 auto;
            border-collapse: collapse;
        }

        .header {
            text-align: center;
            margin-bottom: 15px;
            border-bottom: 2px solid #28a745;
            padding-bottom: 10px;
        }
        .header h1 {
            color: #28a745;
            font-size: 22px;
            margin-bottom: 4px;
        }
        .header p { font-size: 11px; }

        .status-badge {
            background: #28a745;
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            display: inline-block;
            margin: 10px 0;
            font-weight: bold;
            font-size: 12px;
        }

        .info-section {
            margin: 10px 0;
            padding: 10px;
            background-color: #f8f9fa;
            border-radius: 4px;
        }
        .info-section h3 {
            font-size: 13px;
            margin-bottom: 6px;
            color: #0066cc;
        }
        .info-section p { margin: 2px 0; }

        .detail-row {
            display: flex;
            justify-content: space-between;
            gap: 8px;
            padding: 4px 0;
            border-bottom: 1px solid #eee;
        }
        .detail-row:last-child {
            border-bottom: none;
        }

        .payment-summary {
            background: #e8f5e9;
            border: 2px solid #28a745;
            padding: 12px;
            border-radius: 4px;
            margin: 12px 0;
        }
        .payment-summary h3 {
            font-size: 14px;
            color: #28a745;
            margin-bottom: 8px;
        }
        .payment-summary .total {
            font-size: 18px;
            font-weight: bold;
            color: #28a745;
            text-align: center;
            margin-top: 8px;
            padding-top: 8px;
            border-top: 2px solid #28a745;
        }

        .transaction-box {
            background: #0066cc;
            color: white;
            padding: 12px;
            text-align: center;
            border-radius: 4px;
            margin: 12px 0;
        }
        .transaction-box h3 {
            font-size: 13px;
            margin-bottom: 4px;
        }
        .transaction-box .transaction-id {
            font-size: 16px;
            font-weight: bold;
            letter-spacing: 0.5px;
            margin: 4px 0;
            font-family: monospace;
        }

        .payment-info-box {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            padding: 10px;
            border-radius: 4px;
            margin: 10px 0;
        }
        .payment-info-box h4 {
            font-size: 12px;
            margin-bottom: 6px;
            color: #856404;
        }

        .footer {
            text-align: center;
            margin-top: 20px;
            padding-top: 15px;
            border-top: 1px solid #ddd;
            font-size: 10px;
            color: #666;
        }

        .signature-section {
            margin-top: 30px;
            padding: 10px;
        }
        .signature-line {
            border-top: 1px solid #333;
            width: 200px;
            margin: 30px auto 5px;
            text-align: center;
        }

        .no-break { page-break-inside: avoid; }

        .watermark {
            text-align: center;
            color: #28a745;
            font-size: 14px;
            font-weight: bold;
            margin: 10px 0;
        }
    </style>
</head>
<body>
    <div class="page-wrap">
        <div class="header no-break">
            <h1>✓ COMPROVATIVO DE PAGAMENTO</h1>
            <p>COLÉGIO POLITÉCNICO DE MOÇAMBIQUE</p>
            <div class="status-badge">PAGO</div>
        </div>

        <div class="info-section no-break">
            <h3>Dados do Estudante</h3>
            <p><strong>Nome:</strong> {{ $student->name ?? 'N/A' }}</p>
            <p><strong>Número do Estudante:</strong> {{ $student->student_id ?? $student->id }}</p>
            @if(isset($student->class))
            <p><strong>Classe:</strong> {{ $student->class->class ?? 'N/A' }}</p>
            @endif
            @if(isset($student->classroom))
            <p><strong>Turma:</strong> {{ $student->classroom->name ?? 'N/A' }}</p>
            @endif
        </div>

        <div class="payment-summary no-break">
            <h3>Resumo do Pagamento</h3>
            <div class="detail-row">
                <span>Período:</span>
                <span><strong>{{ $payment->fee_month }}/{{ $payment->fee_year }}</strong></span>
            </div>
            @if(isset($base_amount) && $base_amount > 0)
            <div class="detail-row">
                <span>Valor Base:</span>
                <span>{{ number_format($base_amount, 2, ',', '.') }} MT</span>
            </div>
            @endif
            @if(isset($fine_amount) && $fine_amount > 0)
            <div class="detail-row">
                <span>Multa:</span>
                <span>{{ number_format($fine_amount, 2, ',', '.') }} MT</span>
            </div>
            @endif
            @if(isset($discount_amount) && $discount_amount > 0)
            <div class="detail-row">
                <span>Desconto:</span>
                <span>- {{ number_format($discount_amount, 2, ',', '.') }} MT</span>
            </div>
            @endif
            <div class="total">
                TOTAL PAGO: {{ number_format($amount_paid, 2, ',', '.') }} MT
            </div>
        </div>

        <div class="info-section no-break">
            <h3>Detalhes da Transação</h3>
            <div class="detail-row">
                <span>Entidade:</span>
                <span><strong>{{ $payment->entity_code ?? 'N/A' }}</strong></span>
            </div>
            <div class="detail-row">
                <span>Referência:</span>
                <span><strong>{{ $reference_formatted ?? $payment->reference_number }}</strong></span>
            </div>
            <div class="detail-row">
                <span>Data do Pagamento:</span>
                <span><strong>{{ $paid_at->format('d/m/Y H:i:s') }}</strong></span>
            </div>
            @if(isset($payment_method))
            <div class="detail-row">
                <span>Método de Pagamento:</span>
                <span>{{ $payment_method }}</span>
            </div>
            @endif
        </div>

        @if(isset($transaction_id) && !empty($transaction_id))
        <div class="transaction-box no-break">
            <h3>ID da Transação</h3>
            <div class="transaction-id">{{ $transaction_id }}</div>
        </div>
        @endif

        <div class="payment-info-box no-break">
            <h4>Informação Importante:</h4>
            <ul style="margin-left: 16px;">
                <li>Este documento é o comprovativo oficial do seu pagamento</li>
                <li>Guarde este documento para seus registos</li>
                <li>Em caso de dúvidas, contacte o departamento financeiro</li>
                <li>Este comprovativo foi gerado automaticamente pelo sistema</li>
            </ul>
        </div>

        @if(isset($notes) && !empty($notes))
        <div class="info-section no-break">
            <h3>Observações</h3>
            <p>{{ $notes }}</p>
        </div>
        @endif

        <div class="watermark">
            ✓ PAGAMENTO CONFIRMADO
        </div>

        <div class="footer no-break">
            <p><strong>Documento gerado em:</strong> {{ now()->format('d/m/Y H:i:s') }}</p>
            <p>COLÉGIO POLITÉCNICO DE MOÇAMBIQUE - Sistema Integrado de Gestão Académica</p>
            <p style="margin-top: 5px;">Este é um documento gerado eletronicamente e é válido sem assinatura</p>
        </div>
    </div>
</body>
</html>
