<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
    <META NAME="ROBOTS" CONTENT="INDEX, FOLLOW">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', '')); ?></title>

    <link rel="icon" type="image/png" href="<?php echo e(asset('assets/images/logo.png')); ?>">
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/logo.png')); ?>" type="image/x-icon">

    <meta name="author" content="">
    <meta property="og:type" content="website" />
    <meta property="og:title" content="<?php echo e(config('app.name')); ?>" />
    <meta property="og:image" content="<?php echo e(asset('assets/images/logo.png')); ?>" />
    <meta property="og:description" content="" />

    <!-- Styles -->
    <link href="https://fonts.googleapis.com/css?family=Poppins:400,500,700,800&display=swap" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/font-awesome/css/all.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/perfectscroll/perfect-scrollbar.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/apexcharts/apexcharts.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/DataTables/datatables.min.css')); ?>" rel="stylesheet">

    <!-- Theme Styles -->
    <link href="<?php echo e(asset('assets/css/main.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/custom.css')); ?>" rel="stylesheet">

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    <?php echo \Livewire\Livewire::styles(); ?>


</head>

<body class="login-page">
    <div class='loader' wire:loading>
        <div class='spinner-grow text-primary' role='status'>
            <span class='sr-only'>Processando...</span>
        </div>
    </div>

    <?php echo e($slot); ?>


    <!-- Javascripts -->
    <script src="<?php echo e(asset('assets/plugins/jquery/jquery-3.4.1.min.js')); ?>"></script>
    <script src="https://unpkg.com/@popperjs/core@2"></script>
    <script src="<?php echo e(asset('assets/plugins/bootstrap/js/bootstrap.min.js')); ?>"></script>
    <script src="https://unpkg.com/feather-icons"></script>
    <script src="<?php echo e(asset('assets/plugins/perfectscroll/perfect-scrollbar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/apexcharts/apexcharts.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/main.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pages/dashboard.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pages/datatables.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/DataTables/datatables.min.js')); ?>"></script>
    <?php echo $__env->yieldContent('scripts'); ?>
    <?php echo \Livewire\Livewire::scripts(); ?>

    <script src="<?php echo e(asset('assets/js/sweetalert.js')); ?>"></script>
    <?php if (isset($component)) { $__componentOriginal8344cca362e924d63cb0780eb5ae3ae6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'livewire-alert::components.scripts','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('livewire-alert::scripts'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6)): ?>
<?php $attributes = $__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6; ?>
<?php unset($__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8344cca362e924d63cb0780eb5ae3ae6)): ?>
<?php $component = $__componentOriginal8344cca362e924d63cb0780eb5ae3ae6; ?>
<?php unset($__componentOriginal8344cca362e924d63cb0780eb5ae3ae6); ?>
<?php endif; ?>
</body>

</html>
<?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/layouts/auth.blade.php ENDPATH**/ ?>