<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
    <META NAME="ROBOTS" CONTENT="INDEX, FOLLOW">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(config('app.name', '')); ?></title>
    <link rel="icon" type="image/png" href="<?php echo e(asset('assets/images/logo.png')); ?>">
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/logo.png')); ?>" type="image/x-icon">

    <meta name="author" content="">
    <meta property="og:type" content="website" />
    <meta property="og:title" content="<?php echo e(config('app.name')); ?>" />
    <meta property="og:image" content="<?php echo e(asset('assets/images/logo.png')); ?>" />
    <meta property="og:description" content="" />

    <!-- Styles -->
    <link href="https://fonts.googleapis.com/css?family=Poppins:400,500,700,800&display=swap" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/font-awesome/css/all.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/perfectscroll/perfect-scrollbar.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/apexcharts/apexcharts.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/DataTables/datatables.min.css')); ?>" rel="stylesheet">

    <!-- Theme Styles -->
    <link href="<?php echo e(asset('assets/css/main.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/custom.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/sidebar-toggle-fix.css')); ?>" rel="stylesheet">
    <?php echo \Livewire\Livewire::styles(); ?>

    <?php echo view('laravel-trix::trixassets')->render(); ?>
    <style>
        .footer-text-left {
            font-size: 15px;
            padding-left: 500px;
            float: center;
            word-spacing: 20px;
        }
    </style>
</head>

<body>
    <div class='loader' wire:loading>
        <div class='spinner-grow text-primary' role='status'>
            <span class='sr-only'>Processando...</span>
        </div>
    </div>



    <div class="page-container">
        <?php if(request()->is('admin/*')): ?>
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('admin.inc.header', [])->html();
} elseif ($_instance->childHasBeenRendered('CxhvLZ0')) {
    $componentId = $_instance->getRenderedChildComponentId('CxhvLZ0');
    $componentTag = $_instance->getRenderedChildComponentTagName('CxhvLZ0');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('CxhvLZ0');
} else {
    $response = \Livewire\Livewire::mount('admin.inc.header', []);
    $html = $response->html();
    $_instance->logRenderedChild('CxhvLZ0', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('admin.inc.sidebar', [])->html();
} elseif ($_instance->childHasBeenRendered('WheOvKn')) {
    $componentId = $_instance->getRenderedChildComponentId('WheOvKn');
    $componentTag = $_instance->getRenderedChildComponentTagName('WheOvKn');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('WheOvKn');
} else {
    $response = \Livewire\Livewire::mount('admin.inc.sidebar', []);
    $html = $response->html();
    $_instance->logRenderedChild('WheOvKn', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
        <?php else: ?>
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('user.inc.header', [])->html();
} elseif ($_instance->childHasBeenRendered('hrvGe84')) {
    $componentId = $_instance->getRenderedChildComponentId('hrvGe84');
    $componentTag = $_instance->getRenderedChildComponentTagName('hrvGe84');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('hrvGe84');
} else {
    $response = \Livewire\Livewire::mount('user.inc.header', []);
    $html = $response->html();
    $_instance->logRenderedChild('hrvGe84', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('user.inc.sidebar', [])->html();
} elseif ($_instance->childHasBeenRendered('1uIHhn4')) {
    $componentId = $_instance->getRenderedChildComponentId('1uIHhn4');
    $componentTag = $_instance->getRenderedChildComponentTagName('1uIHhn4');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('1uIHhn4');
} else {
    $response = \Livewire\Livewire::mount('user.inc.sidebar', []);
    $html = $response->html();
    $_instance->logRenderedChild('1uIHhn4', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
        <?php endif; ?>
        <?php echo e($slot); ?>

        <div class="container">
            <div class="row">
                <div class="col-md-2"></div>
                     </div>
                </div>
                <div class="col-md-2"></div>
            </div>

        </div>


    </div>

    <!-- Javascripts -->
    <script src="<?php echo e(asset('assets/plugins/jquery/jquery-3.4.1.min.js')); ?>"></script>
    <script src="https://unpkg.com/@popperjs/core@2"></script>
    <script src="<?php echo e(asset('assets/plugins/bootstrap/js/bootstrap.min.js')); ?>"></script>
    <script src="https://unpkg.com/feather-icons"></script>
    <script src="<?php echo e(asset('assets/plugins/perfectscroll/perfect-scrollbar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/apexcharts/apexcharts.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/main.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/sidebar-fix.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pages/dashboard.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pages/datatables.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/DataTables/datatables.min.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <?php echo $__env->yieldContent('scripts'); ?>
    <script src="<?php echo e(asset('assets/js/sweetalert.js')); ?>"></script>
    <?php if (isset($component)) { $__componentOriginal8344cca362e924d63cb0780eb5ae3ae6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'livewire-alert::components.scripts','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('livewire-alert::scripts'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6)): ?>
<?php $attributes = $__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6; ?>
<?php unset($__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8344cca362e924d63cb0780eb5ae3ae6)): ?>
<?php $component = $__componentOriginal8344cca362e924d63cb0780eb5ae3ae6; ?>
<?php unset($__componentOriginal8344cca362e924d63cb0780eb5ae3ae6); ?>
<?php endif; ?>
    <?php echo \Livewire\Livewire::scripts(); ?>

</body>

</html>
<?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/layouts/app.blade.php ENDPATH**/ ?>