<?php

namespace App\Http\Livewire\Admin\Fee;

use App\Models\FeeMaster1;
use App\Models\User;
use App\Models\Classroom;
use Livewire\Component;
use App\Models\Fee_assign;
use Illuminate\Support\Collection;

class FeeCollect extends Component
{
    public $feeMaster;
    public $feeGroupName;
    public $feeTypeName;
    public $matchedFees;
    public $selectedClass = null;
    public $selectedTurma = null;
    public $selectedYear = null;
    public $searchTerm = '';
    public $turmas = [];
    public $students = [];
    public $selectedFeeGroup = null;
    public $selectedStudents = [];
    public $isLoading = false;
    public $availableYears = [];

    public function mount()
    {
        $this->feeGroupName = $this->feeMaster->feeGroup->name ?? 'N/A';
        $this->feeTypeName = $this->feeMaster->feeType->name ?? 'N/A';
        $this->loadAvailableYears();
    }

    protected function loadAvailableYears()
    {
        $this->availableYears = User::select('year_edu')
            ->whereNotNull('year_edu')
            ->distinct()
            ->orderBy('year_edu', 'desc')
            ->pluck('year_edu')
            ->filter()
            ->values()
            ->toArray();
            
        if (!empty($this->availableYears)) {
            $this->selectedYear = $this->availableYears[0];
        }
    }

    public function updatedSelectedClass($classId)
    {
        $this->reset(['selectedTurma', 'turmas', 'students']);
        
        if ($classId) {
            $this->turmas = Classroom::where('class', $classId)
                ->orderBy('name')
                ->get()
                ->unique('name')
                ->values();
        }
    }

    public function updatedSelectedTurma($turmaId)
    {
        $this->isLoading = true;
        $this->students = $this->getFilteredStudents($turmaId);
        $this->isLoading = false;
    }

    public function updatedSearchTerm()
    {
        if ($this->selectedTurma) {
            $this->students = $this->getFilteredStudents($this->selectedTurma);
        }
    }

    public function updatedSelectedYear()
    {
        if ($this->selectedTurma) {
            $this->students = $this->getFilteredStudents($this->selectedTurma);
        }
    }

    protected function getFilteredStudents($turmaId)
    {
        return User::where('classroom_id', $turmaId)
            ->when($this->selectedYear, function($query) {
                $query->where('year_edu', $this->selectedYear);
            })
            ->when($this->searchTerm, function($query) {
                $query->where(function($q) {
                    $q->where('name', 'like', '%'.$this->searchTerm.'%')
                      ->orWhere('email', 'like', '%'.$this->searchTerm.'%')
                      ->orWhere('student_id', 'like', '%'.$this->searchTerm.'%');
                });
            })
            ->orderBy('name', 'asc') // Ordem alfabética aqui
            ->get()
            ->toArray();
    }

    public function assignFeeGroup()
    {
        $this->validate([
            'selectedFeeGroup' => 'required|exists:fee_master1s,id',
            'selectedStudents' => 'required|array|min:1',
            'selectedStudents.*' => 'exists:users,id',
        ]);

        foreach ($this->selectedStudents as $studentId) {
            Fee_assign::create([
                'student_id' => $studentId,
                'fee_group_id' => $this->selectedFeeGroup,
                'status' => 'unpaid',
            ]);
        }

        session()->flash('message', 'Taxas cobradas com sucesso.');
        $this->reset(['selectedStudents']);
    }

    public function render()
    {
        $classes = Classroom::all()
            ->unique('class')
            ->sortBy('class')
            ->values();

        return view('livewire.admin.fee.fee-collect', [
            'classes' => $classes,
            'turmas' => $this->turmas,
            'feeGroupName' => $this->feeGroupName,
            'feeTypeName' => $this->feeTypeName,
            'matchedFees' => $this->matchedFees,
            'students' => collect($this->students),
            'availableYears' => $this->availableYears,
        ]);
    }
}
