<?php

namespace App\Http\Livewire\Admin\Fee;

use App\Models\FeeType;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;

class ListFeeTypes extends Component
{
    use WithPagination, FindGuard, LivewireAlert;

    public $search, $delete;
    protected $queryString = ['search'];
    protected string $paginationTheme = 'bootstrap';
    public bool $readyToLoad = false;

    protected $listeners = [
        'confirmed',
        'cancelled',
        'feeTypeDeleted' => '$refresh',
        'loadData', // Listen for external event
    ];

    /**
     * Resets pagination when searching
     */
    public function updatingSearch()
    {
        $this->resetPage();
    }

    /**
     * Load data when triggered
     */
    public function loadData()
    {
        $this->readyToLoad = true;
        $this->dispatchBrowserEvent('refreshTable'); // Ensure front-end updates
    }

    /**
     * Handles delete confirmation
     */
    public function submit($id)
    {
        $this->delete = FeeType::query()->firstWhere('id', $id);
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    /**
     * Delete FeeType and refresh data
     */
    public function confirmed()
    {
        FeeType::where('id', $this->delete->id)->delete();
        $this->reset(['delete']);
        $this->resetPage();
        $this->emitSelf('$refresh'); // Force refresh the component
        $this->alert('success', 'Deletado com sucesso');
    }

    /**
     * Handles cancellation
     */
    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    /**
     * Render Livewire component
     */
    public function render()
    {
        return view('livewire.admin.fee.list-fee-types', [
            'feeTypes' => $this->readyToLoad
                ? FeeType::query()
                    ->latest('updated_at')
                    ->where('name', 'like', '%' . $this->search . '%')
                    ->paginate(10)
                : []
        ]);
    }
}
