<?php

namespace App\Http\Livewire\User\Reports;

use App\Models\Classroom;
use App\Models\User;
use App\Models\Payment;
use App\Models\Project;
use App\Models\Subject;
use Illuminate\Support\Str;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Note\Note;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\ExportExams;
use App\Models\Exam;
use PDF;

class UserGenerateReport extends Component
{
    use FindGuard, LivewireAlert;

    public $trimester_id;
    public $class_id;
    public $user_id;
    public $subject_id;
    public $report = [];
    public $reports;
    public $user;
    public bool $readyToLoad = false;

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function loadReport()
    {
        $this->readyToLoad = true;
    }

    protected array $rules = [
        'user_id' => ['string', 'nullable'],
        'trimester_id' => ['numeric', 'required'],
        'class_id' => ['string', 'required'],
        'subject_id' => ['string', 'required']
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }
    /**
     * generate report
     * @throws Exception
     */
    public function generateReport()
    {
        $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        $this->user = $this->findGuardType()->user();
        Note::createSystemNotification(Admin::class, 'Relatórios', 'Relatório gerado com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Relatório gerado com sucesso');
        $users = Exam::query()->get();
        $models = [
            'title' => '',
            'date' => date('d/m/Y'),
            'models' => $users
        ];
        $pdf = PDF::loadView('exports.userreport', $models);
         // download PDF file with download method
        return $pdf->download('resultadoPDF.pdf');

    }

  


    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {

        return view('livewire.user.reports.user-generate-report', [
            'subjects' => Subject::query()->orderBy('name')->get(),
            'classes' => Classroom::query()->get(),
        ]);
    }
}
