<?php
$classroom__id = ''; // Inicializa a variável para evitar o erro
$classname = '';
$tri1 = [];
$tri2 = [];
$tri3 = [];
$portugues_final = null;
$matematica_final = null;
$mfd_count = 0;
$result = 0;
$all_subjects = [];
$ne_subjects3 = ['Português', 'Matemática'];
$ne_subjects6 = ['Português', 'Matemática', 'História', 'Geografia', 'Física', 'Química', 'Biologia', 'Ciências naturais', 'Ciências sociais', 'Filosofia'];
$ne_subjects = ['Português', 'Matemática', 'Inglês', 'História', 'Geografia', 'Física', 'Química', 'Biologia', 'Ciências naturais', 'Ciências sociais', 'Filosofia']; // Disciplinas com NE

// Obtendo dados da classe do estudante
$class_id = null;
foreach ($models as $model) {
    $class_id = \App\Models\Classroom::find($model->classroom_id);
    if ($class_id) {
        $classroom__id = $class_id->class ?? ''; // Define o ID da classe corretamente
        $classname = $class_id->name ?? '';
        break; // Apenas pega a primeira ocorrência
    }
}

// Obtendo disciplinas atribuídas à classe do estudante
if ($class_id) {
    //$assigned_subjects = \App\Models\TeacherSubject::where('classroom_id', $class_id->id)->pluck('subject_id')->toArray();
    $assigned_subjects = \App\Models\TeacherSubject::where('classroom_id', $class_id->id)->pluck('subject_id')->unique()->values()->toArray();
    
    //dd($assigned_subjects); // Veja se há IDs repetidos

    //$all_subjects = \App\Models\Subject::whereIn('id', $assigned_subjects)->pluck('name')->toArray() ?: ['Nenhuma Disciplina'];
    $all_subjects = \App\Models\Subject::whereIn('id', $assigned_subjects)->pluck('name')->unique()->sort()->values()->toArray() ?: ['Nenhuma Disciplina'];
}


$all_subjects = array_unique($all_subjects);
// Ordenar as disciplinas em ordem alfabética
sort($all_subjects);

// Inicializar notas com 0 para disciplinas sem dados
foreach ($all_subjects as $subject) {
    $tri1[$subject] = ['MT' => 0];
    $tri2[$subject] = ['MT' => 0];
    $tri3[$subject] = ['MT' => 0, 'NE' => 0];
}
?>


<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-size: 10px; }
        .header { text-align: center; }
        .logo { max-width: 100px; }
        table { width: 100%; border-collapse: collapse; font-size: 9px; }
        table, th, td { border: 1px solid #000; }
        th, td { padding: 4px; text-align: center; }
        th { background-color: #2596be; color: white; } /* Azul com letras brancas */
        .watermark { position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); opacity: 0.1; }
        .header-statement, .footer-statement {
                width: 100%;
                position: absolute;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                z-index: -1;
                display: flex;
                flex-direction: column;
                justify-content: space-between;
                align-items: center;
                color: rgba(0, 0, 0, 0.06); /* Transparência */
                font-size: 12px;
                text-transform: uppercase;
        }
            
        //.header-statement {
        //    top: 0px; text-align: center;
       //}
            
            
        //.footer-statement { bottom: 5px; text-align: center; }
    </style>
</head>
<body>
            
    <div class="header-statement">
            @for ($i = 0; $i < 100; $i++) <!-- Ajuste o número de repetições -->
                        <div>Este boletim gerado por computador, não poderá servir como declaração de notas para outros fins.</div>
            @endfor
    </div>
                
    <div class="header" style="margin-top: 15px;">
        <img src="data:image/png;base64,{{ base64_encode(file_get_contents('https://copmoz.ac.mz/wp-content/uploads/2023/08/Logotipo.png')) }}" width="100" height="100" alt="COPMOZ">
        <h3>{{ $title }}</h3>
        <h4>Nome: {{ $name }}</h4>
        <h4>ID do Estudante: {{ $id }}</h4>
        <p>Data de impressão: {{ $date }}</p>
        <p>{{ $classroom__id }} Classe - {{$classname}}</p>
    </div>

    <div class="watermark">
        <img src="data:image/png;base64,{{ base64_encode(file_get_contents('https://copmoz.ac.mz/wp-content/uploads/2023/08/Logotipo.png')) }}" width="400" height="400" alt="COPMOZ">
    </div>

            <table class="table table-hover">
                <thead>
                    <tr>
                        <th rowspan="2">Disciplina</th>
                        <th colspan="5">1° Trimestre</th>
                        <th colspan="5">2° Trimestre</th>
                        <th colspan="5">3° Trimestre</th>
                        @if($classroom__id == 3)
                            <th rowspan="2">AF</th>
                        @elseif($classroom__id == 6)
                            <th rowspan="2">NE</th>
                        @elseif($classroom__id == 10 || $classroom__id == 12)
                            <th rowspan="2">NE</th>
                        @endif
                        <th rowspan="2">MFD</th>
                    </tr>
                    <tr>
                        <th>ASC1</th><th>ASC2</th><th>MACS</th><th>AT</th><th>MT</th>
                        <th>ASC1</th><th>ASC2</th><th>MACS</th><th>AT</th><th>MT</th>
                        <th>ASC1</th><th>ASC2</th><th>MACS</th><th>AT</th><th>MT</th>
                    </tr>
                   </thead>
                            <tbody>
                                @foreach ($all_subjects as $subject)
                                    <?php
                                    $model1 = $models->where('trimester_id', 1)->where('subject.name', $subject)->first();
                                    $model2 = $models->where('trimester_id', 2)->where('subject.name', $subject)->first();
                                    $model3 = $models->where('trimester_id', 3)->where('subject.name', $subject)->first();
            
            
                                    $tri1[$subject]['MT'] = $model1 ? round(((intval($model1->ACS1a) + intval($model1->ACS2a)) + intval($model1->AT)) / 3) : 0;
                                    $tri2[$subject]['MT'] = $model2 ? round(((intval($model2->ACS1a) + intval($model2->ACS2a)) + intval($model2->AT)) / 3) : 0;
                                    $tri3[$subject]['MT'] = $model3 ? round(((intval($model3->ACS1a) + intval($model3->ACS2a)) + intval($model3->AT)) / 3) : 0;
                                    $tri3[$subject]['NE'] = intval($model3->NE ?? 0);

                                    $mfd = round(($tri1[$subject]['MT'] + $tri2[$subject]['MT'] + $tri3[$subject]['MT']) / 3);

                                    $final = (
                                        ($classroom__id == 3 && in_array($subject, $ne_subjects3)) ||
                                        ($classroom__id == 6 && in_array($subject, $ne_subjects6)) ||
                                        (($classroom__id == 10 || $classroom__id == 12) && in_array($subject, $ne_subjects))
                                    )
                                        ? round(($mfd * 2 + $tri3[$subject]['NE']) / 3)
                                        : $mfd;

                                    $mfd_count += $final;
                                    if ($subject === 'Português') $portugues_final = $final;
                                    if ($subject === 'Matemática') $matematica_final = $final;
                                    ?>
                                    <tr>
                                            <td>{{ $subject }}</td>
                                            <td>{{ $model1 && is_numeric($model1->ACS1a) ? $model1->ACS1a : 0 }}</td>
                                            <td>{{ $model1 && isset($model1->ACS2a) ? $model1->ACS2a : 0 }}</td>
                                            <td>{{ $model1 ? number_format((floatval($model1->ACS1a ?? 0) + floatval($model1->ACS2a ?? 0)) * 0.5, 2) : 0 }}</td>
                                            <td>{{ $model1->AT ?? 0 }}</td>
                                            <td>{{ $tri1[$subject]['MT'] ?? 0 }}</td>
                                            <td>{{ $model2 && is_numeric($model2->ACS1a) ? $model2->ACS1a : 0 }}</td>
                                            <td>{{ $model2 && isset($model2->ACS2a) ? $model2->ACS2a : 0 }}</td>
                                            <td>{{ $model2 ? number_format((floatval($model2->ACS1a ?? 0) + floatval($model2->ACS2a ?? 0)) * 0.5, 2) : 0 }}</td>
                                            <td>{{ $model2->AT ?? 0 }}</td>
                                            <td>{{ $tri2[$subject]['MT'] ?? 0 }}</td>
                                            <td>{{ $model3 && is_numeric($model3->ACS1a) ? $model3->ACS1a : 0 }}</td>
                                            <td>{{ $model3 && isset($model3->ACS2a) ? $model3->ACS2a : 0 }}</td>
                                            <td>{{ $model3 ? number_format((floatval($model3->ACS1a ?? 0) + floatval($model3->ACS2a ?? 0)) * 0.5, 2) : 0 }}</td>
                                            <td>{{ $model3->AT ?? 0 }}</td>
                                            <td>{{ $tri3[$subject]['MT'] ?? 0 }}</td>
                                            @if($classroom__id == 6)
                                                @if(in_array($subject, $ne_subjects6))
                                                    <td>{{ $tri3[$subject]['NE'] }}</td> <!-- Exibe NE normalmente -->
                                                @else
                                                    <td style="background-color: #000; color: #fff;"></td> <!-- Campo NE não aplicável (pintado de preto) -->
                                                @endif
                                            @elseif($classroom__id == 10 || $classroom__id == 12)
                                                @if(in_array($subject, $ne_subjects))
                                                    <td>{{ $tri3[$subject]['NE'] }}</td> <!-- Exibe NE normalmente -->
                                                @else
                                                    <td style="background-color: #000; color: #fff;"></td> <!-- Campo NE não aplicável (pintado de preto) -->
                                                @endif
                                            @elseif($classroom__id == 3)
                                                @if(in_array($subject, $ne_subjects3))
                                                    <td>{{ $tri3[$subject]['NE'] }}</td> <!-- Exibe NE como AF -->
                                                @else
                                                    <td style="background-color: #000; color: #fff;"></td> <!-- Campo AF não aplicável (pintado de preto) -->
                                                @endif
                                            @endif

                                        <td>{{ $final }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
            </table>


    <h2 style="text-align:center;">MFD: {{ round($mfd_count / count($all_subjects)) }}</h2>
                                            
    <p style="text-align:center; font-weight: bold; font-size: 12px; color: rgba(0, 0, 0, 0.5);"> Este boletim gerado por computador, não poderá servir como declaração de notas para outros fins. </p>
                                            
    <h2 style="text-align:center;">
    {{
        ($mfd_count / count($all_subjects)) < 10 ||
        (($portugues_final !== null && $portugues_final < 10) &&
            ($matematica_final !== null && $matematica_final < 10))
        ? ($classroom__id == 3
            ? 'REPROVADO'
            : ($classroom__id == 6 || $classroom__id == 10 || $classroom__id == 12 ? 'REPROVADO' : 'NÃO TRANSITA'))
        : ($classroom__id == 3
            ? 'APROVADO'
            : ($classroom__id == 6 || $classroom__id == 10 || $classroom__id == 12 ? 'APROVADO' : 'TRANSITA'))
    }}
    </h2>


    <div class="footer-statement" style="margin-bottom: 15px;">
        Este boletim gerado por computador, não poderá servir como declaração de notas para outros fins.       
    </div>

</body>
</html>
