<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Referência de Pagamento</title>
    <style>
        /* Margem padrão APA: 1 polegada = 25.4 mm */
        @page { size: A4; margin: 25.4mm; }

        * { box-sizing: border-box; margin: 0; padding: 0; }

        body {
            font-family: Arial, DejaVu Sans, sans-serif;
            color: #333;
            font-size: 11px;
            line-height: 1.35;
        }

        /* Contêiner centralizado e largura controlada */
        .page-wrap {
            max-width: 600px; /* ~15.9 cm */
            margin: 0 auto;
        }

        /* Tabelas não ocupam 100% e ficam centralizadas */
        table {
            width: auto !important;
            max-width: 100%;
            margin: 0 auto;
            border-collapse: collapse;
        }

        .header {
            text-align: center;
            margin-bottom: 15px;
            border-bottom: 1px solid #0066cc;
            padding-bottom: 10px;
        }
        .header h1 {
            color: #0066cc;
            font-size: 20px;
            margin-bottom: 4px;
        }
        .header p { font-size: 11px; }

        .info-section {
            margin: 10px 0;
            padding: 10px;
            background-color: #f8f9fa;
            border-radius: 4px;
        }
        .info-section h3 {
            font-size: 13px;
            margin-bottom: 6px;
        }
        .info-section p { margin: 2px 0; }

        .detail-row {
            display: flex;
            justify-content: space-between;
            gap: 8px;
            padding: 4px 0;
            border-bottom: 1px solid #eee;
        }
        .detail-row:last-child {
            border-bottom: none;
            font-weight: bold;
        }

        .entity-box {
            background: #28a745;
            color: white;
            padding: 12px;
            text-align: center;
            border-radius: 4px;
            margin: 12px 0;
        }
        .entity-box h3 {
            font-size: 13px;
            margin-bottom: 4px;
        }
        .entity-box div { font-size: 18px; font-weight: bold; }

        .payment-box {
            background: #0066cc;
            color: white;
            padding: 12px;
            text-align: center;
            border-radius: 4px;
            margin: 12px 0;
        }
        .payment-box h2 {
            font-size: 15px;
            margin-bottom: 4px;
            font-weight: 700;
        }
        .reference-number {
            font-size: 18px;
            font-weight: bold;
            letter-spacing: 1.5px;
            margin: 4px 0;
            font-family: monospace;
        }

        .expiry {
            background: #f8d7da;
            color: #721c24;
            padding: 8px;
            border-radius: 4px;
            text-align: center;
            margin: 10px 0;
            font-size: 11px;
        }

        .instructions {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            padding: 10px;
            border-radius: 4px;
            margin: 10px 0;
        }
        .instructions h4 {
            font-size: 13px;
            margin-bottom: 6px;
        }
        .instructions ul { margin-left: 16px; }
        .instructions li { margin: 3px 0; }

        .footer {
            text-align: center;
            margin-top: 15px;
            font-size: 10px;
            color: #666;
        }

        .no-break { page-break-inside: avoid; }
    </style>
</head>
<body>
    <div class="page-wrap">
        <div class="header no-break">
            <h1>Referência de Pagamento</h1>
            <p>Sistema de Pagamentos BCI</p>
        </div>

        <div class="info-section no-break">
            <h3>Informações do Estudante</h3>
            <p><strong>Nome:</strong> {{ $student->name ?? 'N/A' }}</p>
            <p><strong>ID:</strong> {{ $student->student_id ?? $student->id }}</p>
            @if(isset($student->class))
            <p><strong>Classe:</strong> {{ $student->class->class ?? 'N/A' }}</p>
            @endif
        </div>

        <div class="info-section no-break">
            <h3>Detalhes do Pagamento</h3>
            <div class="detail-row">
                <span>Período:</span>
                <span>{{ $payment->fee_month }}/{{ $payment->fee_year }}</span>
            </div>
            <div class="detail-row">
                <span>Valor a Pagar:</span>
                <span>{{ number_format($amount, 2, ',', '.') }} MT</span>
            </div>
            @if(isset($payment->note) && !empty($payment->note))
            <div class="detail-row">
                <span>Observações:</span>
                <span>{{ $payment->note }}</span>
            </div>
            @endif
        </div>

        <div class="entity-box no-break">
            <h3>Entidade</h3>
            <div>{{ $entity }}</div>
        </div>

        <div class="payment-box no-break">
            <h2>Referência</h2>
            <div class="reference-number">{{ $reference_formatted ?? $reference }}</div>
            @if(isset($reference_formatted))
            <p style="font-size: 10px; margin: 2px 0;">{{ $reference }}</p>
            @endif
        </div>

        <div class="expiry no-break">
            <strong>⚠️ Esta referência expira em {{ $expires_at->format('d/m/Y') }}</strong>
        </div>

        <div class="instructions no-break">
            <h4>Como Pagar:</h4>
            <ul>
                <li><strong>M-Pesa:</strong> Menu → Pagar Conta → Entidade: {{ $entity }} → Referência: {{ $reference }}</li>
                <li><strong>e-Mola:</strong> Pagar Serviços → Entidade: {{ $entity }} → Referência: {{ $reference }}</li>
                <li><strong>ATM:</strong> Pagar Serviços → Entidade: {{ $entity }} → Referência: {{ $reference }}</li>
                <li><strong>Banco:</strong> Apresente esta fatura no balcão</li>
            </ul>
        </div>

        <div class="footer no-break">
            <p>Documento gerado em {{ now()->format('d/m/Y H:i:s') }}</p>
            <p>Guarde este documento até à confirmação do pagamento</p>
        </div>
    </div>
</body>
</html>

