<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Referência de Pagamento</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            color: #333;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #0066cc;
            padding-bottom: 20px;
        }
        .header h1 {
            color: #0066cc;
            margin: 0;
        }
        .info-section {
            margin: 20px 0;
            padding: 15px;
            background-color: #f8f9fa;
            border-radius: 5px;
        }
        .payment-box {
            background: #0066cc;
            color: white;
            padding: 20px;
            text-align: center;
            border-radius: 5px;
            margin: 20px 0;
        }
        .reference-number {
            font-size: 24px;
            font-weight: bold;
            letter-spacing: 2px;
            margin: 10px 0;
        }
        .entity-box {
            background: #28a745;
            color: white;
            padding: 15px;
            text-align: center;
            border-radius: 5px;
            margin: 20px 0;
        }
        .instructions {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            font-size: 12px;
            color: #666;
        }
        .detail-row {
            display: flex;
            justify-content: space-between;
            padding: 5px 0;
            border-bottom: 1px solid #eee;
        }
        .detail-row:last-child {
            border-bottom: none;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Referência de Pagamento</h1>
        <p>Sistema de Pagamentos BCI/BMEPS</p>
    </div>

    <div class="info-section">
        <h3>Informações do Estudante</h3>
        <p><strong>Nome:</strong> {{ $student->name ?? 'N/A' }}</p>
        <p><strong>ID:</strong> {{ $student->student_id ?? $student->id }}</p>
        @if(isset($student->class))
        <p><strong>Classe:</strong> {{ $student->class->class ?? 'N/A' }}</p>
        @endif
    </div>

    <div class="info-section">
        <h3>Detalhes do Pagamento</h3>
        <div class="detail-row">
            <span>Período:</span>
            <span>{{ $payment->fee_month }}/{{ $payment->fee_year }}</span>
        </div>
        <div class="detail-row">
            <span>Valor a Pagar:</span>
            <span>{{ number_format($amount, 2, ',', '.') }} MT</span>
        </div>
        @if(isset($payment->note) && !empty($payment->note))
        <div class="detail-row">
            <span>Observações:</span>
            <span>{{ $payment->note }}</span>
        </div>
        @endif
    </div>

    <div class="entity-box">
        <h3>Entidade</h3>
        <div style="font-size: 20px; font-weight: bold;">{{ $entity }}</div>
    </div>

    <div class="payment-box">
        <h2>Referência</h2>
        <div class="reference-number">{{ $reference_formatted ?? $reference }}</div>
        @if(isset($reference_formatted))
        <p style="font-size: 14px; margin: 5px 0;">{{ $reference }}</p>
        @endif
    </div>

    <div style="background: #f8d7da; color: #721c24; padding: 10px; border-radius: 5px; text-align: center; margin: 15px 0;">
        <strong>⚠️ Esta referência expira em {{ $expires_at->format('d/m/Y') }}</strong>
    </div>

    <div class="instructions">
        <h4>Como Pagar:</h4>
        <ul>
            <li><strong>M-Pesa:</strong> Menu → Pagar Conta → Entidade: {{ $entity }} → Referência: {{ $reference }}</li>
            <li><strong>e-Mola:</strong> Pagar Serviços → Entidade: {{ $entity }} → Referência: {{ $reference }}</li>
            <li><strong>ATM:</strong> Pagar Serviços → Entidade: {{ $entity }} → Referência: {{ $reference }}</li>
            <li><strong>Banco:</strong> Apresente esta fatura no balcão</li>
        </ul>
    </div>

    <div class="footer">
        <p>Documento gerado em {{ now()->format('d/m/Y H:i:s') }}</p>
        <p>Guarde este documento até à confirmação do pagamento</p>
    </div>
</body>
</html>
