<div>
    <div class="page-content" wire:poll.keep-alive>
        <div class="main-wrapper" wire:init="loadData">
            <?php if(count($models)): ?>
                <div class="row">
                    <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-sm-12 col-md-4">
                            <div class="card bg-dark text-white">
                                <img src="<?php echo e($model->media_url); ?>" class="card-img" alt="...">
                                <div class="card-img-overlay">
                                    <h5 class="card-title"><?php echo e($model->title); ?></h5>
                                    <p class="card-text"><?php echo Str::limit($model->description, 220, ' .......'); ?></p>
                                    <p class="card-text">
                                        <a href="<?php echo e(route('user.show.book', $model->slug)); ?>"
                                            class="btn btn-outline-primary"><span class="fa fa-eye"></span>
                                        </a>
                                        <a href="<?php echo e(route('user.show.book.chapter', $model->slug)); ?>"
                                            class="btn btn-outline-primary"><span class="fa fa-eye">Mostrar capítulos <?php echo e($model->chapters->count()); ?></span>
                                        </a>
                                    </p>

                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="row float-end">
                    <?php echo e($models->links()); ?>

                </div>
            <?php else: ?>
                <br>
                <br>
                <div class="d-flex justify-content-center">
                    <div wire:loading class="spinner-border text-primary" role="status">
                        <span class="sr-only">Processando...</span>
                    </div>
                </div>
                <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
            <?php endif; ?>
        </div>

    </div>
</div>
<?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/livewire/user/books/user-show-completed-books.blade.php ENDPATH**/ ?>