<div>
    <div class="page-content" wire:init="loadData">
        <div class="main-wrapper" wire:init="loadData">
            <div class="row">
                <div class="col-md-12">
                    <input type="search" wire:model="search" placeholder="Pesquisar livro por: título, autor, nome da categoria..."
                           class="form-control">
                </div>
            </div>
            <br><br>

<style>
     .bookshelf .thumb {
    display: inline-block;
    cursor: pointer;
    margin: 0px 0.5%;
    width: 15% !important;
    box-shadow: 0px 1px 3px rgba(0, 0, 0, .3);
    max-width: 135px;
    width: 150px; /* Largura fixa desejada para as capas */
    height: 200px; /* Altura fixa desejada para as capas */
}
.bookshelf .thumb img {
    width: 100%;
    height: 100%; /* Largura e altura 100% para ajustar às dimensões fixas */
    display: block;
    vertical-align: top;
}
.bookshelf .shelf-img {
    z-index: 0;
    height: auto;
    max-width: 100%;
    vertical-align: top;
    margin-top: -12px;
}
.bookshelf .covers {
    width: 100%;
    height: auto;
    z-index: 99;
    position: relative;
    text-align: center;
}
.bookshelf {
    text-align: center;
    padding: 0px;

}

@media (max-width: 480px) {
        .bookshelf .thumb {
            max-width: 90px; /* Reduz a largura das capas */
            max-height: 95px; /* Reduz ainda mais a altura dos livros */
        }
    }

 </style>
 
 <script>
    // JavaScript para ajustar o número de livros por linha em dispositivos móveis
    window.addEventListener('resize', adjustLayout);

    function adjustLayout() {
        const screenWidth = window.innerWidth;

        if (screenWidth <= 800) {
            const books = document.querySelectorAll('.bookshelf .thumb');
            for (let i = 0; i < books.length; i += 2) {
                const book = books[i];
                book.style.width = '100%'; // 2 livros por linha
            }
        } else {
            const books = document.querySelectorAll('.bookshelf .thumb');
            for (let i = 0; i < books.length; i++) {
                const book = books[i];
                book.style.width = 'calc(33.33% - 20px)'; // 3 livros por linha
            }
        }
    }

    // Chame a função inicialmente para definir o layout correto
    adjustLayout();
</script>

            <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.js"></script>
            <link href="<?php echo e(asset('css/flipbook.style.css')); ?>" rel="stylesheet">
            <link href="<?php echo e(asset('css/font-awesome.css')); ?>" rel="stylesheet">

            <?php if(count($models)): ?>
                <div class="row">
                    <?php $booksPerShelf = 5; $i = 0; ?>

                    <?php $__currentLoopData = $models; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $model): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($i % $booksPerShelf === 0): ?>
                            <div class="bookshelf">
                                <div class="covers">
                        <?php endif; ?>

                        <a href="<?php echo e(route('user.pd', $model->slug)); ?>">
                            <div class="thumb book-<?php echo e($loop->index + 1); ?>">
                                <img src="<?php echo e($model->media_url); ?>">
                            </div>
                        </a>

                        <?php $i++; ?>

                        <?php if($i % $booksPerShelf === 0): ?>
                                </div>
                                <img class="shelf-img" src="<?php echo e(asset('images/shelf_glass.png')); ?>">
                            </div>
                        <?php endif; ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php if($i % $booksPerShelf !== 0): ?>
                            </div>
                            <img class="shelf-img" src="<?php echo e(asset('images/shelf_glass.png')); ?>">
                        </div>
                    <?php endif; ?>

                </div>
                <div class="row float-end">
                    <?php echo e($models->links()); ?>

                </div>
            <?php else: ?>
                <br>
                <br>
                <div class="d-flex justify-content-center">
                    <div wire:loading class="spinner-border text-primary" role="status">
                        <span class="sr-only">Processando...</span>
                    </div>
                </div>
                <p class="text-center"><b>Nenhum dado foi encontrado no momento.</b></p>
            <?php endif; ?>
        </div>
    </div>
</div>



<?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/livewire/user/books/list-books.blade.php ENDPATH**/ ?>