<!DOCTYPE html>
<html>

<head>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/flipbook.style.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/font-awesome.css')); ?>">
<style>    
[data-name="btnDownloadPages"] {
    display: none !important;
}

[data-name="btnPrint"] {
    display: none !important;
}

[data-name="btnDownloadPdf"] {
    display: none !important;
}
</style>
</head>

<body>
    <div id="container">
        <h2><?php echo e($book->title); ?>.</h2>
        <p><?php echo $book->description; ?></p>
        <p><?php echo e($book->author); ?></p>
        <img src="<?php echo e($book->media_url); ?>" style="height:500px; width:500px;" />
    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.8.3/jquery.js"></script>
    <script src="<?php echo e(asset('js/flipbook.min.js')); ?>"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            // Define your base64 encoded PDF content
            var base64Pdf = "<?php echo e($base64PDF); ?>";

            // Everything else is the same...

            // Convert the base64 content to a Blob
            var pdfBlob = b64toBlob(base64Pdf);

            // Create a URL for the Blob
            var pdfUrl = URL.createObjectURL(pdfBlob);

            // Initialize the flipBook with the base64 PDF
            $("#container").flipBook({
                pdfUrl: pdfUrl,
				disableDownloadButton: true
            });

            // Function to convert base64 to Blob
            function b64toBlob(b64Data, contentType) {
                contentType = contentType || '';
                var sliceSize = 512;
                var byteCharacters = atob(b64Data);
                var byteArrays = [];

                for (var offset = 0; offset < byteCharacters.length; offset += sliceSize) {
                    var slice = byteCharacters.slice(offset, offset + sliceSize);

                    var byteNumbers = new Array(slice.length);
                    for (var i = 0; i < slice.length; i++) {
                        byteNumbers[i] = slice.charCodeAt(i);
                    }

                    var byteArray = new Uint8Array(byteNumbers);
                    byteArrays.push(byteArray);
                }

                var blob = new Blob(byteArrays, { type: contentType });
                return blob;
            }
        });
    </script>
</body>
</html>
<?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/flipbook.blade.php ENDPATH**/ ?>